/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.CoalDelivery;
import fpml.confirmation.CoalProduct;
import fpml.confirmation.CommodityClassification;
import fpml.confirmation.CommodityDeliveryPeriods;
import fpml.confirmation.CommodityPhysicalQuantity;
import fpml.confirmation.PayerReceiverModel;
import fpml.confirmation.PhysicalSwapLeg;
import fpml.confirmation.meta.CoalPhysicalLegMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CoalPhysicalLeg", builder=CoalPhysicalLegBuilderImpl.class, version="0.17.2")
@RuneDataType(value="CoalPhysicalLeg", model="fpml", builder=CoalPhysicalLegBuilderImpl.class, version="0.17.2")
public interface CoalPhysicalLeg
extends PhysicalSwapLeg {
    public static final CoalPhysicalLegMeta metaData = new CoalPhysicalLegMeta();

    public CommodityDeliveryPeriods getDeliveryPeriods();

    public CoalProduct getCoal();

    public CoalDelivery getDeliveryConditions();

    public CommodityPhysicalQuantity getDeliveryQuantity();

    @Override
    public CoalPhysicalLeg build();

    @Override
    public CoalPhysicalLegBuilder toBuilder();

    public static CoalPhysicalLegBuilder builder() {
        return new CoalPhysicalLegBuilderImpl();
    }

    default public RosettaMetaData<? extends CoalPhysicalLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CoalPhysicalLeg> getType() {
        return CoalPhysicalLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.class, this.getCommodityClassification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryPeriods"), processor, CommodityDeliveryPeriods.class, this.getDeliveryPeriods(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("coal"), processor, CoalProduct.class, this.getCoal(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryConditions"), processor, CoalDelivery.class, this.getDeliveryConditions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryQuantity"), processor, CommodityPhysicalQuantity.class, this.getDeliveryQuantity(), new AttributeMeta[0]);
    }

    public static class CoalPhysicalLegBuilderImpl
    extends PhysicalSwapLeg.PhysicalSwapLegBuilderImpl
    implements CoalPhysicalLegBuilder {
        protected CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder deliveryPeriods;
        protected CoalProduct.CoalProductBuilder coal;
        protected CoalDelivery.CoalDeliveryBuilder deliveryConditions;
        protected CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder deliveryQuantity;

        @Override
        @RosettaAttribute(value="deliveryPeriods", isRequired=true)
        @RuneAttribute(value="deliveryPeriods", isRequired=true)
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getDeliveryPeriods() {
            return this.deliveryPeriods;
        }

        @Override
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getOrCreateDeliveryPeriods() {
            CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder result = this.deliveryPeriods != null ? this.deliveryPeriods : (this.deliveryPeriods = CommodityDeliveryPeriods.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="coal", isRequired=true)
        @RuneAttribute(value="coal", isRequired=true)
        public CoalProduct.CoalProductBuilder getCoal() {
            return this.coal;
        }

        @Override
        public CoalProduct.CoalProductBuilder getOrCreateCoal() {
            CoalProduct.CoalProductBuilder result = this.coal != null ? this.coal : (this.coal = CoalProduct.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions", isRequired=true)
        @RuneAttribute(value="deliveryConditions", isRequired=true)
        public CoalDelivery.CoalDeliveryBuilder getDeliveryConditions() {
            return this.deliveryConditions;
        }

        @Override
        public CoalDelivery.CoalDeliveryBuilder getOrCreateDeliveryConditions() {
            CoalDelivery.CoalDeliveryBuilder result = this.deliveryConditions != null ? this.deliveryConditions : (this.deliveryConditions = CoalDelivery.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryQuantity", isRequired=true)
        @RuneAttribute(value="deliveryQuantity", isRequired=true)
        public CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder getDeliveryQuantity() {
            return this.deliveryQuantity;
        }

        @Override
        public CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder getOrCreateDeliveryQuantity() {
            CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder result = this.deliveryQuantity != null ? this.deliveryQuantity : (this.deliveryQuantity = CommodityPhysicalQuantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CoalPhysicalLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityClassification")
        @RuneAttribute(value="commodityClassification")
        public CoalPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification) {
            if (_commodityClassification != null) {
                this.commodityClassification.add(_commodityClassification.toBuilder());
            }
            return this;
        }

        @Override
        public CoalPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification, int idx) {
            this.getIndex(this.commodityClassification, idx, () -> _commodityClassification.toBuilder());
            return this;
        }

        @Override
        public CoalPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            if (commodityClassifications != null) {
                for (CommodityClassification commodityClassification : commodityClassifications) {
                    this.commodityClassification.add(commodityClassification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="commodityClassification")
        public CoalPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            this.commodityClassification = commodityClassifications == null ? new ArrayList() : (List)commodityClassifications.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public CoalPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryPeriods", isRequired=true)
        @RuneAttribute(value="deliveryPeriods", isRequired=true)
        public CoalPhysicalLegBuilder setDeliveryPeriods(CommodityDeliveryPeriods _deliveryPeriods) {
            this.deliveryPeriods = _deliveryPeriods == null ? null : _deliveryPeriods.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="coal", isRequired=true)
        @RuneAttribute(value="coal", isRequired=true)
        public CoalPhysicalLegBuilder setCoal(CoalProduct _coal) {
            this.coal = _coal == null ? null : _coal.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions", isRequired=true)
        @RuneAttribute(value="deliveryConditions", isRequired=true)
        public CoalPhysicalLegBuilder setDeliveryConditions(CoalDelivery _deliveryConditions) {
            this.deliveryConditions = _deliveryConditions == null ? null : _deliveryConditions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryQuantity", isRequired=true)
        @RuneAttribute(value="deliveryQuantity", isRequired=true)
        public CoalPhysicalLegBuilder setDeliveryQuantity(CommodityPhysicalQuantity _deliveryQuantity) {
            this.deliveryQuantity = _deliveryQuantity == null ? null : _deliveryQuantity.toBuilder();
            return this;
        }

        @Override
        public CoalPhysicalLeg build() {
            return new CoalPhysicalLegImpl(this);
        }

        @Override
        public CoalPhysicalLegBuilder toBuilder() {
            return this;
        }

        @Override
        public CoalPhysicalLegBuilder prune() {
            super.prune();
            if (this.deliveryPeriods != null && !this.deliveryPeriods.prune().hasData()) {
                this.deliveryPeriods = null;
            }
            if (this.coal != null && !this.coal.prune().hasData()) {
                this.coal = null;
            }
            if (this.deliveryConditions != null && !this.deliveryConditions.prune().hasData()) {
                this.deliveryConditions = null;
            }
            if (this.deliveryQuantity != null && !this.deliveryQuantity.prune().hasData()) {
                this.deliveryQuantity = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDeliveryPeriods() != null && this.getDeliveryPeriods().hasData()) {
                return true;
            }
            if (this.getCoal() != null && this.getCoal().hasData()) {
                return true;
            }
            if (this.getDeliveryConditions() != null && this.getDeliveryConditions().hasData()) {
                return true;
            }
            return this.getDeliveryQuantity() != null && this.getDeliveryQuantity().hasData();
        }

        @Override
        public CoalPhysicalLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CoalPhysicalLegBuilder o = (CoalPhysicalLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryPeriods(), (RosettaModelObjectBuilder)o.getDeliveryPeriods(), this::setDeliveryPeriods);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCoal(), (RosettaModelObjectBuilder)o.getCoal(), this::setCoal);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryConditions(), (RosettaModelObjectBuilder)o.getDeliveryConditions(), this::setDeliveryConditions);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryQuantity(), (RosettaModelObjectBuilder)o.getDeliveryQuantity(), this::setDeliveryQuantity);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CoalPhysicalLeg _that = (CoalPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals(this.deliveryPeriods, _that.getDeliveryPeriods())) {
                return false;
            }
            if (!Objects.equals(this.coal, _that.getCoal())) {
                return false;
            }
            if (!Objects.equals(this.deliveryConditions, _that.getDeliveryConditions())) {
                return false;
            }
            return Objects.equals(this.deliveryQuantity, _that.getDeliveryQuantity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deliveryPeriods != null ? this.deliveryPeriods.hashCode() : 0);
            _result = 31 * _result + (this.coal != null ? this.coal.hashCode() : 0);
            _result = 31 * _result + (this.deliveryConditions != null ? this.deliveryConditions.hashCode() : 0);
            _result = 31 * _result + (this.deliveryQuantity != null ? this.deliveryQuantity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CoalPhysicalLegBuilder {deliveryPeriods=" + this.deliveryPeriods + ", coal=" + this.coal + ", deliveryConditions=" + this.deliveryConditions + ", deliveryQuantity=" + this.deliveryQuantity + '}' + " " + super.toString();
        }
    }

    public static interface CoalPhysicalLegBuilder
    extends CoalPhysicalLeg,
    PhysicalSwapLeg.PhysicalSwapLegBuilder {
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getOrCreateDeliveryPeriods();

        @Override
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getDeliveryPeriods();

        public CoalProduct.CoalProductBuilder getOrCreateCoal();

        @Override
        public CoalProduct.CoalProductBuilder getCoal();

        public CoalDelivery.CoalDeliveryBuilder getOrCreateDeliveryConditions();

        @Override
        public CoalDelivery.CoalDeliveryBuilder getDeliveryConditions();

        public CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder getOrCreateDeliveryQuantity();

        @Override
        public CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder getDeliveryQuantity();

        @Override
        public CoalPhysicalLegBuilder setId(String var1);

        @Override
        public CoalPhysicalLegBuilder addCommodityClassification(CommodityClassification var1);

        @Override
        public CoalPhysicalLegBuilder addCommodityClassification(CommodityClassification var1, int var2);

        @Override
        public CoalPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public CoalPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public CoalPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public CoalPhysicalLegBuilder setDeliveryPeriods(CommodityDeliveryPeriods var1);

        public CoalPhysicalLegBuilder setCoal(CoalProduct var1);

        public CoalPhysicalLegBuilder setDeliveryConditions(CoalDelivery var1);

        public CoalPhysicalLegBuilder setDeliveryQuantity(CommodityPhysicalQuantity var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.CommodityClassificationBuilder.class, this.getCommodityClassification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryPeriods"), processor, CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder.class, this.getDeliveryPeriods(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("coal"), processor, CoalProduct.CoalProductBuilder.class, this.getCoal(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryConditions"), processor, CoalDelivery.CoalDeliveryBuilder.class, this.getDeliveryConditions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryQuantity"), processor, CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder.class, this.getDeliveryQuantity(), new AttributeMeta[0]);
        }

        @Override
        public CoalPhysicalLegBuilder prune();
    }

    public static class CoalPhysicalLegImpl
    extends PhysicalSwapLeg.PhysicalSwapLegImpl
    implements CoalPhysicalLeg {
        private final CommodityDeliveryPeriods deliveryPeriods;
        private final CoalProduct coal;
        private final CoalDelivery deliveryConditions;
        private final CommodityPhysicalQuantity deliveryQuantity;

        protected CoalPhysicalLegImpl(CoalPhysicalLegBuilder builder) {
            super(builder);
            this.deliveryPeriods = Optional.ofNullable(builder.getDeliveryPeriods()).map(f -> f.build()).orElse(null);
            this.coal = Optional.ofNullable(builder.getCoal()).map(f -> f.build()).orElse(null);
            this.deliveryConditions = Optional.ofNullable(builder.getDeliveryConditions()).map(f -> f.build()).orElse(null);
            this.deliveryQuantity = Optional.ofNullable(builder.getDeliveryQuantity()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="deliveryPeriods", isRequired=true)
        @RuneAttribute(value="deliveryPeriods", isRequired=true)
        public CommodityDeliveryPeriods getDeliveryPeriods() {
            return this.deliveryPeriods;
        }

        @Override
        @RosettaAttribute(value="coal", isRequired=true)
        @RuneAttribute(value="coal", isRequired=true)
        public CoalProduct getCoal() {
            return this.coal;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions", isRequired=true)
        @RuneAttribute(value="deliveryConditions", isRequired=true)
        public CoalDelivery getDeliveryConditions() {
            return this.deliveryConditions;
        }

        @Override
        @RosettaAttribute(value="deliveryQuantity", isRequired=true)
        @RuneAttribute(value="deliveryQuantity", isRequired=true)
        public CommodityPhysicalQuantity getDeliveryQuantity() {
            return this.deliveryQuantity;
        }

        @Override
        public CoalPhysicalLeg build() {
            return this;
        }

        @Override
        public CoalPhysicalLegBuilder toBuilder() {
            CoalPhysicalLegBuilder builder = CoalPhysicalLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CoalPhysicalLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDeliveryPeriods()).ifPresent(builder::setDeliveryPeriods);
            Optional.ofNullable(this.getCoal()).ifPresent(builder::setCoal);
            Optional.ofNullable(this.getDeliveryConditions()).ifPresent(builder::setDeliveryConditions);
            Optional.ofNullable(this.getDeliveryQuantity()).ifPresent(builder::setDeliveryQuantity);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CoalPhysicalLeg _that = (CoalPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals(this.deliveryPeriods, _that.getDeliveryPeriods())) {
                return false;
            }
            if (!Objects.equals(this.coal, _that.getCoal())) {
                return false;
            }
            if (!Objects.equals(this.deliveryConditions, _that.getDeliveryConditions())) {
                return false;
            }
            return Objects.equals(this.deliveryQuantity, _that.getDeliveryQuantity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deliveryPeriods != null ? this.deliveryPeriods.hashCode() : 0);
            _result = 31 * _result + (this.coal != null ? this.coal.hashCode() : 0);
            _result = 31 * _result + (this.deliveryConditions != null ? this.deliveryConditions.hashCode() : 0);
            _result = 31 * _result + (this.deliveryQuantity != null ? this.deliveryQuantity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CoalPhysicalLeg {deliveryPeriods=" + this.deliveryPeriods + ", coal=" + this.coal + ", deliveryConditions=" + this.deliveryConditions + ", deliveryQuantity=" + this.deliveryQuantity + '}' + " " + super.toString();
        }
    }
}

