/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.PaymentCalculationPeriod;
import fpml.confirmation.PrincipalExchange;
import fpml.confirmation.meta.CashflowsMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Cashflows", builder=CashflowsBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Cashflows", model="fpml", builder=CashflowsBuilderImpl.class, version="0.17.2")
public interface Cashflows
extends RosettaModelObject {
    public static final CashflowsMeta metaData = new CashflowsMeta();

    public Boolean getCashflowsMatchParameters();

    public List<? extends PrincipalExchange> getPrincipalExchange();

    public List<? extends PaymentCalculationPeriod> getPaymentCalculationPeriod();

    public Cashflows build();

    public CashflowsBuilder toBuilder();

    public static CashflowsBuilder builder() {
        return new CashflowsBuilderImpl();
    }

    default public RosettaMetaData<? extends Cashflows> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Cashflows> getType() {
        return Cashflows.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("cashflowsMatchParameters"), Boolean.class, (Object)this.getCashflowsMatchParameters(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalExchange"), processor, PrincipalExchange.class, this.getPrincipalExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentCalculationPeriod"), processor, PaymentCalculationPeriod.class, this.getPaymentCalculationPeriod(), new AttributeMeta[0]);
    }

    public static class CashflowsBuilderImpl
    implements CashflowsBuilder {
        protected Boolean cashflowsMatchParameters;
        protected List<PrincipalExchange.PrincipalExchangeBuilder> principalExchange = new ArrayList<PrincipalExchange.PrincipalExchangeBuilder>();
        protected List<PaymentCalculationPeriod.PaymentCalculationPeriodBuilder> paymentCalculationPeriod = new ArrayList<PaymentCalculationPeriod.PaymentCalculationPeriodBuilder>();

        @Override
        @RosettaAttribute(value="cashflowsMatchParameters", isRequired=true)
        @RuneAttribute(value="cashflowsMatchParameters", isRequired=true)
        public Boolean getCashflowsMatchParameters() {
            return this.cashflowsMatchParameters;
        }

        @Override
        @RosettaAttribute(value="principalExchange")
        @RuneAttribute(value="principalExchange")
        public List<? extends PrincipalExchange.PrincipalExchangeBuilder> getPrincipalExchange() {
            return this.principalExchange;
        }

        @Override
        public PrincipalExchange.PrincipalExchangeBuilder getOrCreatePrincipalExchange(int index) {
            if (this.principalExchange == null) {
                this.principalExchange = new ArrayList<PrincipalExchange.PrincipalExchangeBuilder>();
            }
            return (PrincipalExchange.PrincipalExchangeBuilder)this.getIndex(this.principalExchange, index, () -> {
                PrincipalExchange.PrincipalExchangeBuilder newPrincipalExchange = PrincipalExchange.builder();
                return newPrincipalExchange;
            });
        }

        @Override
        @RosettaAttribute(value="paymentCalculationPeriod")
        @RuneAttribute(value="paymentCalculationPeriod")
        public List<? extends PaymentCalculationPeriod.PaymentCalculationPeriodBuilder> getPaymentCalculationPeriod() {
            return this.paymentCalculationPeriod;
        }

        @Override
        public PaymentCalculationPeriod.PaymentCalculationPeriodBuilder getOrCreatePaymentCalculationPeriod(int index) {
            if (this.paymentCalculationPeriod == null) {
                this.paymentCalculationPeriod = new ArrayList<PaymentCalculationPeriod.PaymentCalculationPeriodBuilder>();
            }
            return (PaymentCalculationPeriod.PaymentCalculationPeriodBuilder)this.getIndex(this.paymentCalculationPeriod, index, () -> {
                PaymentCalculationPeriod.PaymentCalculationPeriodBuilder newPaymentCalculationPeriod = PaymentCalculationPeriod.builder();
                return newPaymentCalculationPeriod;
            });
        }

        @Override
        @RosettaAttribute(value="cashflowsMatchParameters", isRequired=true)
        @RuneAttribute(value="cashflowsMatchParameters", isRequired=true)
        public CashflowsBuilder setCashflowsMatchParameters(Boolean _cashflowsMatchParameters) {
            this.cashflowsMatchParameters = _cashflowsMatchParameters == null ? null : _cashflowsMatchParameters;
            return this;
        }

        @Override
        @RosettaAttribute(value="principalExchange")
        @RuneAttribute(value="principalExchange")
        public CashflowsBuilder addPrincipalExchange(PrincipalExchange _principalExchange) {
            if (_principalExchange != null) {
                this.principalExchange.add(_principalExchange.toBuilder());
            }
            return this;
        }

        @Override
        public CashflowsBuilder addPrincipalExchange(PrincipalExchange _principalExchange, int idx) {
            this.getIndex(this.principalExchange, idx, () -> _principalExchange.toBuilder());
            return this;
        }

        @Override
        public CashflowsBuilder addPrincipalExchange(List<? extends PrincipalExchange> principalExchanges) {
            if (principalExchanges != null) {
                for (PrincipalExchange principalExchange : principalExchanges) {
                    this.principalExchange.add(principalExchange.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="principalExchange")
        public CashflowsBuilder setPrincipalExchange(List<? extends PrincipalExchange> principalExchanges) {
            this.principalExchange = principalExchanges == null ? new ArrayList<PrincipalExchange.PrincipalExchangeBuilder>() : (List)principalExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentCalculationPeriod")
        @RuneAttribute(value="paymentCalculationPeriod")
        public CashflowsBuilder addPaymentCalculationPeriod(PaymentCalculationPeriod _paymentCalculationPeriod) {
            if (_paymentCalculationPeriod != null) {
                this.paymentCalculationPeriod.add(_paymentCalculationPeriod.toBuilder());
            }
            return this;
        }

        @Override
        public CashflowsBuilder addPaymentCalculationPeriod(PaymentCalculationPeriod _paymentCalculationPeriod, int idx) {
            this.getIndex(this.paymentCalculationPeriod, idx, () -> _paymentCalculationPeriod.toBuilder());
            return this;
        }

        @Override
        public CashflowsBuilder addPaymentCalculationPeriod(List<? extends PaymentCalculationPeriod> paymentCalculationPeriods) {
            if (paymentCalculationPeriods != null) {
                for (PaymentCalculationPeriod paymentCalculationPeriod : paymentCalculationPeriods) {
                    this.paymentCalculationPeriod.add(paymentCalculationPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="paymentCalculationPeriod")
        public CashflowsBuilder setPaymentCalculationPeriod(List<? extends PaymentCalculationPeriod> paymentCalculationPeriods) {
            this.paymentCalculationPeriod = paymentCalculationPeriods == null ? new ArrayList<PaymentCalculationPeriod.PaymentCalculationPeriodBuilder>() : (List)paymentCalculationPeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Cashflows build() {
            return new CashflowsImpl(this);
        }

        @Override
        public CashflowsBuilder toBuilder() {
            return this;
        }

        @Override
        public CashflowsBuilder prune() {
            this.principalExchange = this.principalExchange.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.paymentCalculationPeriod = this.paymentCalculationPeriod.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCashflowsMatchParameters() != null) {
                return true;
            }
            if (this.getPrincipalExchange() != null && this.getPrincipalExchange().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPaymentCalculationPeriod() != null && this.getPaymentCalculationPeriod().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CashflowsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CashflowsBuilder o = (CashflowsBuilder)other;
            merger.mergeRosetta(this.getPrincipalExchange(), o.getPrincipalExchange(), this::getOrCreatePrincipalExchange);
            merger.mergeRosetta(this.getPaymentCalculationPeriod(), o.getPaymentCalculationPeriod(), this::getOrCreatePaymentCalculationPeriod);
            merger.mergeBasic((Object)this.getCashflowsMatchParameters(), (Object)o.getCashflowsMatchParameters(), this::setCashflowsMatchParameters, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Cashflows _that = this.getType().cast(o);
            if (!Objects.equals(this.cashflowsMatchParameters, _that.getCashflowsMatchParameters())) {
                return false;
            }
            if (!ListEquals.listEquals(this.principalExchange, _that.getPrincipalExchange())) {
                return false;
            }
            return ListEquals.listEquals(this.paymentCalculationPeriod, _that.getPaymentCalculationPeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashflowsMatchParameters != null ? this.cashflowsMatchParameters.hashCode() : 0);
            _result = 31 * _result + (this.principalExchange != null ? this.principalExchange.hashCode() : 0);
            _result = 31 * _result + (this.paymentCalculationPeriod != null ? this.paymentCalculationPeriod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashflowsBuilder {cashflowsMatchParameters=" + this.cashflowsMatchParameters + ", principalExchange=" + this.principalExchange + ", paymentCalculationPeriod=" + this.paymentCalculationPeriod + '}';
        }
    }

    public static interface CashflowsBuilder
    extends Cashflows,
    RosettaModelObjectBuilder {
        public PrincipalExchange.PrincipalExchangeBuilder getOrCreatePrincipalExchange(int var1);

        public List<? extends PrincipalExchange.PrincipalExchangeBuilder> getPrincipalExchange();

        public PaymentCalculationPeriod.PaymentCalculationPeriodBuilder getOrCreatePaymentCalculationPeriod(int var1);

        public List<? extends PaymentCalculationPeriod.PaymentCalculationPeriodBuilder> getPaymentCalculationPeriod();

        public CashflowsBuilder setCashflowsMatchParameters(Boolean var1);

        public CashflowsBuilder addPrincipalExchange(PrincipalExchange var1);

        public CashflowsBuilder addPrincipalExchange(PrincipalExchange var1, int var2);

        public CashflowsBuilder addPrincipalExchange(List<? extends PrincipalExchange> var1);

        public CashflowsBuilder setPrincipalExchange(List<? extends PrincipalExchange> var1);

        public CashflowsBuilder addPaymentCalculationPeriod(PaymentCalculationPeriod var1);

        public CashflowsBuilder addPaymentCalculationPeriod(PaymentCalculationPeriod var1, int var2);

        public CashflowsBuilder addPaymentCalculationPeriod(List<? extends PaymentCalculationPeriod> var1);

        public CashflowsBuilder setPaymentCalculationPeriod(List<? extends PaymentCalculationPeriod> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("cashflowsMatchParameters"), Boolean.class, (Object)this.getCashflowsMatchParameters(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalExchange"), processor, PrincipalExchange.PrincipalExchangeBuilder.class, this.getPrincipalExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentCalculationPeriod"), processor, PaymentCalculationPeriod.PaymentCalculationPeriodBuilder.class, this.getPaymentCalculationPeriod(), new AttributeMeta[0]);
        }

        public CashflowsBuilder prune();
    }

    public static class CashflowsImpl
    implements Cashflows {
        private final Boolean cashflowsMatchParameters;
        private final List<? extends PrincipalExchange> principalExchange;
        private final List<? extends PaymentCalculationPeriod> paymentCalculationPeriod;

        protected CashflowsImpl(CashflowsBuilder builder) {
            this.cashflowsMatchParameters = builder.getCashflowsMatchParameters();
            this.principalExchange = Optional.ofNullable(builder.getPrincipalExchange()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.paymentCalculationPeriod = Optional.ofNullable(builder.getPaymentCalculationPeriod()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="cashflowsMatchParameters", isRequired=true)
        @RuneAttribute(value="cashflowsMatchParameters", isRequired=true)
        public Boolean getCashflowsMatchParameters() {
            return this.cashflowsMatchParameters;
        }

        @Override
        @RosettaAttribute(value="principalExchange")
        @RuneAttribute(value="principalExchange")
        public List<? extends PrincipalExchange> getPrincipalExchange() {
            return this.principalExchange;
        }

        @Override
        @RosettaAttribute(value="paymentCalculationPeriod")
        @RuneAttribute(value="paymentCalculationPeriod")
        public List<? extends PaymentCalculationPeriod> getPaymentCalculationPeriod() {
            return this.paymentCalculationPeriod;
        }

        @Override
        public Cashflows build() {
            return this;
        }

        @Override
        public CashflowsBuilder toBuilder() {
            CashflowsBuilder builder = Cashflows.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashflowsBuilder builder) {
            Optional.ofNullable(this.getCashflowsMatchParameters()).ifPresent(builder::setCashflowsMatchParameters);
            Optional.ofNullable(this.getPrincipalExchange()).ifPresent(builder::setPrincipalExchange);
            Optional.ofNullable(this.getPaymentCalculationPeriod()).ifPresent(builder::setPaymentCalculationPeriod);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Cashflows _that = this.getType().cast(o);
            if (!Objects.equals(this.cashflowsMatchParameters, _that.getCashflowsMatchParameters())) {
                return false;
            }
            if (!ListEquals.listEquals(this.principalExchange, _that.getPrincipalExchange())) {
                return false;
            }
            return ListEquals.listEquals(this.paymentCalculationPeriod, _that.getPaymentCalculationPeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashflowsMatchParameters != null ? this.cashflowsMatchParameters.hashCode() : 0);
            _result = 31 * _result + (this.principalExchange != null ? this.principalExchange.hashCode() : 0);
            _result = 31 * _result + (this.paymentCalculationPeriod != null ? this.paymentCalculationPeriod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Cashflows {cashflowsMatchParameters=" + this.cashflowsMatchParameters + ", principalExchange=" + this.principalExchange + ", paymentCalculationPeriod=" + this.paymentCalculationPeriod + '}';
        }
    }
}

