/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.BusinessCenterTime;
import fpml.confirmation.Currency;
import fpml.confirmation.FixedRecoveryModel;
import fpml.confirmation.Money;
import fpml.confirmation.QuotationRateTypeEnum;
import fpml.confirmation.SettlementTerms;
import fpml.confirmation.ValuationDate;
import fpml.confirmation.ValuationMethodEnum;
import fpml.confirmation.meta.CashSettlementTermsMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CashSettlementTerms", builder=CashSettlementTermsBuilderImpl.class, version="0.17.2")
@RuneDataType(value="CashSettlementTerms", model="fpml", builder=CashSettlementTermsBuilderImpl.class, version="0.17.2")
public interface CashSettlementTerms
extends SettlementTerms {
    public static final CashSettlementTermsMeta metaData = new CashSettlementTermsMeta();

    public ValuationDate getValuationDate();

    public BusinessCenterTime getValuationTime();

    public QuotationRateTypeEnum getQuotationMethod();

    public Money getQuotationAmount();

    public Money getMinimumQuotationAmount();

    public List<String> getDealer();

    public Integer getCashSettlementBusinessDays();

    public FixedRecoveryModel getFixedRecoveryModel();

    public Boolean getFixedSettlement();

    public Boolean getAccruedInterest();

    public ValuationMethodEnum getValuationMethod();

    @Override
    public CashSettlementTerms build();

    @Override
    public CashSettlementTermsBuilder toBuilder();

    public static CashSettlementTermsBuilder builder() {
        return new CashSettlementTermsBuilderImpl();
    }

    default public RosettaMetaData<? extends CashSettlementTerms> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CashSettlementTerms> getType() {
        return CashSettlementTerms.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("settlementCurrency"), processor, Currency.class, this.getSettlementCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationDate"), processor, ValuationDate.class, this.getValuationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationTime"), processor, BusinessCenterTime.class, this.getValuationTime(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quotationMethod"), QuotationRateTypeEnum.class, (Object)this.getQuotationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotationAmount"), processor, Money.class, this.getQuotationAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minimumQuotationAmount"), processor, Money.class, this.getMinimumQuotationAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dealer"), String.class, this.getDealer(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cashSettlementBusinessDays"), Integer.class, (Object)this.getCashSettlementBusinessDays(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedRecoveryModel"), processor, FixedRecoveryModel.class, this.getFixedRecoveryModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedSettlement"), Boolean.class, (Object)this.getFixedSettlement(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("accruedInterest"), Boolean.class, (Object)this.getAccruedInterest(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationMethodEnum.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CashSettlementTermsBuilderImpl
    extends SettlementTerms.SettlementTermsBuilderImpl
    implements CashSettlementTermsBuilder {
        protected ValuationDate.ValuationDateBuilder valuationDate;
        protected BusinessCenterTime.BusinessCenterTimeBuilder valuationTime;
        protected QuotationRateTypeEnum quotationMethod;
        protected Money.MoneyBuilder quotationAmount;
        protected Money.MoneyBuilder minimumQuotationAmount;
        protected List<String> dealer = new ArrayList<String>();
        protected Integer cashSettlementBusinessDays;
        protected FixedRecoveryModel.FixedRecoveryModelBuilder fixedRecoveryModel;
        protected Boolean fixedSettlement;
        protected Boolean accruedInterest;
        protected ValuationMethodEnum valuationMethod;

        @Override
        @RosettaAttribute(value="valuationDate")
        @RuneAttribute(value="valuationDate")
        public ValuationDate.ValuationDateBuilder getValuationDate() {
            return this.valuationDate;
        }

        @Override
        public ValuationDate.ValuationDateBuilder getOrCreateValuationDate() {
            ValuationDate.ValuationDateBuilder result = this.valuationDate != null ? this.valuationDate : (this.valuationDate = ValuationDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="valuationTime")
        @RuneAttribute(value="valuationTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getValuationTime() {
            return this.valuationTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateValuationTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.valuationTime != null ? this.valuationTime : (this.valuationTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quotationMethod")
        @RuneAttribute(value="quotationMethod")
        public QuotationRateTypeEnum getQuotationMethod() {
            return this.quotationMethod;
        }

        @Override
        @RosettaAttribute(value="quotationAmount")
        @RuneAttribute(value="quotationAmount")
        public Money.MoneyBuilder getQuotationAmount() {
            return this.quotationAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateQuotationAmount() {
            Money.MoneyBuilder result = this.quotationAmount != null ? this.quotationAmount : (this.quotationAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="minimumQuotationAmount")
        @RuneAttribute(value="minimumQuotationAmount")
        public Money.MoneyBuilder getMinimumQuotationAmount() {
            return this.minimumQuotationAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateMinimumQuotationAmount() {
            Money.MoneyBuilder result = this.minimumQuotationAmount != null ? this.minimumQuotationAmount : (this.minimumQuotationAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealer")
        @RuneAttribute(value="dealer")
        public List<String> getDealer() {
            return this.dealer;
        }

        @Override
        @RosettaAttribute(value="cashSettlementBusinessDays")
        @RuneAttribute(value="cashSettlementBusinessDays")
        public Integer getCashSettlementBusinessDays() {
            return this.cashSettlementBusinessDays;
        }

        @Override
        @RosettaAttribute(value="fixedRecoveryModel")
        @RuneAttribute(value="fixedRecoveryModel")
        public FixedRecoveryModel.FixedRecoveryModelBuilder getFixedRecoveryModel() {
            return this.fixedRecoveryModel;
        }

        @Override
        public FixedRecoveryModel.FixedRecoveryModelBuilder getOrCreateFixedRecoveryModel() {
            FixedRecoveryModel.FixedRecoveryModelBuilder result = this.fixedRecoveryModel != null ? this.fixedRecoveryModel : (this.fixedRecoveryModel = FixedRecoveryModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedSettlement")
        @RuneAttribute(value="fixedSettlement")
        public Boolean getFixedSettlement() {
            return this.fixedSettlement;
        }

        @Override
        @RosettaAttribute(value="accruedInterest")
        @RuneAttribute(value="accruedInterest")
        public Boolean getAccruedInterest() {
            return this.accruedInterest;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ValuationMethodEnum getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public CashSettlementTermsBuilder setSettlementCurrency(Currency _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CashSettlementTermsBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationDate")
        @RuneAttribute(value="valuationDate")
        public CashSettlementTermsBuilder setValuationDate(ValuationDate _valuationDate) {
            this.valuationDate = _valuationDate == null ? null : _valuationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTime")
        @RuneAttribute(value="valuationTime")
        public CashSettlementTermsBuilder setValuationTime(BusinessCenterTime _valuationTime) {
            this.valuationTime = _valuationTime == null ? null : _valuationTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quotationMethod")
        @RuneAttribute(value="quotationMethod")
        public CashSettlementTermsBuilder setQuotationMethod(QuotationRateTypeEnum _quotationMethod) {
            this.quotationMethod = _quotationMethod == null ? null : _quotationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="quotationAmount")
        @RuneAttribute(value="quotationAmount")
        public CashSettlementTermsBuilder setQuotationAmount(Money _quotationAmount) {
            this.quotationAmount = _quotationAmount == null ? null : _quotationAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="minimumQuotationAmount")
        @RuneAttribute(value="minimumQuotationAmount")
        public CashSettlementTermsBuilder setMinimumQuotationAmount(Money _minimumQuotationAmount) {
            this.minimumQuotationAmount = _minimumQuotationAmount == null ? null : _minimumQuotationAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealer")
        @RuneAttribute(value="dealer")
        public CashSettlementTermsBuilder addDealer(String _dealer) {
            if (_dealer != null) {
                this.dealer.add(_dealer);
            }
            return this;
        }

        @Override
        public CashSettlementTermsBuilder addDealer(String _dealer, int idx) {
            this.getIndex(this.dealer, idx, () -> _dealer);
            return this;
        }

        @Override
        public CashSettlementTermsBuilder addDealer(List<String> dealers) {
            if (dealers != null) {
                for (String toAdd : dealers) {
                    this.dealer.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="dealer")
        public CashSettlementTermsBuilder setDealer(List<String> dealers) {
            this.dealer = dealers == null ? new ArrayList<String>() : (List)dealers.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="cashSettlementBusinessDays")
        @RuneAttribute(value="cashSettlementBusinessDays")
        public CashSettlementTermsBuilder setCashSettlementBusinessDays(Integer _cashSettlementBusinessDays) {
            this.cashSettlementBusinessDays = _cashSettlementBusinessDays == null ? null : _cashSettlementBusinessDays;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRecoveryModel")
        @RuneAttribute(value="fixedRecoveryModel")
        public CashSettlementTermsBuilder setFixedRecoveryModel(FixedRecoveryModel _fixedRecoveryModel) {
            this.fixedRecoveryModel = _fixedRecoveryModel == null ? null : _fixedRecoveryModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedSettlement")
        @RuneAttribute(value="fixedSettlement")
        public CashSettlementTermsBuilder setFixedSettlement(Boolean _fixedSettlement) {
            this.fixedSettlement = _fixedSettlement == null ? null : _fixedSettlement;
            return this;
        }

        @Override
        @RosettaAttribute(value="accruedInterest")
        @RuneAttribute(value="accruedInterest")
        public CashSettlementTermsBuilder setAccruedInterest(Boolean _accruedInterest) {
            this.accruedInterest = _accruedInterest == null ? null : _accruedInterest;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public CashSettlementTermsBuilder setValuationMethod(ValuationMethodEnum _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        public CashSettlementTerms build() {
            return new CashSettlementTermsImpl(this);
        }

        @Override
        public CashSettlementTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public CashSettlementTermsBuilder prune() {
            super.prune();
            if (this.valuationDate != null && !this.valuationDate.prune().hasData()) {
                this.valuationDate = null;
            }
            if (this.valuationTime != null && !this.valuationTime.prune().hasData()) {
                this.valuationTime = null;
            }
            if (this.quotationAmount != null && !this.quotationAmount.prune().hasData()) {
                this.quotationAmount = null;
            }
            if (this.minimumQuotationAmount != null && !this.minimumQuotationAmount.prune().hasData()) {
                this.minimumQuotationAmount = null;
            }
            if (this.fixedRecoveryModel != null && !this.fixedRecoveryModel.prune().hasData()) {
                this.fixedRecoveryModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getValuationDate() != null && this.getValuationDate().hasData()) {
                return true;
            }
            if (this.getValuationTime() != null && this.getValuationTime().hasData()) {
                return true;
            }
            if (this.getQuotationMethod() != null) {
                return true;
            }
            if (this.getQuotationAmount() != null && this.getQuotationAmount().hasData()) {
                return true;
            }
            if (this.getMinimumQuotationAmount() != null && this.getMinimumQuotationAmount().hasData()) {
                return true;
            }
            if (this.getDealer() != null && !this.getDealer().isEmpty()) {
                return true;
            }
            if (this.getCashSettlementBusinessDays() != null) {
                return true;
            }
            if (this.getFixedRecoveryModel() != null && this.getFixedRecoveryModel().hasData()) {
                return true;
            }
            if (this.getFixedSettlement() != null) {
                return true;
            }
            if (this.getAccruedInterest() != null) {
                return true;
            }
            return this.getValuationMethod() != null;
        }

        @Override
        public CashSettlementTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CashSettlementTermsBuilder o = (CashSettlementTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationDate(), (RosettaModelObjectBuilder)o.getValuationDate(), this::setValuationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationTime(), (RosettaModelObjectBuilder)o.getValuationTime(), this::setValuationTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotationAmount(), (RosettaModelObjectBuilder)o.getQuotationAmount(), this::setQuotationAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinimumQuotationAmount(), (RosettaModelObjectBuilder)o.getMinimumQuotationAmount(), this::setMinimumQuotationAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedRecoveryModel(), (RosettaModelObjectBuilder)o.getFixedRecoveryModel(), this::setFixedRecoveryModel);
            merger.mergeBasic((Object)this.getQuotationMethod(), (Object)o.getQuotationMethod(), this::setQuotationMethod, new AttributeMeta[0]);
            merger.mergeBasic(this.getDealer(), o.getDealer(), this::addDealer);
            merger.mergeBasic((Object)this.getCashSettlementBusinessDays(), (Object)o.getCashSettlementBusinessDays(), this::setCashSettlementBusinessDays, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedSettlement(), (Object)o.getFixedSettlement(), this::setFixedSettlement, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAccruedInterest(), (Object)o.getAccruedInterest(), this::setAccruedInterest, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationMethod(), (Object)o.getValuationMethod(), this::setValuationMethod, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CashSettlementTerms _that = (CashSettlementTerms)this.getType().cast(o);
            if (!Objects.equals(this.valuationDate, _that.getValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.valuationTime, _that.getValuationTime())) {
                return false;
            }
            if (!Objects.equals((Object)this.quotationMethod, (Object)_that.getQuotationMethod())) {
                return false;
            }
            if (!Objects.equals(this.quotationAmount, _that.getQuotationAmount())) {
                return false;
            }
            if (!Objects.equals(this.minimumQuotationAmount, _that.getMinimumQuotationAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dealer, _that.getDealer())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlementBusinessDays, _that.getCashSettlementBusinessDays())) {
                return false;
            }
            if (!Objects.equals(this.fixedRecoveryModel, _that.getFixedRecoveryModel())) {
                return false;
            }
            if (!Objects.equals(this.fixedSettlement, _that.getFixedSettlement())) {
                return false;
            }
            if (!Objects.equals(this.accruedInterest, _that.getAccruedInterest())) {
                return false;
            }
            return Objects.equals((Object)this.valuationMethod, (Object)_that.getValuationMethod());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.valuationDate != null ? this.valuationDate.hashCode() : 0);
            _result = 31 * _result + (this.valuationTime != null ? this.valuationTime.hashCode() : 0);
            _result = 31 * _result + (this.quotationMethod != null ? ((Object)((Object)this.quotationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quotationAmount != null ? this.quotationAmount.hashCode() : 0);
            _result = 31 * _result + (this.minimumQuotationAmount != null ? this.minimumQuotationAmount.hashCode() : 0);
            _result = 31 * _result + (this.dealer != null ? this.dealer.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlementBusinessDays != null ? this.cashSettlementBusinessDays.hashCode() : 0);
            _result = 31 * _result + (this.fixedRecoveryModel != null ? this.fixedRecoveryModel.hashCode() : 0);
            _result = 31 * _result + (this.fixedSettlement != null ? this.fixedSettlement.hashCode() : 0);
            _result = 31 * _result + (this.accruedInterest != null ? this.accruedInterest.hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? ((Object)((Object)this.valuationMethod)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CashSettlementTermsBuilder {valuationDate=" + this.valuationDate + ", valuationTime=" + this.valuationTime + ", quotationMethod=" + (Object)((Object)this.quotationMethod) + ", quotationAmount=" + this.quotationAmount + ", minimumQuotationAmount=" + this.minimumQuotationAmount + ", dealer=" + this.dealer + ", cashSettlementBusinessDays=" + this.cashSettlementBusinessDays + ", fixedRecoveryModel=" + this.fixedRecoveryModel + ", fixedSettlement=" + this.fixedSettlement + ", accruedInterest=" + this.accruedInterest + ", valuationMethod=" + (Object)((Object)this.valuationMethod) + '}' + " " + super.toString();
        }
    }

    public static interface CashSettlementTermsBuilder
    extends CashSettlementTerms,
    SettlementTerms.SettlementTermsBuilder {
        public ValuationDate.ValuationDateBuilder getOrCreateValuationDate();

        @Override
        public ValuationDate.ValuationDateBuilder getValuationDate();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateValuationTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getValuationTime();

        public Money.MoneyBuilder getOrCreateQuotationAmount();

        @Override
        public Money.MoneyBuilder getQuotationAmount();

        public Money.MoneyBuilder getOrCreateMinimumQuotationAmount();

        @Override
        public Money.MoneyBuilder getMinimumQuotationAmount();

        public FixedRecoveryModel.FixedRecoveryModelBuilder getOrCreateFixedRecoveryModel();

        @Override
        public FixedRecoveryModel.FixedRecoveryModelBuilder getFixedRecoveryModel();

        @Override
        public CashSettlementTermsBuilder setSettlementCurrency(Currency var1);

        @Override
        public CashSettlementTermsBuilder setId(String var1);

        public CashSettlementTermsBuilder setValuationDate(ValuationDate var1);

        public CashSettlementTermsBuilder setValuationTime(BusinessCenterTime var1);

        public CashSettlementTermsBuilder setQuotationMethod(QuotationRateTypeEnum var1);

        public CashSettlementTermsBuilder setQuotationAmount(Money var1);

        public CashSettlementTermsBuilder setMinimumQuotationAmount(Money var1);

        public CashSettlementTermsBuilder addDealer(String var1);

        public CashSettlementTermsBuilder addDealer(String var1, int var2);

        public CashSettlementTermsBuilder addDealer(List<String> var1);

        public CashSettlementTermsBuilder setDealer(List<String> var1);

        public CashSettlementTermsBuilder setCashSettlementBusinessDays(Integer var1);

        public CashSettlementTermsBuilder setFixedRecoveryModel(FixedRecoveryModel var1);

        public CashSettlementTermsBuilder setFixedSettlement(Boolean var1);

        public CashSettlementTermsBuilder setAccruedInterest(Boolean var1);

        public CashSettlementTermsBuilder setValuationMethod(ValuationMethodEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("settlementCurrency"), processor, Currency.CurrencyBuilder.class, (RosettaModelObjectBuilder)this.getSettlementCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationDate"), processor, ValuationDate.ValuationDateBuilder.class, this.getValuationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getValuationTime(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quotationMethod"), QuotationRateTypeEnum.class, (Object)this.getQuotationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotationAmount"), processor, Money.MoneyBuilder.class, this.getQuotationAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minimumQuotationAmount"), processor, Money.MoneyBuilder.class, this.getMinimumQuotationAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dealer"), String.class, this.getDealer(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cashSettlementBusinessDays"), Integer.class, (Object)this.getCashSettlementBusinessDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedRecoveryModel"), processor, FixedRecoveryModel.FixedRecoveryModelBuilder.class, this.getFixedRecoveryModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedSettlement"), Boolean.class, (Object)this.getFixedSettlement(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("accruedInterest"), Boolean.class, (Object)this.getAccruedInterest(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationMethodEnum.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CashSettlementTermsBuilder prune();
    }

    public static class CashSettlementTermsImpl
    extends SettlementTerms.SettlementTermsImpl
    implements CashSettlementTerms {
        private final ValuationDate valuationDate;
        private final BusinessCenterTime valuationTime;
        private final QuotationRateTypeEnum quotationMethod;
        private final Money quotationAmount;
        private final Money minimumQuotationAmount;
        private final List<String> dealer;
        private final Integer cashSettlementBusinessDays;
        private final FixedRecoveryModel fixedRecoveryModel;
        private final Boolean fixedSettlement;
        private final Boolean accruedInterest;
        private final ValuationMethodEnum valuationMethod;

        protected CashSettlementTermsImpl(CashSettlementTermsBuilder builder) {
            super(builder);
            this.valuationDate = Optional.ofNullable(builder.getValuationDate()).map(f -> f.build()).orElse(null);
            this.valuationTime = Optional.ofNullable(builder.getValuationTime()).map(f -> f.build()).orElse(null);
            this.quotationMethod = builder.getQuotationMethod();
            this.quotationAmount = Optional.ofNullable(builder.getQuotationAmount()).map(f -> f.build()).orElse(null);
            this.minimumQuotationAmount = Optional.ofNullable(builder.getMinimumQuotationAmount()).map(f -> f.build()).orElse(null);
            this.dealer = Optional.ofNullable(builder.getDealer()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.cashSettlementBusinessDays = builder.getCashSettlementBusinessDays();
            this.fixedRecoveryModel = Optional.ofNullable(builder.getFixedRecoveryModel()).map(f -> f.build()).orElse(null);
            this.fixedSettlement = builder.getFixedSettlement();
            this.accruedInterest = builder.getAccruedInterest();
            this.valuationMethod = builder.getValuationMethod();
        }

        @Override
        @RosettaAttribute(value="valuationDate")
        @RuneAttribute(value="valuationDate")
        public ValuationDate getValuationDate() {
            return this.valuationDate;
        }

        @Override
        @RosettaAttribute(value="valuationTime")
        @RuneAttribute(value="valuationTime")
        public BusinessCenterTime getValuationTime() {
            return this.valuationTime;
        }

        @Override
        @RosettaAttribute(value="quotationMethod")
        @RuneAttribute(value="quotationMethod")
        public QuotationRateTypeEnum getQuotationMethod() {
            return this.quotationMethod;
        }

        @Override
        @RosettaAttribute(value="quotationAmount")
        @RuneAttribute(value="quotationAmount")
        public Money getQuotationAmount() {
            return this.quotationAmount;
        }

        @Override
        @RosettaAttribute(value="minimumQuotationAmount")
        @RuneAttribute(value="minimumQuotationAmount")
        public Money getMinimumQuotationAmount() {
            return this.minimumQuotationAmount;
        }

        @Override
        @RosettaAttribute(value="dealer")
        @RuneAttribute(value="dealer")
        public List<String> getDealer() {
            return this.dealer;
        }

        @Override
        @RosettaAttribute(value="cashSettlementBusinessDays")
        @RuneAttribute(value="cashSettlementBusinessDays")
        public Integer getCashSettlementBusinessDays() {
            return this.cashSettlementBusinessDays;
        }

        @Override
        @RosettaAttribute(value="fixedRecoveryModel")
        @RuneAttribute(value="fixedRecoveryModel")
        public FixedRecoveryModel getFixedRecoveryModel() {
            return this.fixedRecoveryModel;
        }

        @Override
        @RosettaAttribute(value="fixedSettlement")
        @RuneAttribute(value="fixedSettlement")
        public Boolean getFixedSettlement() {
            return this.fixedSettlement;
        }

        @Override
        @RosettaAttribute(value="accruedInterest")
        @RuneAttribute(value="accruedInterest")
        public Boolean getAccruedInterest() {
            return this.accruedInterest;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ValuationMethodEnum getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        public CashSettlementTerms build() {
            return this;
        }

        @Override
        public CashSettlementTermsBuilder toBuilder() {
            CashSettlementTermsBuilder builder = CashSettlementTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashSettlementTermsBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getValuationDate()).ifPresent(builder::setValuationDate);
            Optional.ofNullable(this.getValuationTime()).ifPresent(builder::setValuationTime);
            Optional.ofNullable(this.getQuotationMethod()).ifPresent(builder::setQuotationMethod);
            Optional.ofNullable(this.getQuotationAmount()).ifPresent(builder::setQuotationAmount);
            Optional.ofNullable(this.getMinimumQuotationAmount()).ifPresent(builder::setMinimumQuotationAmount);
            Optional.ofNullable(this.getDealer()).ifPresent(builder::setDealer);
            Optional.ofNullable(this.getCashSettlementBusinessDays()).ifPresent(builder::setCashSettlementBusinessDays);
            Optional.ofNullable(this.getFixedRecoveryModel()).ifPresent(builder::setFixedRecoveryModel);
            Optional.ofNullable(this.getFixedSettlement()).ifPresent(builder::setFixedSettlement);
            Optional.ofNullable(this.getAccruedInterest()).ifPresent(builder::setAccruedInterest);
            Optional.ofNullable(this.getValuationMethod()).ifPresent(builder::setValuationMethod);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CashSettlementTerms _that = (CashSettlementTerms)this.getType().cast(o);
            if (!Objects.equals(this.valuationDate, _that.getValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.valuationTime, _that.getValuationTime())) {
                return false;
            }
            if (!Objects.equals((Object)this.quotationMethod, (Object)_that.getQuotationMethod())) {
                return false;
            }
            if (!Objects.equals(this.quotationAmount, _that.getQuotationAmount())) {
                return false;
            }
            if (!Objects.equals(this.minimumQuotationAmount, _that.getMinimumQuotationAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dealer, _that.getDealer())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlementBusinessDays, _that.getCashSettlementBusinessDays())) {
                return false;
            }
            if (!Objects.equals(this.fixedRecoveryModel, _that.getFixedRecoveryModel())) {
                return false;
            }
            if (!Objects.equals(this.fixedSettlement, _that.getFixedSettlement())) {
                return false;
            }
            if (!Objects.equals(this.accruedInterest, _that.getAccruedInterest())) {
                return false;
            }
            return Objects.equals((Object)this.valuationMethod, (Object)_that.getValuationMethod());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.valuationDate != null ? this.valuationDate.hashCode() : 0);
            _result = 31 * _result + (this.valuationTime != null ? this.valuationTime.hashCode() : 0);
            _result = 31 * _result + (this.quotationMethod != null ? ((Object)((Object)this.quotationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quotationAmount != null ? this.quotationAmount.hashCode() : 0);
            _result = 31 * _result + (this.minimumQuotationAmount != null ? this.minimumQuotationAmount.hashCode() : 0);
            _result = 31 * _result + (this.dealer != null ? this.dealer.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlementBusinessDays != null ? this.cashSettlementBusinessDays.hashCode() : 0);
            _result = 31 * _result + (this.fixedRecoveryModel != null ? this.fixedRecoveryModel.hashCode() : 0);
            _result = 31 * _result + (this.fixedSettlement != null ? this.fixedSettlement.hashCode() : 0);
            _result = 31 * _result + (this.accruedInterest != null ? this.accruedInterest.hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? ((Object)((Object)this.valuationMethod)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CashSettlementTerms {valuationDate=" + this.valuationDate + ", valuationTime=" + this.valuationTime + ", quotationMethod=" + (Object)((Object)this.quotationMethod) + ", quotationAmount=" + this.quotationAmount + ", minimumQuotationAmount=" + this.minimumQuotationAmount + ", dealer=" + this.dealer + ", cashSettlementBusinessDays=" + this.cashSettlementBusinessDays + ", fixedRecoveryModel=" + this.fixedRecoveryModel + ", fixedSettlement=" + this.fixedSettlement + ", accruedInterest=" + this.accruedInterest + ", valuationMethod=" + (Object)((Object)this.valuationMethod) + '}' + " " + super.toString();
        }
    }
}

