/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.BusinessCentersOrReference;
import fpml.confirmation.CalculationMethodEnum;
import fpml.confirmation.ObservationOffset;
import fpml.confirmation.ObservationParametersModel;
import fpml.confirmation.ObservationShiftParameters;
import fpml.confirmation.meta.CalculationParametersMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CalculationParameters", builder=CalculationParametersBuilderImpl.class, version="0.17.2")
@RuneDataType(value="CalculationParameters", model="fpml", builder=CalculationParametersBuilderImpl.class, version="0.17.2")
public interface CalculationParameters
extends RosettaModelObject {
    public static final CalculationParametersMeta metaData = new CalculationParametersMeta();

    public CalculationMethodEnum getCalculationMethod();

    public BusinessCentersOrReference getApplicableBusinessDays();

    public ObservationOffset getLookback();

    public ObservationShiftParameters getObservationShift();

    public ObservationOffset getLockout();

    public ObservationParametersModel getObservationParametersModel();

    public CalculationParameters build();

    public CalculationParametersBuilder toBuilder();

    public static CalculationParametersBuilder builder() {
        return new CalculationParametersBuilderImpl();
    }

    default public RosettaMetaData<? extends CalculationParameters> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CalculationParameters> getType() {
        return CalculationParameters.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("calculationMethod"), CalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("applicableBusinessDays"), processor, BusinessCentersOrReference.class, this.getApplicableBusinessDays(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lookback"), processor, ObservationOffset.class, this.getLookback(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationShift"), processor, ObservationShiftParameters.class, this.getObservationShift(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lockout"), processor, ObservationOffset.class, this.getLockout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationParametersModel"), processor, ObservationParametersModel.class, this.getObservationParametersModel(), new AttributeMeta[0]);
    }

    public static class CalculationParametersBuilderImpl
    implements CalculationParametersBuilder {
        protected CalculationMethodEnum calculationMethod;
        protected BusinessCentersOrReference.BusinessCentersOrReferenceBuilder applicableBusinessDays;
        protected ObservationOffset.ObservationOffsetBuilder lookback;
        protected ObservationShiftParameters.ObservationShiftParametersBuilder observationShift;
        protected ObservationOffset.ObservationOffsetBuilder lockout;
        protected ObservationParametersModel.ObservationParametersModelBuilder observationParametersModel;

        @Override
        @RosettaAttribute(value="calculationMethod", isRequired=true)
        @RuneAttribute(value="calculationMethod", isRequired=true)
        public CalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        @RosettaAttribute(value="applicableBusinessDays")
        @RuneAttribute(value="applicableBusinessDays")
        public BusinessCentersOrReference.BusinessCentersOrReferenceBuilder getApplicableBusinessDays() {
            return this.applicableBusinessDays;
        }

        @Override
        public BusinessCentersOrReference.BusinessCentersOrReferenceBuilder getOrCreateApplicableBusinessDays() {
            BusinessCentersOrReference.BusinessCentersOrReferenceBuilder result = this.applicableBusinessDays != null ? this.applicableBusinessDays : (this.applicableBusinessDays = BusinessCentersOrReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="lookback")
        @RuneAttribute(value="lookback")
        public ObservationOffset.ObservationOffsetBuilder getLookback() {
            return this.lookback;
        }

        @Override
        public ObservationOffset.ObservationOffsetBuilder getOrCreateLookback() {
            ObservationOffset.ObservationOffsetBuilder result = this.lookback != null ? this.lookback : (this.lookback = ObservationOffset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observationShift")
        @RuneAttribute(value="observationShift")
        public ObservationShiftParameters.ObservationShiftParametersBuilder getObservationShift() {
            return this.observationShift;
        }

        @Override
        public ObservationShiftParameters.ObservationShiftParametersBuilder getOrCreateObservationShift() {
            ObservationShiftParameters.ObservationShiftParametersBuilder result = this.observationShift != null ? this.observationShift : (this.observationShift = ObservationShiftParameters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="lockout")
        @RuneAttribute(value="lockout")
        public ObservationOffset.ObservationOffsetBuilder getLockout() {
            return this.lockout;
        }

        @Override
        public ObservationOffset.ObservationOffsetBuilder getOrCreateLockout() {
            ObservationOffset.ObservationOffsetBuilder result = this.lockout != null ? this.lockout : (this.lockout = ObservationOffset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observationParametersModel")
        @RuneAttribute(value="observationParametersModel")
        public ObservationParametersModel.ObservationParametersModelBuilder getObservationParametersModel() {
            return this.observationParametersModel;
        }

        @Override
        public ObservationParametersModel.ObservationParametersModelBuilder getOrCreateObservationParametersModel() {
            ObservationParametersModel.ObservationParametersModelBuilder result = this.observationParametersModel != null ? this.observationParametersModel : (this.observationParametersModel = ObservationParametersModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationMethod", isRequired=true)
        @RuneAttribute(value="calculationMethod", isRequired=true)
        public CalculationParametersBuilder setCalculationMethod(CalculationMethodEnum _calculationMethod) {
            this.calculationMethod = _calculationMethod == null ? null : _calculationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="applicableBusinessDays")
        @RuneAttribute(value="applicableBusinessDays")
        public CalculationParametersBuilder setApplicableBusinessDays(BusinessCentersOrReference _applicableBusinessDays) {
            this.applicableBusinessDays = _applicableBusinessDays == null ? null : _applicableBusinessDays.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lookback")
        @RuneAttribute(value="lookback")
        public CalculationParametersBuilder setLookback(ObservationOffset _lookback) {
            this.lookback = _lookback == null ? null : _lookback.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationShift")
        @RuneAttribute(value="observationShift")
        public CalculationParametersBuilder setObservationShift(ObservationShiftParameters _observationShift) {
            this.observationShift = _observationShift == null ? null : _observationShift.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lockout")
        @RuneAttribute(value="lockout")
        public CalculationParametersBuilder setLockout(ObservationOffset _lockout) {
            this.lockout = _lockout == null ? null : _lockout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationParametersModel")
        @RuneAttribute(value="observationParametersModel")
        public CalculationParametersBuilder setObservationParametersModel(ObservationParametersModel _observationParametersModel) {
            this.observationParametersModel = _observationParametersModel == null ? null : _observationParametersModel.toBuilder();
            return this;
        }

        @Override
        public CalculationParameters build() {
            return new CalculationParametersImpl(this);
        }

        @Override
        public CalculationParametersBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculationParametersBuilder prune() {
            if (this.applicableBusinessDays != null && !this.applicableBusinessDays.prune().hasData()) {
                this.applicableBusinessDays = null;
            }
            if (this.lookback != null && !this.lookback.prune().hasData()) {
                this.lookback = null;
            }
            if (this.observationShift != null && !this.observationShift.prune().hasData()) {
                this.observationShift = null;
            }
            if (this.lockout != null && !this.lockout.prune().hasData()) {
                this.lockout = null;
            }
            if (this.observationParametersModel != null && !this.observationParametersModel.prune().hasData()) {
                this.observationParametersModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCalculationMethod() != null) {
                return true;
            }
            if (this.getApplicableBusinessDays() != null && this.getApplicableBusinessDays().hasData()) {
                return true;
            }
            if (this.getLookback() != null && this.getLookback().hasData()) {
                return true;
            }
            if (this.getObservationShift() != null && this.getObservationShift().hasData()) {
                return true;
            }
            if (this.getLockout() != null && this.getLockout().hasData()) {
                return true;
            }
            return this.getObservationParametersModel() != null && this.getObservationParametersModel().hasData();
        }

        public CalculationParametersBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CalculationParametersBuilder o = (CalculationParametersBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApplicableBusinessDays(), (RosettaModelObjectBuilder)o.getApplicableBusinessDays(), this::setApplicableBusinessDays);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLookback(), (RosettaModelObjectBuilder)o.getLookback(), this::setLookback);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservationShift(), (RosettaModelObjectBuilder)o.getObservationShift(), this::setObservationShift);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLockout(), (RosettaModelObjectBuilder)o.getLockout(), this::setLockout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservationParametersModel(), (RosettaModelObjectBuilder)o.getObservationParametersModel(), this::setObservationParametersModel);
            merger.mergeBasic((Object)this.getCalculationMethod(), (Object)o.getCalculationMethod(), this::setCalculationMethod, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculationParameters _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals(this.applicableBusinessDays, _that.getApplicableBusinessDays())) {
                return false;
            }
            if (!Objects.equals(this.lookback, _that.getLookback())) {
                return false;
            }
            if (!Objects.equals(this.observationShift, _that.getObservationShift())) {
                return false;
            }
            if (!Objects.equals(this.lockout, _that.getLockout())) {
                return false;
            }
            return Objects.equals(this.observationParametersModel, _that.getObservationParametersModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.applicableBusinessDays != null ? this.applicableBusinessDays.hashCode() : 0);
            _result = 31 * _result + (this.lookback != null ? this.lookback.hashCode() : 0);
            _result = 31 * _result + (this.observationShift != null ? this.observationShift.hashCode() : 0);
            _result = 31 * _result + (this.lockout != null ? this.lockout.hashCode() : 0);
            _result = 31 * _result + (this.observationParametersModel != null ? this.observationParametersModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculationParametersBuilder {calculationMethod=" + (Object)((Object)this.calculationMethod) + ", applicableBusinessDays=" + this.applicableBusinessDays + ", lookback=" + this.lookback + ", observationShift=" + this.observationShift + ", lockout=" + this.lockout + ", observationParametersModel=" + this.observationParametersModel + '}';
        }
    }

    public static interface CalculationParametersBuilder
    extends CalculationParameters,
    RosettaModelObjectBuilder {
        public BusinessCentersOrReference.BusinessCentersOrReferenceBuilder getOrCreateApplicableBusinessDays();

        @Override
        public BusinessCentersOrReference.BusinessCentersOrReferenceBuilder getApplicableBusinessDays();

        public ObservationOffset.ObservationOffsetBuilder getOrCreateLookback();

        @Override
        public ObservationOffset.ObservationOffsetBuilder getLookback();

        public ObservationShiftParameters.ObservationShiftParametersBuilder getOrCreateObservationShift();

        @Override
        public ObservationShiftParameters.ObservationShiftParametersBuilder getObservationShift();

        public ObservationOffset.ObservationOffsetBuilder getOrCreateLockout();

        @Override
        public ObservationOffset.ObservationOffsetBuilder getLockout();

        public ObservationParametersModel.ObservationParametersModelBuilder getOrCreateObservationParametersModel();

        @Override
        public ObservationParametersModel.ObservationParametersModelBuilder getObservationParametersModel();

        public CalculationParametersBuilder setCalculationMethod(CalculationMethodEnum var1);

        public CalculationParametersBuilder setApplicableBusinessDays(BusinessCentersOrReference var1);

        public CalculationParametersBuilder setLookback(ObservationOffset var1);

        public CalculationParametersBuilder setObservationShift(ObservationShiftParameters var1);

        public CalculationParametersBuilder setLockout(ObservationOffset var1);

        public CalculationParametersBuilder setObservationParametersModel(ObservationParametersModel var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("calculationMethod"), CalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("applicableBusinessDays"), processor, BusinessCentersOrReference.BusinessCentersOrReferenceBuilder.class, this.getApplicableBusinessDays(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lookback"), processor, ObservationOffset.ObservationOffsetBuilder.class, this.getLookback(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationShift"), processor, ObservationShiftParameters.ObservationShiftParametersBuilder.class, this.getObservationShift(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lockout"), processor, ObservationOffset.ObservationOffsetBuilder.class, this.getLockout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationParametersModel"), processor, ObservationParametersModel.ObservationParametersModelBuilder.class, this.getObservationParametersModel(), new AttributeMeta[0]);
        }

        public CalculationParametersBuilder prune();
    }

    public static class CalculationParametersImpl
    implements CalculationParameters {
        private final CalculationMethodEnum calculationMethod;
        private final BusinessCentersOrReference applicableBusinessDays;
        private final ObservationOffset lookback;
        private final ObservationShiftParameters observationShift;
        private final ObservationOffset lockout;
        private final ObservationParametersModel observationParametersModel;

        protected CalculationParametersImpl(CalculationParametersBuilder builder) {
            this.calculationMethod = builder.getCalculationMethod();
            this.applicableBusinessDays = Optional.ofNullable(builder.getApplicableBusinessDays()).map(f -> f.build()).orElse(null);
            this.lookback = Optional.ofNullable(builder.getLookback()).map(f -> f.build()).orElse(null);
            this.observationShift = Optional.ofNullable(builder.getObservationShift()).map(f -> f.build()).orElse(null);
            this.lockout = Optional.ofNullable(builder.getLockout()).map(f -> f.build()).orElse(null);
            this.observationParametersModel = Optional.ofNullable(builder.getObservationParametersModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="calculationMethod", isRequired=true)
        @RuneAttribute(value="calculationMethod", isRequired=true)
        public CalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        @RosettaAttribute(value="applicableBusinessDays")
        @RuneAttribute(value="applicableBusinessDays")
        public BusinessCentersOrReference getApplicableBusinessDays() {
            return this.applicableBusinessDays;
        }

        @Override
        @RosettaAttribute(value="lookback")
        @RuneAttribute(value="lookback")
        public ObservationOffset getLookback() {
            return this.lookback;
        }

        @Override
        @RosettaAttribute(value="observationShift")
        @RuneAttribute(value="observationShift")
        public ObservationShiftParameters getObservationShift() {
            return this.observationShift;
        }

        @Override
        @RosettaAttribute(value="lockout")
        @RuneAttribute(value="lockout")
        public ObservationOffset getLockout() {
            return this.lockout;
        }

        @Override
        @RosettaAttribute(value="observationParametersModel")
        @RuneAttribute(value="observationParametersModel")
        public ObservationParametersModel getObservationParametersModel() {
            return this.observationParametersModel;
        }

        @Override
        public CalculationParameters build() {
            return this;
        }

        @Override
        public CalculationParametersBuilder toBuilder() {
            CalculationParametersBuilder builder = CalculationParameters.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculationParametersBuilder builder) {
            Optional.ofNullable(this.getCalculationMethod()).ifPresent(builder::setCalculationMethod);
            Optional.ofNullable(this.getApplicableBusinessDays()).ifPresent(builder::setApplicableBusinessDays);
            Optional.ofNullable(this.getLookback()).ifPresent(builder::setLookback);
            Optional.ofNullable(this.getObservationShift()).ifPresent(builder::setObservationShift);
            Optional.ofNullable(this.getLockout()).ifPresent(builder::setLockout);
            Optional.ofNullable(this.getObservationParametersModel()).ifPresent(builder::setObservationParametersModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculationParameters _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals(this.applicableBusinessDays, _that.getApplicableBusinessDays())) {
                return false;
            }
            if (!Objects.equals(this.lookback, _that.getLookback())) {
                return false;
            }
            if (!Objects.equals(this.observationShift, _that.getObservationShift())) {
                return false;
            }
            if (!Objects.equals(this.lockout, _that.getLockout())) {
                return false;
            }
            return Objects.equals(this.observationParametersModel, _that.getObservationParametersModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.applicableBusinessDays != null ? this.applicableBusinessDays.hashCode() : 0);
            _result = 31 * _result + (this.lookback != null ? this.lookback.hashCode() : 0);
            _result = 31 * _result + (this.observationShift != null ? this.observationShift.hashCode() : 0);
            _result = 31 * _result + (this.lockout != null ? this.lockout.hashCode() : 0);
            _result = 31 * _result + (this.observationParametersModel != null ? this.observationParametersModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculationParameters {calculationMethod=" + (Object)((Object)this.calculationMethod) + ", applicableBusinessDays=" + this.applicableBusinessDays + ", lookback=" + this.lookback + ", observationShift=" + this.observationShift + ", lockout=" + this.lockout + ", observationParametersModel=" + this.observationParametersModel + '}';
        }
    }
}

