/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.Currency;
import fpml.confirmation.Money;
import fpml.confirmation.Step;
import fpml.confirmation.meta.CalculationAmountMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CalculationAmount", builder=CalculationAmountBuilderImpl.class, version="0.17.2")
@RuneDataType(value="CalculationAmount", model="fpml", builder=CalculationAmountBuilderImpl.class, version="0.17.2")
public interface CalculationAmount
extends Money {
    public static final CalculationAmountMeta metaData = new CalculationAmountMeta();

    public List<? extends Step> getStep();

    @Override
    public CalculationAmount build();

    @Override
    public CalculationAmountBuilder toBuilder();

    public static CalculationAmountBuilder builder() {
        return new CalculationAmountBuilderImpl();
    }

    default public RosettaMetaData<? extends CalculationAmount> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CalculationAmount> getType() {
        return CalculationAmount.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("step"), processor, Step.class, this.getStep(), new AttributeMeta[0]);
    }

    public static class CalculationAmountBuilderImpl
    extends Money.MoneyBuilderImpl
    implements CalculationAmountBuilder {
        protected List<Step.StepBuilder> step = new ArrayList<Step.StepBuilder>();

        @Override
        @RosettaAttribute(value="step")
        @RuneAttribute(value="step")
        public List<? extends Step.StepBuilder> getStep() {
            return this.step;
        }

        @Override
        public Step.StepBuilder getOrCreateStep(int index) {
            if (this.step == null) {
                this.step = new ArrayList<Step.StepBuilder>();
            }
            return (Step.StepBuilder)this.getIndex(this.step, index, () -> {
                Step.StepBuilder newStep = Step.builder();
                return newStep;
            });
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public CalculationAmountBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CalculationAmountBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public CalculationAmountBuilder setAmount(BigDecimal _amount) {
            this.amount = _amount == null ? null : _amount;
            return this;
        }

        @Override
        @RosettaAttribute(value="step")
        @RuneAttribute(value="step")
        public CalculationAmountBuilder addStep(Step _step) {
            if (_step != null) {
                this.step.add(_step.toBuilder());
            }
            return this;
        }

        @Override
        public CalculationAmountBuilder addStep(Step _step, int idx) {
            this.getIndex(this.step, idx, () -> _step.toBuilder());
            return this;
        }

        @Override
        public CalculationAmountBuilder addStep(List<? extends Step> steps) {
            if (steps != null) {
                for (Step step : steps) {
                    this.step.add(step.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="step")
        public CalculationAmountBuilder setStep(List<? extends Step> steps) {
            this.step = steps == null ? new ArrayList<Step.StepBuilder>() : (List)steps.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CalculationAmount build() {
            return new CalculationAmountImpl(this);
        }

        @Override
        public CalculationAmountBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculationAmountBuilder prune() {
            super.prune();
            this.step = this.step.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getStep() != null && this.getStep().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public CalculationAmountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CalculationAmountBuilder o = (CalculationAmountBuilder)other;
            merger.mergeRosetta(this.getStep(), o.getStep(), this::getOrCreateStep);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CalculationAmount _that = (CalculationAmount)this.getType().cast(o);
            return ListEquals.listEquals(this.step, _that.getStep());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.step != null ? this.step.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CalculationAmountBuilder {step=" + this.step + '}' + " " + super.toString();
        }
    }

    public static interface CalculationAmountBuilder
    extends CalculationAmount,
    Money.MoneyBuilder {
        public Step.StepBuilder getOrCreateStep(int var1);

        public List<? extends Step.StepBuilder> getStep();

        @Override
        public CalculationAmountBuilder setCurrency(Currency var1);

        @Override
        public CalculationAmountBuilder setId(String var1);

        @Override
        public CalculationAmountBuilder setAmount(BigDecimal var1);

        public CalculationAmountBuilder addStep(Step var1);

        public CalculationAmountBuilder addStep(Step var1, int var2);

        public CalculationAmountBuilder addStep(List<? extends Step> var1);

        public CalculationAmountBuilder setStep(List<? extends Step> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("step"), processor, Step.StepBuilder.class, this.getStep(), new AttributeMeta[0]);
        }

        @Override
        public CalculationAmountBuilder prune();
    }

    public static class CalculationAmountImpl
    extends Money.MoneyImpl
    implements CalculationAmount {
        private final List<? extends Step> step;

        protected CalculationAmountImpl(CalculationAmountBuilder builder) {
            super(builder);
            this.step = Optional.ofNullable(builder.getStep()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="step")
        @RuneAttribute(value="step")
        public List<? extends Step> getStep() {
            return this.step;
        }

        @Override
        public CalculationAmount build() {
            return this;
        }

        @Override
        public CalculationAmountBuilder toBuilder() {
            CalculationAmountBuilder builder = CalculationAmount.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculationAmountBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getStep()).ifPresent(builder::setStep);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CalculationAmount _that = (CalculationAmount)this.getType().cast(o);
            return ListEquals.listEquals(this.step, _that.getStep());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.step != null ? this.step.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CalculationAmount {step=" + this.step + '}' + " " + super.toString();
        }
    }
}

