/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.CalculationSequence;
import fpml.confirmation.CompoundingMethodEnum;
import fpml.confirmation.DayCountFraction;
import fpml.confirmation.Discounting;
import fpml.confirmation.FxLinkedNotionalSchedule;
import fpml.confirmation.Notional;
import fpml.confirmation.Rate;
import fpml.confirmation.meta.CalculationMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Calculation", builder=CalculationBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Calculation", model="fpml", builder=CalculationBuilderImpl.class, version="0.17.2")
public interface Calculation
extends RosettaModelObject {
    public static final CalculationMeta metaData = new CalculationMeta();

    public Notional getNotionalSchedule();

    public FxLinkedNotionalSchedule getFxLinkedNotionalSchedule();

    public CalculationSequence getCalculationSequence();

    public Rate getRateCalculation();

    public DayCountFraction getDayCountFraction();

    public Discounting getDiscounting();

    public CompoundingMethodEnum getCompoundingMethod();

    public Calculation build();

    public CalculationBuilder toBuilder();

    public static CalculationBuilder builder() {
        return new CalculationBuilderImpl();
    }

    default public RosettaMetaData<? extends Calculation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Calculation> getType() {
        return Calculation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("notionalSchedule"), processor, Notional.class, this.getNotionalSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxLinkedNotionalSchedule"), processor, FxLinkedNotionalSchedule.class, this.getFxLinkedNotionalSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationSequence"), processor, CalculationSequence.class, this.getCalculationSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateCalculation"), processor, Rate.class, this.getRateCalculation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("discounting"), processor, Discounting.class, this.getDiscounting(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("compoundingMethod"), CompoundingMethodEnum.class, (Object)this.getCompoundingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CalculationBuilderImpl
    implements CalculationBuilder {
        protected Notional.NotionalBuilder notionalSchedule;
        protected FxLinkedNotionalSchedule.FxLinkedNotionalScheduleBuilder fxLinkedNotionalSchedule;
        protected CalculationSequence.CalculationSequenceBuilder calculationSequence;
        protected Rate.RateBuilder rateCalculation;
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;
        protected Discounting.DiscountingBuilder discounting;
        protected CompoundingMethodEnum compoundingMethod;

        @Override
        @RosettaAttribute(value="notionalSchedule")
        @RuneAttribute(value="notionalSchedule")
        public Notional.NotionalBuilder getNotionalSchedule() {
            return this.notionalSchedule;
        }

        @Override
        public Notional.NotionalBuilder getOrCreateNotionalSchedule() {
            Notional.NotionalBuilder result = this.notionalSchedule != null ? this.notionalSchedule : (this.notionalSchedule = Notional.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxLinkedNotionalSchedule")
        @RuneAttribute(value="fxLinkedNotionalSchedule")
        public FxLinkedNotionalSchedule.FxLinkedNotionalScheduleBuilder getFxLinkedNotionalSchedule() {
            return this.fxLinkedNotionalSchedule;
        }

        @Override
        public FxLinkedNotionalSchedule.FxLinkedNotionalScheduleBuilder getOrCreateFxLinkedNotionalSchedule() {
            FxLinkedNotionalSchedule.FxLinkedNotionalScheduleBuilder result = this.fxLinkedNotionalSchedule != null ? this.fxLinkedNotionalSchedule : (this.fxLinkedNotionalSchedule = FxLinkedNotionalSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationSequence")
        @RuneAttribute(value="calculationSequence")
        public CalculationSequence.CalculationSequenceBuilder getCalculationSequence() {
            return this.calculationSequence;
        }

        @Override
        public CalculationSequence.CalculationSequenceBuilder getOrCreateCalculationSequence() {
            CalculationSequence.CalculationSequenceBuilder result = this.calculationSequence != null ? this.calculationSequence : (this.calculationSequence = CalculationSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rateCalculation")
        @RuneAttribute(value="rateCalculation")
        public Rate.RateBuilder getRateCalculation() {
            return this.rateCalculation;
        }

        @Override
        public Rate.RateBuilder getOrCreateRateCalculation() {
            Rate.RateBuilder result = this.rateCalculation != null ? this.rateCalculation : (this.rateCalculation = Rate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="discounting")
        @RuneAttribute(value="discounting")
        public Discounting.DiscountingBuilder getDiscounting() {
            return this.discounting;
        }

        @Override
        public Discounting.DiscountingBuilder getOrCreateDiscounting() {
            Discounting.DiscountingBuilder result = this.discounting != null ? this.discounting : (this.discounting = Discounting.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="compoundingMethod")
        @RuneAttribute(value="compoundingMethod")
        public CompoundingMethodEnum getCompoundingMethod() {
            return this.compoundingMethod;
        }

        @Override
        @RosettaAttribute(value="notionalSchedule")
        @RuneAttribute(value="notionalSchedule")
        public CalculationBuilder setNotionalSchedule(Notional _notionalSchedule) {
            this.notionalSchedule = _notionalSchedule == null ? null : _notionalSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxLinkedNotionalSchedule")
        @RuneAttribute(value="fxLinkedNotionalSchedule")
        public CalculationBuilder setFxLinkedNotionalSchedule(FxLinkedNotionalSchedule _fxLinkedNotionalSchedule) {
            this.fxLinkedNotionalSchedule = _fxLinkedNotionalSchedule == null ? null : _fxLinkedNotionalSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationSequence")
        @RuneAttribute(value="calculationSequence")
        public CalculationBuilder setCalculationSequence(CalculationSequence _calculationSequence) {
            this.calculationSequence = _calculationSequence == null ? null : _calculationSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rateCalculation")
        @RuneAttribute(value="rateCalculation")
        public CalculationBuilder setRateCalculation(Rate _rateCalculation) {
            this.rateCalculation = _rateCalculation == null ? null : _rateCalculation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public CalculationBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="discounting")
        @RuneAttribute(value="discounting")
        public CalculationBuilder setDiscounting(Discounting _discounting) {
            this.discounting = _discounting == null ? null : _discounting.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="compoundingMethod")
        @RuneAttribute(value="compoundingMethod")
        public CalculationBuilder setCompoundingMethod(CompoundingMethodEnum _compoundingMethod) {
            this.compoundingMethod = _compoundingMethod == null ? null : _compoundingMethod;
            return this;
        }

        @Override
        public Calculation build() {
            return new CalculationImpl(this);
        }

        @Override
        public CalculationBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculationBuilder prune() {
            if (this.notionalSchedule != null && !this.notionalSchedule.prune().hasData()) {
                this.notionalSchedule = null;
            }
            if (this.fxLinkedNotionalSchedule != null && !this.fxLinkedNotionalSchedule.prune().hasData()) {
                this.fxLinkedNotionalSchedule = null;
            }
            if (this.calculationSequence != null && !this.calculationSequence.prune().hasData()) {
                this.calculationSequence = null;
            }
            if (this.rateCalculation != null && !this.rateCalculation.prune().hasData()) {
                this.rateCalculation = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            if (this.discounting != null && !this.discounting.prune().hasData()) {
                this.discounting = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getNotionalSchedule() != null && this.getNotionalSchedule().hasData()) {
                return true;
            }
            if (this.getFxLinkedNotionalSchedule() != null && this.getFxLinkedNotionalSchedule().hasData()) {
                return true;
            }
            if (this.getCalculationSequence() != null && this.getCalculationSequence().hasData()) {
                return true;
            }
            if (this.getRateCalculation() != null && this.getRateCalculation().hasData()) {
                return true;
            }
            if (this.getDayCountFraction() != null && this.getDayCountFraction().hasData()) {
                return true;
            }
            if (this.getDiscounting() != null && this.getDiscounting().hasData()) {
                return true;
            }
            return this.getCompoundingMethod() != null;
        }

        public CalculationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CalculationBuilder o = (CalculationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalSchedule(), (RosettaModelObjectBuilder)o.getNotionalSchedule(), this::setNotionalSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxLinkedNotionalSchedule(), (RosettaModelObjectBuilder)o.getFxLinkedNotionalSchedule(), this::setFxLinkedNotionalSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationSequence(), (RosettaModelObjectBuilder)o.getCalculationSequence(), this::setCalculationSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRateCalculation(), (RosettaModelObjectBuilder)o.getRateCalculation(), this::setRateCalculation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDiscounting(), (RosettaModelObjectBuilder)o.getDiscounting(), this::setDiscounting);
            merger.mergeBasic((Object)this.getCompoundingMethod(), (Object)o.getCompoundingMethod(), this::setCompoundingMethod, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Calculation _that = this.getType().cast(o);
            if (!Objects.equals(this.notionalSchedule, _that.getNotionalSchedule())) {
                return false;
            }
            if (!Objects.equals(this.fxLinkedNotionalSchedule, _that.getFxLinkedNotionalSchedule())) {
                return false;
            }
            if (!Objects.equals(this.calculationSequence, _that.getCalculationSequence())) {
                return false;
            }
            if (!Objects.equals(this.rateCalculation, _that.getRateCalculation())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.discounting, _that.getDiscounting())) {
                return false;
            }
            return Objects.equals((Object)this.compoundingMethod, (Object)_that.getCompoundingMethod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notionalSchedule != null ? this.notionalSchedule.hashCode() : 0);
            _result = 31 * _result + (this.fxLinkedNotionalSchedule != null ? this.fxLinkedNotionalSchedule.hashCode() : 0);
            _result = 31 * _result + (this.calculationSequence != null ? this.calculationSequence.hashCode() : 0);
            _result = 31 * _result + (this.rateCalculation != null ? this.rateCalculation.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.discounting != null ? this.discounting.hashCode() : 0);
            _result = 31 * _result + (this.compoundingMethod != null ? ((Object)((Object)this.compoundingMethod)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculationBuilder {notionalSchedule=" + this.notionalSchedule + ", fxLinkedNotionalSchedule=" + this.fxLinkedNotionalSchedule + ", calculationSequence=" + this.calculationSequence + ", rateCalculation=" + this.rateCalculation + ", dayCountFraction=" + this.dayCountFraction + ", discounting=" + this.discounting + ", compoundingMethod=" + (Object)((Object)this.compoundingMethod) + '}';
        }
    }

    public static interface CalculationBuilder
    extends Calculation,
    RosettaModelObjectBuilder {
        public Notional.NotionalBuilder getOrCreateNotionalSchedule();

        @Override
        public Notional.NotionalBuilder getNotionalSchedule();

        public FxLinkedNotionalSchedule.FxLinkedNotionalScheduleBuilder getOrCreateFxLinkedNotionalSchedule();

        @Override
        public FxLinkedNotionalSchedule.FxLinkedNotionalScheduleBuilder getFxLinkedNotionalSchedule();

        public CalculationSequence.CalculationSequenceBuilder getOrCreateCalculationSequence();

        @Override
        public CalculationSequence.CalculationSequenceBuilder getCalculationSequence();

        public Rate.RateBuilder getOrCreateRateCalculation();

        @Override
        public Rate.RateBuilder getRateCalculation();

        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        public Discounting.DiscountingBuilder getOrCreateDiscounting();

        @Override
        public Discounting.DiscountingBuilder getDiscounting();

        public CalculationBuilder setNotionalSchedule(Notional var1);

        public CalculationBuilder setFxLinkedNotionalSchedule(FxLinkedNotionalSchedule var1);

        public CalculationBuilder setCalculationSequence(CalculationSequence var1);

        public CalculationBuilder setRateCalculation(Rate var1);

        public CalculationBuilder setDayCountFraction(DayCountFraction var1);

        public CalculationBuilder setDiscounting(Discounting var1);

        public CalculationBuilder setCompoundingMethod(CompoundingMethodEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("notionalSchedule"), processor, Notional.NotionalBuilder.class, this.getNotionalSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxLinkedNotionalSchedule"), processor, FxLinkedNotionalSchedule.FxLinkedNotionalScheduleBuilder.class, this.getFxLinkedNotionalSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationSequence"), processor, CalculationSequence.CalculationSequenceBuilder.class, this.getCalculationSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateCalculation"), processor, Rate.RateBuilder.class, this.getRateCalculation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("discounting"), processor, Discounting.DiscountingBuilder.class, this.getDiscounting(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("compoundingMethod"), CompoundingMethodEnum.class, (Object)this.getCompoundingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CalculationBuilder prune();
    }

    public static class CalculationImpl
    implements Calculation {
        private final Notional notionalSchedule;
        private final FxLinkedNotionalSchedule fxLinkedNotionalSchedule;
        private final CalculationSequence calculationSequence;
        private final Rate rateCalculation;
        private final DayCountFraction dayCountFraction;
        private final Discounting discounting;
        private final CompoundingMethodEnum compoundingMethod;

        protected CalculationImpl(CalculationBuilder builder) {
            this.notionalSchedule = Optional.ofNullable(builder.getNotionalSchedule()).map(f -> f.build()).orElse(null);
            this.fxLinkedNotionalSchedule = Optional.ofNullable(builder.getFxLinkedNotionalSchedule()).map(f -> f.build()).orElse(null);
            this.calculationSequence = Optional.ofNullable(builder.getCalculationSequence()).map(f -> f.build()).orElse(null);
            this.rateCalculation = Optional.ofNullable(builder.getRateCalculation()).map(f -> f.build()).orElse(null);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
            this.discounting = Optional.ofNullable(builder.getDiscounting()).map(f -> f.build()).orElse(null);
            this.compoundingMethod = builder.getCompoundingMethod();
        }

        @Override
        @RosettaAttribute(value="notionalSchedule")
        @RuneAttribute(value="notionalSchedule")
        public Notional getNotionalSchedule() {
            return this.notionalSchedule;
        }

        @Override
        @RosettaAttribute(value="fxLinkedNotionalSchedule")
        @RuneAttribute(value="fxLinkedNotionalSchedule")
        public FxLinkedNotionalSchedule getFxLinkedNotionalSchedule() {
            return this.fxLinkedNotionalSchedule;
        }

        @Override
        @RosettaAttribute(value="calculationSequence")
        @RuneAttribute(value="calculationSequence")
        public CalculationSequence getCalculationSequence() {
            return this.calculationSequence;
        }

        @Override
        @RosettaAttribute(value="rateCalculation")
        @RuneAttribute(value="rateCalculation")
        public Rate getRateCalculation() {
            return this.rateCalculation;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="discounting")
        @RuneAttribute(value="discounting")
        public Discounting getDiscounting() {
            return this.discounting;
        }

        @Override
        @RosettaAttribute(value="compoundingMethod")
        @RuneAttribute(value="compoundingMethod")
        public CompoundingMethodEnum getCompoundingMethod() {
            return this.compoundingMethod;
        }

        @Override
        public Calculation build() {
            return this;
        }

        @Override
        public CalculationBuilder toBuilder() {
            CalculationBuilder builder = Calculation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculationBuilder builder) {
            Optional.ofNullable(this.getNotionalSchedule()).ifPresent(builder::setNotionalSchedule);
            Optional.ofNullable(this.getFxLinkedNotionalSchedule()).ifPresent(builder::setFxLinkedNotionalSchedule);
            Optional.ofNullable(this.getCalculationSequence()).ifPresent(builder::setCalculationSequence);
            Optional.ofNullable(this.getRateCalculation()).ifPresent(builder::setRateCalculation);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getDiscounting()).ifPresent(builder::setDiscounting);
            Optional.ofNullable(this.getCompoundingMethod()).ifPresent(builder::setCompoundingMethod);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Calculation _that = this.getType().cast(o);
            if (!Objects.equals(this.notionalSchedule, _that.getNotionalSchedule())) {
                return false;
            }
            if (!Objects.equals(this.fxLinkedNotionalSchedule, _that.getFxLinkedNotionalSchedule())) {
                return false;
            }
            if (!Objects.equals(this.calculationSequence, _that.getCalculationSequence())) {
                return false;
            }
            if (!Objects.equals(this.rateCalculation, _that.getRateCalculation())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.discounting, _that.getDiscounting())) {
                return false;
            }
            return Objects.equals((Object)this.compoundingMethod, (Object)_that.getCompoundingMethod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notionalSchedule != null ? this.notionalSchedule.hashCode() : 0);
            _result = 31 * _result + (this.fxLinkedNotionalSchedule != null ? this.fxLinkedNotionalSchedule.hashCode() : 0);
            _result = 31 * _result + (this.calculationSequence != null ? this.calculationSequence.hashCode() : 0);
            _result = 31 * _result + (this.rateCalculation != null ? this.rateCalculation.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.discounting != null ? this.discounting.hashCode() : 0);
            _result = 31 * _result + (this.compoundingMethod != null ? ((Object)((Object)this.compoundingMethod)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Calculation {notionalSchedule=" + this.notionalSchedule + ", fxLinkedNotionalSchedule=" + this.fxLinkedNotionalSchedule + ", calculationSequence=" + this.calculationSequence + ", rateCalculation=" + this.rateCalculation + ", dayCountFraction=" + this.dayCountFraction + ", discounting=" + this.discounting + ", compoundingMethod=" + (Object)((Object)this.compoundingMethod) + '}';
        }
    }
}

