/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.Bond;
import fpml.confirmation.meta.BondReferenceMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="BondReference", builder=BondReferenceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="BondReference", model="fpml", builder=BondReferenceBuilderImpl.class, version="0.17.2")
public interface BondReference
extends RosettaModelObject {
    public static final BondReferenceMeta metaData = new BondReferenceMeta();

    public Bond getBond();

    public Boolean getConditionPrecedentBond();

    public Boolean getDiscrepancyClause();

    public BondReference build();

    public BondReferenceBuilder toBuilder();

    public static BondReferenceBuilder builder() {
        return new BondReferenceBuilderImpl();
    }

    default public RosettaMetaData<? extends BondReference> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BondReference> getType() {
        return BondReference.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("bond"), processor, Bond.class, this.getBond(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("conditionPrecedentBond"), Boolean.class, (Object)this.getConditionPrecedentBond(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("discrepancyClause"), Boolean.class, (Object)this.getDiscrepancyClause(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class BondReferenceBuilderImpl
    implements BondReferenceBuilder {
        protected Bond.BondBuilder bond;
        protected Boolean conditionPrecedentBond;
        protected Boolean discrepancyClause;

        @Override
        @RosettaAttribute(value="bond", isRequired=true)
        @RuneAttribute(value="bond", isRequired=true)
        public Bond.BondBuilder getBond() {
            return this.bond;
        }

        @Override
        public Bond.BondBuilder getOrCreateBond() {
            Bond.BondBuilder result = this.bond != null ? this.bond : (this.bond = Bond.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="conditionPrecedentBond", isRequired=true)
        @RuneAttribute(value="conditionPrecedentBond", isRequired=true)
        public Boolean getConditionPrecedentBond() {
            return this.conditionPrecedentBond;
        }

        @Override
        @RosettaAttribute(value="discrepancyClause")
        @RuneAttribute(value="discrepancyClause")
        public Boolean getDiscrepancyClause() {
            return this.discrepancyClause;
        }

        @Override
        @RosettaAttribute(value="bond", isRequired=true)
        @RuneAttribute(value="bond", isRequired=true)
        public BondReferenceBuilder setBond(Bond _bond) {
            this.bond = _bond == null ? null : _bond.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="conditionPrecedentBond", isRequired=true)
        @RuneAttribute(value="conditionPrecedentBond", isRequired=true)
        public BondReferenceBuilder setConditionPrecedentBond(Boolean _conditionPrecedentBond) {
            this.conditionPrecedentBond = _conditionPrecedentBond == null ? null : _conditionPrecedentBond;
            return this;
        }

        @Override
        @RosettaAttribute(value="discrepancyClause")
        @RuneAttribute(value="discrepancyClause")
        public BondReferenceBuilder setDiscrepancyClause(Boolean _discrepancyClause) {
            this.discrepancyClause = _discrepancyClause == null ? null : _discrepancyClause;
            return this;
        }

        @Override
        public BondReference build() {
            return new BondReferenceImpl(this);
        }

        @Override
        public BondReferenceBuilder toBuilder() {
            return this;
        }

        @Override
        public BondReferenceBuilder prune() {
            if (this.bond != null && !this.bond.prune().hasData()) {
                this.bond = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBond() != null && this.getBond().hasData()) {
                return true;
            }
            if (this.getConditionPrecedentBond() != null) {
                return true;
            }
            return this.getDiscrepancyClause() != null;
        }

        public BondReferenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BondReferenceBuilder o = (BondReferenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBond(), (RosettaModelObjectBuilder)o.getBond(), this::setBond);
            merger.mergeBasic((Object)this.getConditionPrecedentBond(), (Object)o.getConditionPrecedentBond(), this::setConditionPrecedentBond, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDiscrepancyClause(), (Object)o.getDiscrepancyClause(), this::setDiscrepancyClause, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BondReference _that = this.getType().cast(o);
            if (!Objects.equals(this.bond, _that.getBond())) {
                return false;
            }
            if (!Objects.equals(this.conditionPrecedentBond, _that.getConditionPrecedentBond())) {
                return false;
            }
            return Objects.equals(this.discrepancyClause, _that.getDiscrepancyClause());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.bond != null ? this.bond.hashCode() : 0);
            _result = 31 * _result + (this.conditionPrecedentBond != null ? this.conditionPrecedentBond.hashCode() : 0);
            _result = 31 * _result + (this.discrepancyClause != null ? this.discrepancyClause.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BondReferenceBuilder {bond=" + this.bond + ", conditionPrecedentBond=" + this.conditionPrecedentBond + ", discrepancyClause=" + this.discrepancyClause + '}';
        }
    }

    public static interface BondReferenceBuilder
    extends BondReference,
    RosettaModelObjectBuilder {
        public Bond.BondBuilder getOrCreateBond();

        @Override
        public Bond.BondBuilder getBond();

        public BondReferenceBuilder setBond(Bond var1);

        public BondReferenceBuilder setConditionPrecedentBond(Boolean var1);

        public BondReferenceBuilder setDiscrepancyClause(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("bond"), processor, Bond.BondBuilder.class, this.getBond(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("conditionPrecedentBond"), Boolean.class, (Object)this.getConditionPrecedentBond(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("discrepancyClause"), Boolean.class, (Object)this.getDiscrepancyClause(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public BondReferenceBuilder prune();
    }

    public static class BondReferenceImpl
    implements BondReference {
        private final Bond bond;
        private final Boolean conditionPrecedentBond;
        private final Boolean discrepancyClause;

        protected BondReferenceImpl(BondReferenceBuilder builder) {
            this.bond = Optional.ofNullable(builder.getBond()).map(f -> f.build()).orElse(null);
            this.conditionPrecedentBond = builder.getConditionPrecedentBond();
            this.discrepancyClause = builder.getDiscrepancyClause();
        }

        @Override
        @RosettaAttribute(value="bond", isRequired=true)
        @RuneAttribute(value="bond", isRequired=true)
        public Bond getBond() {
            return this.bond;
        }

        @Override
        @RosettaAttribute(value="conditionPrecedentBond", isRequired=true)
        @RuneAttribute(value="conditionPrecedentBond", isRequired=true)
        public Boolean getConditionPrecedentBond() {
            return this.conditionPrecedentBond;
        }

        @Override
        @RosettaAttribute(value="discrepancyClause")
        @RuneAttribute(value="discrepancyClause")
        public Boolean getDiscrepancyClause() {
            return this.discrepancyClause;
        }

        @Override
        public BondReference build() {
            return this;
        }

        @Override
        public BondReferenceBuilder toBuilder() {
            BondReferenceBuilder builder = BondReference.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BondReferenceBuilder builder) {
            Optional.ofNullable(this.getBond()).ifPresent(builder::setBond);
            Optional.ofNullable(this.getConditionPrecedentBond()).ifPresent(builder::setConditionPrecedentBond);
            Optional.ofNullable(this.getDiscrepancyClause()).ifPresent(builder::setDiscrepancyClause);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BondReference _that = this.getType().cast(o);
            if (!Objects.equals(this.bond, _that.getBond())) {
                return false;
            }
            if (!Objects.equals(this.conditionPrecedentBond, _that.getConditionPrecedentBond())) {
                return false;
            }
            return Objects.equals(this.discrepancyClause, _that.getDiscrepancyClause());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.bond != null ? this.bond.hashCode() : 0);
            _result = 31 * _result + (this.conditionPrecedentBond != null ? this.conditionPrecedentBond.hashCode() : 0);
            _result = 31 * _result + (this.discrepancyClause != null ? this.discrepancyClause.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BondReference {bond=" + this.bond + ", conditionPrecedentBond=" + this.conditionPrecedentBond + ", discrepancyClause=" + this.discrepancyClause + '}';
        }
    }
}

