/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.BondChoiceModel;
import fpml.confirmation.BondOptionStrike;
import fpml.confirmation.BuyerSellerModel;
import fpml.confirmation.Exercise;
import fpml.confirmation.ExerciseProcedure;
import fpml.confirmation.Money;
import fpml.confirmation.NotionalAmountReference;
import fpml.confirmation.OptionBaseExtended;
import fpml.confirmation.OptionDenominationModel;
import fpml.confirmation.OptionFeature;
import fpml.confirmation.OptionSettlementModel;
import fpml.confirmation.OptionTypeEnum;
import fpml.confirmation.Premium;
import fpml.confirmation.ProductModel;
import fpml.confirmation.meta.BondOptionMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="BondOption", builder=BondOptionBuilderImpl.class, version="0.17.2")
@RuneDataType(value="BondOption", model="fpml", builder=BondOptionBuilderImpl.class, version="0.17.2")
public interface BondOption
extends OptionBaseExtended {
    public static final BondOptionMeta metaData = new BondOptionMeta();

    public BondOptionStrike getStrike();

    public BondChoiceModel getBondChoiceModel();

    @Override
    public BondOption build();

    @Override
    public BondOptionBuilder toBuilder();

    public static BondOptionBuilder builder() {
        return new BondOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends BondOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BondOption> getType() {
        return BondOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), OptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, Premium.class, this.getPremium(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exercise"), processor, Exercise.class, this.getExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.class, this.getExerciseProcedure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("feature"), processor, OptionFeature.class, this.getFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalReference"), processor, NotionalAmountReference.class, this.getNotionalReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmount"), processor, Money.class, this.getNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionDenominationModel"), processor, OptionDenominationModel.class, this.getOptionDenominationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.class, this.getOptionSettlementModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strike"), processor, BondOptionStrike.class, this.getStrike(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("bondChoiceModel"), processor, BondChoiceModel.class, this.getBondChoiceModel(), new AttributeMeta[0]);
    }

    public static class BondOptionBuilderImpl
    extends OptionBaseExtended.OptionBaseExtendedBuilderImpl
    implements BondOptionBuilder {
        protected BondOptionStrike.BondOptionStrikeBuilder strike;
        protected BondChoiceModel.BondChoiceModelBuilder bondChoiceModel;

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public BondOptionStrike.BondOptionStrikeBuilder getStrike() {
            return this.strike;
        }

        @Override
        public BondOptionStrike.BondOptionStrikeBuilder getOrCreateStrike() {
            BondOptionStrike.BondOptionStrikeBuilder result = this.strike != null ? this.strike : (this.strike = BondOptionStrike.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="bondChoiceModel", isRequired=true)
        @RuneAttribute(value="bondChoiceModel", isRequired=true)
        public BondChoiceModel.BondChoiceModelBuilder getBondChoiceModel() {
            return this.bondChoiceModel;
        }

        @Override
        public BondChoiceModel.BondChoiceModelBuilder getOrCreateBondChoiceModel() {
            BondChoiceModel.BondChoiceModelBuilder result = this.bondChoiceModel != null ? this.bondChoiceModel : (this.bondChoiceModel = BondChoiceModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public BondOptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public BondOptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BondOptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public BondOptionBuilder setOptionType(OptionTypeEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public BondOptionBuilder setPremium(Premium _premium) {
            this.premium = _premium == null ? null : _premium.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exercise", isRequired=true)
        @RuneAttribute(value="exercise", isRequired=true)
        public BondOptionBuilder setExercise(Exercise _exercise) {
            this.exercise = _exercise == null ? null : _exercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure", isRequired=true)
        @RuneAttribute(value="exerciseProcedure", isRequired=true)
        public BondOptionBuilder setExerciseProcedure(ExerciseProcedure _exerciseProcedure) {
            this.exerciseProcedure = _exerciseProcedure == null ? null : _exerciseProcedure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public BondOptionBuilder setFeature(OptionFeature _feature) {
            this.feature = _feature == null ? null : _feature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalReference")
        @RuneAttribute(value="notionalReference")
        public BondOptionBuilder setNotionalReference(NotionalAmountReference _notionalReference) {
            this.notionalReference = _notionalReference == null ? null : _notionalReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public BondOptionBuilder setNotionalAmount(Money _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionDenominationModel")
        @RuneAttribute(value="optionDenominationModel")
        public BondOptionBuilder setOptionDenominationModel(OptionDenominationModel _optionDenominationModel) {
            this.optionDenominationModel = _optionDenominationModel == null ? null : _optionDenominationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionSettlementModel", isRequired=true)
        @RuneAttribute(value="optionSettlementModel", isRequired=true)
        public BondOptionBuilder setOptionSettlementModel(OptionSettlementModel _optionSettlementModel) {
            this.optionSettlementModel = _optionSettlementModel == null ? null : _optionSettlementModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public BondOptionBuilder setStrike(BondOptionStrike _strike) {
            this.strike = _strike == null ? null : _strike.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="bondChoiceModel", isRequired=true)
        @RuneAttribute(value="bondChoiceModel", isRequired=true)
        public BondOptionBuilder setBondChoiceModel(BondChoiceModel _bondChoiceModel) {
            this.bondChoiceModel = _bondChoiceModel == null ? null : _bondChoiceModel.toBuilder();
            return this;
        }

        @Override
        public BondOption build() {
            return new BondOptionImpl(this);
        }

        @Override
        public BondOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public BondOptionBuilder prune() {
            super.prune();
            if (this.strike != null && !this.strike.prune().hasData()) {
                this.strike = null;
            }
            if (this.bondChoiceModel != null && !this.bondChoiceModel.prune().hasData()) {
                this.bondChoiceModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getStrike() != null && this.getStrike().hasData()) {
                return true;
            }
            return this.getBondChoiceModel() != null && this.getBondChoiceModel().hasData();
        }

        @Override
        public BondOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BondOptionBuilder o = (BondOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrike(), (RosettaModelObjectBuilder)o.getStrike(), this::setStrike);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBondChoiceModel(), (RosettaModelObjectBuilder)o.getBondChoiceModel(), this::setBondChoiceModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BondOption _that = (BondOption)this.getType().cast(o);
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            return Objects.equals(this.bondChoiceModel, _that.getBondChoiceModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.bondChoiceModel != null ? this.bondChoiceModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BondOptionBuilder {strike=" + this.strike + ", bondChoiceModel=" + this.bondChoiceModel + '}' + " " + super.toString();
        }
    }

    public static interface BondOptionBuilder
    extends BondOption,
    OptionBaseExtended.OptionBaseExtendedBuilder {
        public BondOptionStrike.BondOptionStrikeBuilder getOrCreateStrike();

        @Override
        public BondOptionStrike.BondOptionStrikeBuilder getStrike();

        public BondChoiceModel.BondChoiceModelBuilder getOrCreateBondChoiceModel();

        @Override
        public BondChoiceModel.BondChoiceModelBuilder getBondChoiceModel();

        @Override
        public BondOptionBuilder setProductModel(ProductModel var1);

        @Override
        public BondOptionBuilder setId(String var1);

        @Override
        public BondOptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        @Override
        public BondOptionBuilder setOptionType(OptionTypeEnum var1);

        @Override
        public BondOptionBuilder setPremium(Premium var1);

        @Override
        public BondOptionBuilder setExercise(Exercise var1);

        @Override
        public BondOptionBuilder setExerciseProcedure(ExerciseProcedure var1);

        @Override
        public BondOptionBuilder setFeature(OptionFeature var1);

        @Override
        public BondOptionBuilder setNotionalReference(NotionalAmountReference var1);

        @Override
        public BondOptionBuilder setNotionalAmount(Money var1);

        @Override
        public BondOptionBuilder setOptionDenominationModel(OptionDenominationModel var1);

        @Override
        public BondOptionBuilder setOptionSettlementModel(OptionSettlementModel var1);

        public BondOptionBuilder setStrike(BondOptionStrike var1);

        public BondOptionBuilder setBondChoiceModel(BondChoiceModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), OptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, Premium.PremiumBuilder.class, (RosettaModelObjectBuilder)this.getPremium(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exercise"), processor, Exercise.ExerciseBuilder.class, (RosettaModelObjectBuilder)this.getExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.ExerciseProcedureBuilder.class, (RosettaModelObjectBuilder)this.getExerciseProcedure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("feature"), processor, OptionFeature.OptionFeatureBuilder.class, (RosettaModelObjectBuilder)this.getFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalReference"), processor, NotionalAmountReference.NotionalAmountReferenceBuilder.class, (RosettaModelObjectBuilder)this.getNotionalReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmount"), processor, Money.MoneyBuilder.class, (RosettaModelObjectBuilder)this.getNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionDenominationModel"), processor, OptionDenominationModel.OptionDenominationModelBuilder.class, (RosettaModelObjectBuilder)this.getOptionDenominationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.OptionSettlementModelBuilder.class, (RosettaModelObjectBuilder)this.getOptionSettlementModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strike"), processor, BondOptionStrike.BondOptionStrikeBuilder.class, this.getStrike(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("bondChoiceModel"), processor, BondChoiceModel.BondChoiceModelBuilder.class, this.getBondChoiceModel(), new AttributeMeta[0]);
        }

        @Override
        public BondOptionBuilder prune();
    }

    public static class BondOptionImpl
    extends OptionBaseExtended.OptionBaseExtendedImpl
    implements BondOption {
        private final BondOptionStrike strike;
        private final BondChoiceModel bondChoiceModel;

        protected BondOptionImpl(BondOptionBuilder builder) {
            super(builder);
            this.strike = Optional.ofNullable(builder.getStrike()).map(f -> f.build()).orElse(null);
            this.bondChoiceModel = Optional.ofNullable(builder.getBondChoiceModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public BondOptionStrike getStrike() {
            return this.strike;
        }

        @Override
        @RosettaAttribute(value="bondChoiceModel", isRequired=true)
        @RuneAttribute(value="bondChoiceModel", isRequired=true)
        public BondChoiceModel getBondChoiceModel() {
            return this.bondChoiceModel;
        }

        @Override
        public BondOption build() {
            return this;
        }

        @Override
        public BondOptionBuilder toBuilder() {
            BondOptionBuilder builder = BondOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BondOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getStrike()).ifPresent(builder::setStrike);
            Optional.ofNullable(this.getBondChoiceModel()).ifPresent(builder::setBondChoiceModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BondOption _that = (BondOption)this.getType().cast(o);
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            return Objects.equals(this.bondChoiceModel, _that.getBondChoiceModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.bondChoiceModel != null ? this.bondChoiceModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BondOption {strike=" + this.strike + ", bondChoiceModel=" + this.bondChoiceModel + '}' + " " + super.toString();
        }
    }
}

