/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.BasketId;
import fpml.confirmation.BasketName;
import fpml.confirmation.meta.BasketIdentifierModelSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="BasketIdentifierModelSequence", builder=BasketIdentifierModelSequenceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="BasketIdentifierModelSequence", model="fpml", builder=BasketIdentifierModelSequenceBuilderImpl.class, version="0.17.2")
public interface BasketIdentifierModelSequence
extends RosettaModelObject {
    public static final BasketIdentifierModelSequenceMeta metaData = new BasketIdentifierModelSequenceMeta();

    public BasketName getBasketName();

    public List<? extends BasketId> getBasketId();

    public BasketIdentifierModelSequence build();

    public BasketIdentifierModelSequenceBuilder toBuilder();

    public static BasketIdentifierModelSequenceBuilder builder() {
        return new BasketIdentifierModelSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends BasketIdentifierModelSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BasketIdentifierModelSequence> getType() {
        return BasketIdentifierModelSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("basketName"), processor, BasketName.class, this.getBasketName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketId"), processor, BasketId.class, this.getBasketId(), new AttributeMeta[0]);
    }

    public static class BasketIdentifierModelSequenceBuilderImpl
    implements BasketIdentifierModelSequenceBuilder {
        protected BasketName.BasketNameBuilder basketName;
        protected List<BasketId.BasketIdBuilder> basketId = new ArrayList<BasketId.BasketIdBuilder>();

        @Override
        @RosettaAttribute(value="basketName", isRequired=true)
        @RuneAttribute(value="basketName", isRequired=true)
        public BasketName.BasketNameBuilder getBasketName() {
            return this.basketName;
        }

        @Override
        public BasketName.BasketNameBuilder getOrCreateBasketName() {
            BasketName.BasketNameBuilder result = this.basketName != null ? this.basketName : (this.basketName = BasketName.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="basketId")
        @RuneAttribute(value="basketId")
        public List<? extends BasketId.BasketIdBuilder> getBasketId() {
            return this.basketId;
        }

        @Override
        public BasketId.BasketIdBuilder getOrCreateBasketId(int index) {
            if (this.basketId == null) {
                this.basketId = new ArrayList<BasketId.BasketIdBuilder>();
            }
            return (BasketId.BasketIdBuilder)this.getIndex(this.basketId, index, () -> {
                BasketId.BasketIdBuilder newBasketId = BasketId.builder();
                return newBasketId;
            });
        }

        @Override
        @RosettaAttribute(value="basketName", isRequired=true)
        @RuneAttribute(value="basketName", isRequired=true)
        public BasketIdentifierModelSequenceBuilder setBasketName(BasketName _basketName) {
            this.basketName = _basketName == null ? null : _basketName.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="basketId")
        @RuneAttribute(value="basketId")
        public BasketIdentifierModelSequenceBuilder addBasketId(BasketId _basketId) {
            if (_basketId != null) {
                this.basketId.add(_basketId.toBuilder());
            }
            return this;
        }

        @Override
        public BasketIdentifierModelSequenceBuilder addBasketId(BasketId _basketId, int idx) {
            this.getIndex(this.basketId, idx, () -> _basketId.toBuilder());
            return this;
        }

        @Override
        public BasketIdentifierModelSequenceBuilder addBasketId(List<? extends BasketId> basketIds) {
            if (basketIds != null) {
                for (BasketId basketId : basketIds) {
                    this.basketId.add(basketId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketId")
        public BasketIdentifierModelSequenceBuilder setBasketId(List<? extends BasketId> basketIds) {
            this.basketId = basketIds == null ? new ArrayList<BasketId.BasketIdBuilder>() : (List)basketIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BasketIdentifierModelSequence build() {
            return new BasketIdentifierModelSequenceImpl(this);
        }

        @Override
        public BasketIdentifierModelSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public BasketIdentifierModelSequenceBuilder prune() {
            if (this.basketName != null && !this.basketName.prune().hasData()) {
                this.basketName = null;
            }
            this.basketId = this.basketId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getBasketName() != null && this.getBasketName().hasData()) {
                return true;
            }
            return this.getBasketId() != null && this.getBasketId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public BasketIdentifierModelSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BasketIdentifierModelSequenceBuilder o = (BasketIdentifierModelSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasketName(), (RosettaModelObjectBuilder)o.getBasketName(), this::setBasketName);
            merger.mergeRosetta(this.getBasketId(), o.getBasketId(), this::getOrCreateBasketId);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BasketIdentifierModelSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.basketName, _that.getBasketName())) {
                return false;
            }
            return ListEquals.listEquals(this.basketId, _that.getBasketId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.basketName != null ? this.basketName.hashCode() : 0);
            _result = 31 * _result + (this.basketId != null ? this.basketId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BasketIdentifierModelSequenceBuilder {basketName=" + this.basketName + ", basketId=" + this.basketId + '}';
        }
    }

    public static interface BasketIdentifierModelSequenceBuilder
    extends BasketIdentifierModelSequence,
    RosettaModelObjectBuilder {
        public BasketName.BasketNameBuilder getOrCreateBasketName();

        @Override
        public BasketName.BasketNameBuilder getBasketName();

        public BasketId.BasketIdBuilder getOrCreateBasketId(int var1);

        public List<? extends BasketId.BasketIdBuilder> getBasketId();

        public BasketIdentifierModelSequenceBuilder setBasketName(BasketName var1);

        public BasketIdentifierModelSequenceBuilder addBasketId(BasketId var1);

        public BasketIdentifierModelSequenceBuilder addBasketId(BasketId var1, int var2);

        public BasketIdentifierModelSequenceBuilder addBasketId(List<? extends BasketId> var1);

        public BasketIdentifierModelSequenceBuilder setBasketId(List<? extends BasketId> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("basketName"), processor, BasketName.BasketNameBuilder.class, this.getBasketName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketId"), processor, BasketId.BasketIdBuilder.class, this.getBasketId(), new AttributeMeta[0]);
        }

        public BasketIdentifierModelSequenceBuilder prune();
    }

    public static class BasketIdentifierModelSequenceImpl
    implements BasketIdentifierModelSequence {
        private final BasketName basketName;
        private final List<? extends BasketId> basketId;

        protected BasketIdentifierModelSequenceImpl(BasketIdentifierModelSequenceBuilder builder) {
            this.basketName = Optional.ofNullable(builder.getBasketName()).map(f -> f.build()).orElse(null);
            this.basketId = Optional.ofNullable(builder.getBasketId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="basketName", isRequired=true)
        @RuneAttribute(value="basketName", isRequired=true)
        public BasketName getBasketName() {
            return this.basketName;
        }

        @Override
        @RosettaAttribute(value="basketId")
        @RuneAttribute(value="basketId")
        public List<? extends BasketId> getBasketId() {
            return this.basketId;
        }

        @Override
        public BasketIdentifierModelSequence build() {
            return this;
        }

        @Override
        public BasketIdentifierModelSequenceBuilder toBuilder() {
            BasketIdentifierModelSequenceBuilder builder = BasketIdentifierModelSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BasketIdentifierModelSequenceBuilder builder) {
            Optional.ofNullable(this.getBasketName()).ifPresent(builder::setBasketName);
            Optional.ofNullable(this.getBasketId()).ifPresent(builder::setBasketId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BasketIdentifierModelSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.basketName, _that.getBasketName())) {
                return false;
            }
            return ListEquals.listEquals(this.basketId, _that.getBasketId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.basketName != null ? this.basketName.hashCode() : 0);
            _result = 31 * _result + (this.basketId != null ? this.basketId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BasketIdentifierModelSequence {basketName=" + this.basketName + ", basketId=" + this.basketId + '}';
        }
    }
}

