/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.Money;
import fpml.confirmation.meta.AdjustedPaymentDatesMeta;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AdjustedPaymentDates", builder=AdjustedPaymentDatesBuilderImpl.class, version="0.17.2")
@RuneDataType(value="AdjustedPaymentDates", model="fpml", builder=AdjustedPaymentDatesBuilderImpl.class, version="0.17.2")
public interface AdjustedPaymentDates
extends RosettaModelObject {
    public static final AdjustedPaymentDatesMeta metaData = new AdjustedPaymentDatesMeta();

    public ZonedDateTime getAdjustedPaymentDate();

    public Money getPaymentAmount();

    public AdjustedPaymentDates build();

    public AdjustedPaymentDatesBuilder toBuilder();

    public static AdjustedPaymentDatesBuilder builder() {
        return new AdjustedPaymentDatesBuilderImpl();
    }

    default public RosettaMetaData<? extends AdjustedPaymentDates> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AdjustedPaymentDates> getType() {
        return AdjustedPaymentDates.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("adjustedPaymentDate"), ZonedDateTime.class, (Object)this.getAdjustedPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, Money.class, this.getPaymentAmount(), new AttributeMeta[0]);
    }

    public static class AdjustedPaymentDatesBuilderImpl
    implements AdjustedPaymentDatesBuilder {
        protected ZonedDateTime adjustedPaymentDate;
        protected Money.MoneyBuilder paymentAmount;

        @Override
        @RosettaAttribute(value="adjustedPaymentDate", isRequired=true)
        @RuneAttribute(value="adjustedPaymentDate", isRequired=true)
        public ZonedDateTime getAdjustedPaymentDate() {
            return this.adjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public Money.MoneyBuilder getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePaymentAmount() {
            Money.MoneyBuilder result = this.paymentAmount != null ? this.paymentAmount : (this.paymentAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate", isRequired=true)
        @RuneAttribute(value="adjustedPaymentDate", isRequired=true)
        public AdjustedPaymentDatesBuilder setAdjustedPaymentDate(ZonedDateTime _adjustedPaymentDate) {
            this.adjustedPaymentDate = _adjustedPaymentDate == null ? null : _adjustedPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public AdjustedPaymentDatesBuilder setPaymentAmount(Money _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        public AdjustedPaymentDates build() {
            return new AdjustedPaymentDatesImpl(this);
        }

        @Override
        public AdjustedPaymentDatesBuilder toBuilder() {
            return this;
        }

        @Override
        public AdjustedPaymentDatesBuilder prune() {
            if (this.paymentAmount != null && !this.paymentAmount.prune().hasData()) {
                this.paymentAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAdjustedPaymentDate() != null) {
                return true;
            }
            return this.getPaymentAmount() != null && this.getPaymentAmount().hasData();
        }

        public AdjustedPaymentDatesBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AdjustedPaymentDatesBuilder o = (AdjustedPaymentDatesBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentAmount(), (RosettaModelObjectBuilder)o.getPaymentAmount(), this::setPaymentAmount);
            merger.mergeBasic((Object)this.getAdjustedPaymentDate(), (Object)o.getAdjustedPaymentDate(), this::setAdjustedPaymentDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AdjustedPaymentDates _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustedPaymentDate, _that.getAdjustedPaymentDate())) {
                return false;
            }
            return Objects.equals(this.paymentAmount, _that.getPaymentAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedPaymentDate != null ? this.adjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AdjustedPaymentDatesBuilder {adjustedPaymentDate=" + this.adjustedPaymentDate + ", paymentAmount=" + this.paymentAmount + '}';
        }
    }

    public static interface AdjustedPaymentDatesBuilder
    extends AdjustedPaymentDates,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreatePaymentAmount();

        @Override
        public Money.MoneyBuilder getPaymentAmount();

        public AdjustedPaymentDatesBuilder setAdjustedPaymentDate(ZonedDateTime var1);

        public AdjustedPaymentDatesBuilder setPaymentAmount(Money var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("adjustedPaymentDate"), ZonedDateTime.class, (Object)this.getAdjustedPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, Money.MoneyBuilder.class, this.getPaymentAmount(), new AttributeMeta[0]);
        }

        public AdjustedPaymentDatesBuilder prune();
    }

    public static class AdjustedPaymentDatesImpl
    implements AdjustedPaymentDates {
        private final ZonedDateTime adjustedPaymentDate;
        private final Money paymentAmount;

        protected AdjustedPaymentDatesImpl(AdjustedPaymentDatesBuilder builder) {
            this.adjustedPaymentDate = builder.getAdjustedPaymentDate();
            this.paymentAmount = Optional.ofNullable(builder.getPaymentAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate", isRequired=true)
        @RuneAttribute(value="adjustedPaymentDate", isRequired=true)
        public ZonedDateTime getAdjustedPaymentDate() {
            return this.adjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public Money getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        public AdjustedPaymentDates build() {
            return this;
        }

        @Override
        public AdjustedPaymentDatesBuilder toBuilder() {
            AdjustedPaymentDatesBuilder builder = AdjustedPaymentDates.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AdjustedPaymentDatesBuilder builder) {
            Optional.ofNullable(this.getAdjustedPaymentDate()).ifPresent(builder::setAdjustedPaymentDate);
            Optional.ofNullable(this.getPaymentAmount()).ifPresent(builder::setPaymentAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AdjustedPaymentDates _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustedPaymentDate, _that.getAdjustedPaymentDate())) {
                return false;
            }
            return Objects.equals(this.paymentAmount, _that.getPaymentAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedPaymentDate != null ? this.adjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AdjustedPaymentDates {adjustedPaymentDate=" + this.adjustedPaymentDate + ", paymentAmount=" + this.paymentAmount + '}';
        }
    }
}

