/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.RateAdjustment;
import fpml.confirmation.meta.AccrualPeriodSequenceMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AccrualPeriodSequence", builder=AccrualPeriodSequenceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="AccrualPeriodSequence", model="fpml", builder=AccrualPeriodSequenceBuilderImpl.class, version="0.17.2")
public interface AccrualPeriodSequence
extends RosettaModelObject {
    public static final AccrualPeriodSequenceMeta metaData = new AccrualPeriodSequenceMeta();

    public BigDecimal getBaseRate();

    public BigDecimal getCompoundedRate();

    public BigDecimal getSpreadAdjustment();

    public RateAdjustment getRateAdjustment();

    public AccrualPeriodSequence build();

    public AccrualPeriodSequenceBuilder toBuilder();

    public static AccrualPeriodSequenceBuilder builder() {
        return new AccrualPeriodSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends AccrualPeriodSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AccrualPeriodSequence> getType() {
        return AccrualPeriodSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("baseRate"), BigDecimal.class, (Object)this.getBaseRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("compoundedRate"), BigDecimal.class, (Object)this.getCompoundedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadAdjustment"), BigDecimal.class, (Object)this.getSpreadAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateAdjustment"), processor, RateAdjustment.class, this.getRateAdjustment(), new AttributeMeta[0]);
    }

    public static class AccrualPeriodSequenceBuilderImpl
    implements AccrualPeriodSequenceBuilder {
        protected BigDecimal baseRate;
        protected BigDecimal compoundedRate;
        protected BigDecimal spreadAdjustment;
        protected RateAdjustment.RateAdjustmentBuilder rateAdjustment;

        @Override
        @RosettaAttribute(value="baseRate", isRequired=true)
        @RuneAttribute(value="baseRate", isRequired=true)
        public BigDecimal getBaseRate() {
            return this.baseRate;
        }

        @Override
        @RosettaAttribute(value="compoundedRate")
        @RuneAttribute(value="compoundedRate")
        public BigDecimal getCompoundedRate() {
            return this.compoundedRate;
        }

        @Override
        @RosettaAttribute(value="spreadAdjustment")
        @RuneAttribute(value="spreadAdjustment")
        public BigDecimal getSpreadAdjustment() {
            return this.spreadAdjustment;
        }

        @Override
        @RosettaAttribute(value="rateAdjustment", isRequired=true)
        @RuneAttribute(value="rateAdjustment", isRequired=true)
        public RateAdjustment.RateAdjustmentBuilder getRateAdjustment() {
            return this.rateAdjustment;
        }

        @Override
        public RateAdjustment.RateAdjustmentBuilder getOrCreateRateAdjustment() {
            RateAdjustment.RateAdjustmentBuilder result = this.rateAdjustment != null ? this.rateAdjustment : (this.rateAdjustment = RateAdjustment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="baseRate", isRequired=true)
        @RuneAttribute(value="baseRate", isRequired=true)
        public AccrualPeriodSequenceBuilder setBaseRate(BigDecimal _baseRate) {
            this.baseRate = _baseRate == null ? null : _baseRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="compoundedRate")
        @RuneAttribute(value="compoundedRate")
        public AccrualPeriodSequenceBuilder setCompoundedRate(BigDecimal _compoundedRate) {
            this.compoundedRate = _compoundedRate == null ? null : _compoundedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadAdjustment")
        @RuneAttribute(value="spreadAdjustment")
        public AccrualPeriodSequenceBuilder setSpreadAdjustment(BigDecimal _spreadAdjustment) {
            this.spreadAdjustment = _spreadAdjustment == null ? null : _spreadAdjustment;
            return this;
        }

        @Override
        @RosettaAttribute(value="rateAdjustment", isRequired=true)
        @RuneAttribute(value="rateAdjustment", isRequired=true)
        public AccrualPeriodSequenceBuilder setRateAdjustment(RateAdjustment _rateAdjustment) {
            this.rateAdjustment = _rateAdjustment == null ? null : _rateAdjustment.toBuilder();
            return this;
        }

        @Override
        public AccrualPeriodSequence build() {
            return new AccrualPeriodSequenceImpl(this);
        }

        @Override
        public AccrualPeriodSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public AccrualPeriodSequenceBuilder prune() {
            if (this.rateAdjustment != null && !this.rateAdjustment.prune().hasData()) {
                this.rateAdjustment = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBaseRate() != null) {
                return true;
            }
            if (this.getCompoundedRate() != null) {
                return true;
            }
            if (this.getSpreadAdjustment() != null) {
                return true;
            }
            return this.getRateAdjustment() != null && this.getRateAdjustment().hasData();
        }

        public AccrualPeriodSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AccrualPeriodSequenceBuilder o = (AccrualPeriodSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRateAdjustment(), (RosettaModelObjectBuilder)o.getRateAdjustment(), this::setRateAdjustment);
            merger.mergeBasic((Object)this.getBaseRate(), (Object)o.getBaseRate(), this::setBaseRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCompoundedRate(), (Object)o.getCompoundedRate(), this::setCompoundedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadAdjustment(), (Object)o.getSpreadAdjustment(), this::setSpreadAdjustment, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AccrualPeriodSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.baseRate, _that.getBaseRate())) {
                return false;
            }
            if (!Objects.equals(this.compoundedRate, _that.getCompoundedRate())) {
                return false;
            }
            if (!Objects.equals(this.spreadAdjustment, _that.getSpreadAdjustment())) {
                return false;
            }
            return Objects.equals(this.rateAdjustment, _that.getRateAdjustment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.baseRate != null ? this.baseRate.hashCode() : 0);
            _result = 31 * _result + (this.compoundedRate != null ? this.compoundedRate.hashCode() : 0);
            _result = 31 * _result + (this.spreadAdjustment != null ? this.spreadAdjustment.hashCode() : 0);
            _result = 31 * _result + (this.rateAdjustment != null ? this.rateAdjustment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AccrualPeriodSequenceBuilder {baseRate=" + this.baseRate + ", compoundedRate=" + this.compoundedRate + ", spreadAdjustment=" + this.spreadAdjustment + ", rateAdjustment=" + this.rateAdjustment + '}';
        }
    }

    public static interface AccrualPeriodSequenceBuilder
    extends AccrualPeriodSequence,
    RosettaModelObjectBuilder {
        public RateAdjustment.RateAdjustmentBuilder getOrCreateRateAdjustment();

        @Override
        public RateAdjustment.RateAdjustmentBuilder getRateAdjustment();

        public AccrualPeriodSequenceBuilder setBaseRate(BigDecimal var1);

        public AccrualPeriodSequenceBuilder setCompoundedRate(BigDecimal var1);

        public AccrualPeriodSequenceBuilder setSpreadAdjustment(BigDecimal var1);

        public AccrualPeriodSequenceBuilder setRateAdjustment(RateAdjustment var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("baseRate"), BigDecimal.class, (Object)this.getBaseRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("compoundedRate"), BigDecimal.class, (Object)this.getCompoundedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadAdjustment"), BigDecimal.class, (Object)this.getSpreadAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateAdjustment"), processor, RateAdjustment.RateAdjustmentBuilder.class, this.getRateAdjustment(), new AttributeMeta[0]);
        }

        public AccrualPeriodSequenceBuilder prune();
    }

    public static class AccrualPeriodSequenceImpl
    implements AccrualPeriodSequence {
        private final BigDecimal baseRate;
        private final BigDecimal compoundedRate;
        private final BigDecimal spreadAdjustment;
        private final RateAdjustment rateAdjustment;

        protected AccrualPeriodSequenceImpl(AccrualPeriodSequenceBuilder builder) {
            this.baseRate = builder.getBaseRate();
            this.compoundedRate = builder.getCompoundedRate();
            this.spreadAdjustment = builder.getSpreadAdjustment();
            this.rateAdjustment = Optional.ofNullable(builder.getRateAdjustment()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="baseRate", isRequired=true)
        @RuneAttribute(value="baseRate", isRequired=true)
        public BigDecimal getBaseRate() {
            return this.baseRate;
        }

        @Override
        @RosettaAttribute(value="compoundedRate")
        @RuneAttribute(value="compoundedRate")
        public BigDecimal getCompoundedRate() {
            return this.compoundedRate;
        }

        @Override
        @RosettaAttribute(value="spreadAdjustment")
        @RuneAttribute(value="spreadAdjustment")
        public BigDecimal getSpreadAdjustment() {
            return this.spreadAdjustment;
        }

        @Override
        @RosettaAttribute(value="rateAdjustment", isRequired=true)
        @RuneAttribute(value="rateAdjustment", isRequired=true)
        public RateAdjustment getRateAdjustment() {
            return this.rateAdjustment;
        }

        @Override
        public AccrualPeriodSequence build() {
            return this;
        }

        @Override
        public AccrualPeriodSequenceBuilder toBuilder() {
            AccrualPeriodSequenceBuilder builder = AccrualPeriodSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AccrualPeriodSequenceBuilder builder) {
            Optional.ofNullable(this.getBaseRate()).ifPresent(builder::setBaseRate);
            Optional.ofNullable(this.getCompoundedRate()).ifPresent(builder::setCompoundedRate);
            Optional.ofNullable(this.getSpreadAdjustment()).ifPresent(builder::setSpreadAdjustment);
            Optional.ofNullable(this.getRateAdjustment()).ifPresent(builder::setRateAdjustment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AccrualPeriodSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.baseRate, _that.getBaseRate())) {
                return false;
            }
            if (!Objects.equals(this.compoundedRate, _that.getCompoundedRate())) {
                return false;
            }
            if (!Objects.equals(this.spreadAdjustment, _that.getSpreadAdjustment())) {
                return false;
            }
            return Objects.equals(this.rateAdjustment, _that.getRateAdjustment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.baseRate != null ? this.baseRate.hashCode() : 0);
            _result = 31 * _result + (this.compoundedRate != null ? this.compoundedRate.hashCode() : 0);
            _result = 31 * _result + (this.spreadAdjustment != null ? this.spreadAdjustment.hashCode() : 0);
            _result = 31 * _result + (this.rateAdjustment != null ? this.rateAdjustment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AccrualPeriodSequence {baseRate=" + this.baseRate + ", compoundedRate=" + this.compoundedRate + ", spreadAdjustment=" + this.spreadAdjustment + ", rateAdjustment=" + this.rateAdjustment + '}';
        }
    }
}

