/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AbstractLoanEventSequence;
import fpml.confirmation.BusinessEventIdentifier;
import fpml.confirmation.LenderAndCashDetailsModel;
import fpml.confirmation.meta.AbstractLoanEventMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractLoanEvent", builder=AbstractLoanEventBuilderImpl.class, version="0.17.2")
@RuneDataType(value="AbstractLoanEvent", model="fpml", builder=AbstractLoanEventBuilderImpl.class, version="0.17.2")
public interface AbstractLoanEvent
extends RosettaModelObject {
    public static final AbstractLoanEventMeta metaData = new AbstractLoanEventMeta();

    public List<? extends BusinessEventIdentifier> getEventIdentifier();

    public AbstractLoanEventSequence getAbstractLoanEventSequence();

    public LenderAndCashDetailsModel getLenderAndCashDetailsModel();

    public String getComment();

    public AbstractLoanEvent build();

    public AbstractLoanEventBuilder toBuilder();

    public static AbstractLoanEventBuilder builder() {
        return new AbstractLoanEventBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractLoanEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractLoanEvent> getType() {
        return AbstractLoanEvent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AbstractLoanEventBuilderImpl
    implements AbstractLoanEventBuilder {
        protected List<BusinessEventIdentifier.BusinessEventIdentifierBuilder> eventIdentifier = new ArrayList<BusinessEventIdentifier.BusinessEventIdentifierBuilder>();
        protected AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder abstractLoanEventSequence;
        protected LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder lenderAndCashDetailsModel;
        protected String comment;

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public List<? extends BusinessEventIdentifier.BusinessEventIdentifierBuilder> getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        public BusinessEventIdentifier.BusinessEventIdentifierBuilder getOrCreateEventIdentifier(int index) {
            if (this.eventIdentifier == null) {
                this.eventIdentifier = new ArrayList<BusinessEventIdentifier.BusinessEventIdentifierBuilder>();
            }
            return (BusinessEventIdentifier.BusinessEventIdentifierBuilder)this.getIndex(this.eventIdentifier, index, () -> {
                BusinessEventIdentifier.BusinessEventIdentifierBuilder newEventIdentifier = BusinessEventIdentifier.builder();
                return newEventIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder getAbstractLoanEventSequence() {
            return this.abstractLoanEventSequence;
        }

        @Override
        public AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder getOrCreateAbstractLoanEventSequence() {
            AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder result = this.abstractLoanEventSequence != null ? this.abstractLoanEventSequence : (this.abstractLoanEventSequence = AbstractLoanEventSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder getLenderAndCashDetailsModel() {
            return this.lenderAndCashDetailsModel;
        }

        @Override
        public LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder getOrCreateLenderAndCashDetailsModel() {
            LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder result = this.lenderAndCashDetailsModel != null ? this.lenderAndCashDetailsModel : (this.lenderAndCashDetailsModel = LenderAndCashDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public String getComment() {
            return this.comment;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public AbstractLoanEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractLoanEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public AbstractLoanEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public AbstractLoanEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList<BusinessEventIdentifier.BusinessEventIdentifierBuilder>() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public AbstractLoanEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public AbstractLoanEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public AbstractLoanEventBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        public AbstractLoanEvent build() {
            return new AbstractLoanEventImpl(this);
        }

        @Override
        public AbstractLoanEventBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractLoanEventBuilder prune() {
            this.eventIdentifier = this.eventIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.abstractLoanEventSequence != null && !this.abstractLoanEventSequence.prune().hasData()) {
                this.abstractLoanEventSequence = null;
            }
            if (this.lenderAndCashDetailsModel != null && !this.lenderAndCashDetailsModel.prune().hasData()) {
                this.lenderAndCashDetailsModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getEventIdentifier() != null && this.getEventIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAbstractLoanEventSequence() != null && this.getAbstractLoanEventSequence().hasData()) {
                return true;
            }
            if (this.getLenderAndCashDetailsModel() != null && this.getLenderAndCashDetailsModel().hasData()) {
                return true;
            }
            return this.getComment() != null;
        }

        public AbstractLoanEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AbstractLoanEventBuilder o = (AbstractLoanEventBuilder)other;
            merger.mergeRosetta(this.getEventIdentifier(), o.getEventIdentifier(), this::getOrCreateEventIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), (RosettaModelObjectBuilder)o.getAbstractLoanEventSequence(), this::setAbstractLoanEventSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), (RosettaModelObjectBuilder)o.getLenderAndCashDetailsModel(), this::setLenderAndCashDetailsModel);
            merger.mergeBasic((Object)this.getComment(), (Object)o.getComment(), this::setComment, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbstractLoanEvent _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.abstractLoanEventSequence, _that.getAbstractLoanEventSequence())) {
                return false;
            }
            if (!Objects.equals(this.lenderAndCashDetailsModel, _that.getLenderAndCashDetailsModel())) {
                return false;
            }
            return Objects.equals(this.comment, _that.getComment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.abstractLoanEventSequence != null ? this.abstractLoanEventSequence.hashCode() : 0);
            _result = 31 * _result + (this.lenderAndCashDetailsModel != null ? this.lenderAndCashDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.comment != null ? this.comment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbstractLoanEventBuilder {eventIdentifier=" + this.eventIdentifier + ", abstractLoanEventSequence=" + this.abstractLoanEventSequence + ", lenderAndCashDetailsModel=" + this.lenderAndCashDetailsModel + ", comment=" + this.comment + '}';
        }
    }

    public static interface AbstractLoanEventBuilder
    extends AbstractLoanEvent,
    RosettaModelObjectBuilder {
        public BusinessEventIdentifier.BusinessEventIdentifierBuilder getOrCreateEventIdentifier(int var1);

        public List<? extends BusinessEventIdentifier.BusinessEventIdentifierBuilder> getEventIdentifier();

        public AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder getOrCreateAbstractLoanEventSequence();

        @Override
        public AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder getAbstractLoanEventSequence();

        public LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder getOrCreateLenderAndCashDetailsModel();

        @Override
        public LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder getLenderAndCashDetailsModel();

        public AbstractLoanEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        public AbstractLoanEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        public AbstractLoanEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public AbstractLoanEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public AbstractLoanEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        public AbstractLoanEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        public AbstractLoanEventBuilder setComment(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AbstractLoanEventBuilder prune();
    }

    public static class AbstractLoanEventImpl
    implements AbstractLoanEvent {
        private final List<? extends BusinessEventIdentifier> eventIdentifier;
        private final AbstractLoanEventSequence abstractLoanEventSequence;
        private final LenderAndCashDetailsModel lenderAndCashDetailsModel;
        private final String comment;

        protected AbstractLoanEventImpl(AbstractLoanEventBuilder builder) {
            this.eventIdentifier = Optional.ofNullable(builder.getEventIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.abstractLoanEventSequence = Optional.ofNullable(builder.getAbstractLoanEventSequence()).map(f -> f.build()).orElse(null);
            this.lenderAndCashDetailsModel = Optional.ofNullable(builder.getLenderAndCashDetailsModel()).map(f -> f.build()).orElse(null);
            this.comment = builder.getComment();
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public List<? extends BusinessEventIdentifier> getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public AbstractLoanEventSequence getAbstractLoanEventSequence() {
            return this.abstractLoanEventSequence;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LenderAndCashDetailsModel getLenderAndCashDetailsModel() {
            return this.lenderAndCashDetailsModel;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public String getComment() {
            return this.comment;
        }

        @Override
        public AbstractLoanEvent build() {
            return this;
        }

        @Override
        public AbstractLoanEventBuilder toBuilder() {
            AbstractLoanEventBuilder builder = AbstractLoanEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractLoanEventBuilder builder) {
            Optional.ofNullable(this.getEventIdentifier()).ifPresent(builder::setEventIdentifier);
            Optional.ofNullable(this.getAbstractLoanEventSequence()).ifPresent(builder::setAbstractLoanEventSequence);
            Optional.ofNullable(this.getLenderAndCashDetailsModel()).ifPresent(builder::setLenderAndCashDetailsModel);
            Optional.ofNullable(this.getComment()).ifPresent(builder::setComment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbstractLoanEvent _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.abstractLoanEventSequence, _that.getAbstractLoanEventSequence())) {
                return false;
            }
            if (!Objects.equals(this.lenderAndCashDetailsModel, _that.getLenderAndCashDetailsModel())) {
                return false;
            }
            return Objects.equals(this.comment, _that.getComment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.abstractLoanEventSequence != null ? this.abstractLoanEventSequence.hashCode() : 0);
            _result = 31 * _result + (this.lenderAndCashDetailsModel != null ? this.lenderAndCashDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.comment != null ? this.comment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbstractLoanEvent {eventIdentifier=" + this.eventIdentifier + ", abstractLoanEventSequence=" + this.abstractLoanEventSequence + ", lenderAndCashDetailsModel=" + this.lenderAndCashDetailsModel + ", comment=" + this.comment + '}';
        }
    }
}

