/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.PartyReference;
import fpml.confirmation.QuantityUnit;
import fpml.confirmation.meta.AbsoluteToleranceMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AbsoluteTolerance", builder=AbsoluteToleranceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="AbsoluteTolerance", model="fpml", builder=AbsoluteToleranceBuilderImpl.class, version="0.17.2")
public interface AbsoluteTolerance
extends RosettaModelObject {
    public static final AbsoluteToleranceMeta metaData = new AbsoluteToleranceMeta();

    public BigDecimal getPositive();

    public BigDecimal getNegative();

    public QuantityUnit getUnit();

    public PartyReference getOptionOwnerPartyReference();

    public AbsoluteTolerance build();

    public AbsoluteToleranceBuilder toBuilder();

    public static AbsoluteToleranceBuilder builder() {
        return new AbsoluteToleranceBuilderImpl();
    }

    default public RosettaMetaData<? extends AbsoluteTolerance> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbsoluteTolerance> getType() {
        return AbsoluteTolerance.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("positive"), BigDecimal.class, (Object)this.getPositive(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("negative"), BigDecimal.class, (Object)this.getNegative(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unit"), processor, QuantityUnit.class, this.getUnit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionOwnerPartyReference"), processor, PartyReference.class, this.getOptionOwnerPartyReference(), new AttributeMeta[0]);
    }

    public static class AbsoluteToleranceBuilderImpl
    implements AbsoluteToleranceBuilder {
        protected BigDecimal positive;
        protected BigDecimal negative;
        protected QuantityUnit.QuantityUnitBuilder unit;
        protected PartyReference.PartyReferenceBuilder optionOwnerPartyReference;

        @Override
        @RosettaAttribute(value="positive", isRequired=true)
        @RuneAttribute(value="positive", isRequired=true)
        public BigDecimal getPositive() {
            return this.positive;
        }

        @Override
        @RosettaAttribute(value="negative", isRequired=true)
        @RuneAttribute(value="negative", isRequired=true)
        public BigDecimal getNegative() {
            return this.negative;
        }

        @Override
        @RosettaAttribute(value="unit", isRequired=true)
        @RuneAttribute(value="unit", isRequired=true)
        public QuantityUnit.QuantityUnitBuilder getUnit() {
            return this.unit;
        }

        @Override
        public QuantityUnit.QuantityUnitBuilder getOrCreateUnit() {
            QuantityUnit.QuantityUnitBuilder result = this.unit != null ? this.unit : (this.unit = QuantityUnit.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionOwnerPartyReference")
        @RuneAttribute(value="optionOwnerPartyReference")
        public PartyReference.PartyReferenceBuilder getOptionOwnerPartyReference() {
            return this.optionOwnerPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateOptionOwnerPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.optionOwnerPartyReference != null ? this.optionOwnerPartyReference : (this.optionOwnerPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="positive", isRequired=true)
        @RuneAttribute(value="positive", isRequired=true)
        public AbsoluteToleranceBuilder setPositive(BigDecimal _positive) {
            this.positive = _positive == null ? null : _positive;
            return this;
        }

        @Override
        @RosettaAttribute(value="negative", isRequired=true)
        @RuneAttribute(value="negative", isRequired=true)
        public AbsoluteToleranceBuilder setNegative(BigDecimal _negative) {
            this.negative = _negative == null ? null : _negative;
            return this;
        }

        @Override
        @RosettaAttribute(value="unit", isRequired=true)
        @RuneAttribute(value="unit", isRequired=true)
        public AbsoluteToleranceBuilder setUnit(QuantityUnit _unit) {
            this.unit = _unit == null ? null : _unit.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionOwnerPartyReference")
        @RuneAttribute(value="optionOwnerPartyReference")
        public AbsoluteToleranceBuilder setOptionOwnerPartyReference(PartyReference _optionOwnerPartyReference) {
            this.optionOwnerPartyReference = _optionOwnerPartyReference == null ? null : _optionOwnerPartyReference.toBuilder();
            return this;
        }

        @Override
        public AbsoluteTolerance build() {
            return new AbsoluteToleranceImpl(this);
        }

        @Override
        public AbsoluteToleranceBuilder toBuilder() {
            return this;
        }

        @Override
        public AbsoluteToleranceBuilder prune() {
            if (this.unit != null && !this.unit.prune().hasData()) {
                this.unit = null;
            }
            if (this.optionOwnerPartyReference != null && !this.optionOwnerPartyReference.prune().hasData()) {
                this.optionOwnerPartyReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPositive() != null) {
                return true;
            }
            if (this.getNegative() != null) {
                return true;
            }
            if (this.getUnit() != null && this.getUnit().hasData()) {
                return true;
            }
            return this.getOptionOwnerPartyReference() != null && this.getOptionOwnerPartyReference().hasData();
        }

        public AbsoluteToleranceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AbsoluteToleranceBuilder o = (AbsoluteToleranceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnit(), (RosettaModelObjectBuilder)o.getUnit(), this::setUnit);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionOwnerPartyReference(), (RosettaModelObjectBuilder)o.getOptionOwnerPartyReference(), this::setOptionOwnerPartyReference);
            merger.mergeBasic((Object)this.getPositive(), (Object)o.getPositive(), this::setPositive, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNegative(), (Object)o.getNegative(), this::setNegative, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbsoluteTolerance _that = this.getType().cast(o);
            if (!Objects.equals(this.positive, _that.getPositive())) {
                return false;
            }
            if (!Objects.equals(this.negative, _that.getNegative())) {
                return false;
            }
            if (!Objects.equals(this.unit, _that.getUnit())) {
                return false;
            }
            return Objects.equals(this.optionOwnerPartyReference, _that.getOptionOwnerPartyReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.positive != null ? this.positive.hashCode() : 0);
            _result = 31 * _result + (this.negative != null ? this.negative.hashCode() : 0);
            _result = 31 * _result + (this.unit != null ? this.unit.hashCode() : 0);
            _result = 31 * _result + (this.optionOwnerPartyReference != null ? this.optionOwnerPartyReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbsoluteToleranceBuilder {positive=" + this.positive + ", negative=" + this.negative + ", unit=" + this.unit + ", optionOwnerPartyReference=" + this.optionOwnerPartyReference + '}';
        }
    }

    public static interface AbsoluteToleranceBuilder
    extends AbsoluteTolerance,
    RosettaModelObjectBuilder {
        public QuantityUnit.QuantityUnitBuilder getOrCreateUnit();

        @Override
        public QuantityUnit.QuantityUnitBuilder getUnit();

        public PartyReference.PartyReferenceBuilder getOrCreateOptionOwnerPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getOptionOwnerPartyReference();

        public AbsoluteToleranceBuilder setPositive(BigDecimal var1);

        public AbsoluteToleranceBuilder setNegative(BigDecimal var1);

        public AbsoluteToleranceBuilder setUnit(QuantityUnit var1);

        public AbsoluteToleranceBuilder setOptionOwnerPartyReference(PartyReference var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("positive"), BigDecimal.class, (Object)this.getPositive(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("negative"), BigDecimal.class, (Object)this.getNegative(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unit"), processor, QuantityUnit.QuantityUnitBuilder.class, this.getUnit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionOwnerPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getOptionOwnerPartyReference(), new AttributeMeta[0]);
        }

        public AbsoluteToleranceBuilder prune();
    }

    public static class AbsoluteToleranceImpl
    implements AbsoluteTolerance {
        private final BigDecimal positive;
        private final BigDecimal negative;
        private final QuantityUnit unit;
        private final PartyReference optionOwnerPartyReference;

        protected AbsoluteToleranceImpl(AbsoluteToleranceBuilder builder) {
            this.positive = builder.getPositive();
            this.negative = builder.getNegative();
            this.unit = Optional.ofNullable(builder.getUnit()).map(f -> f.build()).orElse(null);
            this.optionOwnerPartyReference = Optional.ofNullable(builder.getOptionOwnerPartyReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="positive", isRequired=true)
        @RuneAttribute(value="positive", isRequired=true)
        public BigDecimal getPositive() {
            return this.positive;
        }

        @Override
        @RosettaAttribute(value="negative", isRequired=true)
        @RuneAttribute(value="negative", isRequired=true)
        public BigDecimal getNegative() {
            return this.negative;
        }

        @Override
        @RosettaAttribute(value="unit", isRequired=true)
        @RuneAttribute(value="unit", isRequired=true)
        public QuantityUnit getUnit() {
            return this.unit;
        }

        @Override
        @RosettaAttribute(value="optionOwnerPartyReference")
        @RuneAttribute(value="optionOwnerPartyReference")
        public PartyReference getOptionOwnerPartyReference() {
            return this.optionOwnerPartyReference;
        }

        @Override
        public AbsoluteTolerance build() {
            return this;
        }

        @Override
        public AbsoluteToleranceBuilder toBuilder() {
            AbsoluteToleranceBuilder builder = AbsoluteTolerance.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbsoluteToleranceBuilder builder) {
            Optional.ofNullable(this.getPositive()).ifPresent(builder::setPositive);
            Optional.ofNullable(this.getNegative()).ifPresent(builder::setNegative);
            Optional.ofNullable(this.getUnit()).ifPresent(builder::setUnit);
            Optional.ofNullable(this.getOptionOwnerPartyReference()).ifPresent(builder::setOptionOwnerPartyReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbsoluteTolerance _that = this.getType().cast(o);
            if (!Objects.equals(this.positive, _that.getPositive())) {
                return false;
            }
            if (!Objects.equals(this.negative, _that.getNegative())) {
                return false;
            }
            if (!Objects.equals(this.unit, _that.getUnit())) {
                return false;
            }
            return Objects.equals(this.optionOwnerPartyReference, _that.getOptionOwnerPartyReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.positive != null ? this.positive.hashCode() : 0);
            _result = 31 * _result + (this.negative != null ? this.negative.hashCode() : 0);
            _result = 31 * _result + (this.unit != null ? this.unit.hashCode() : 0);
            _result = 31 * _result + (this.optionOwnerPartyReference != null ? this.optionOwnerPartyReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbsoluteTolerance {positive=" + this.positive + ", negative=" + this.negative + ", unit=" + this.unit + ", optionOwnerPartyReference=" + this.optionOwnerPartyReference + '}';
        }
    }
}

