/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.OptionPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="OptionPayoutOptionTypePresent")
@ImplementedBy(value=Default.class)
public interface OptionPayoutOptionTypePresent
extends Validator<OptionPayout> {
    public static final String NAME = "OptionPayoutOptionTypePresent";
    public static final String DEFINITION = "if underlier -> Product -> NonTransferableProduct is absent then optionType exists";

    public static class NoOp
    implements OptionPayoutOptionTypePresent {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionPayout optionPayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements OptionPayoutOptionTypePresent {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionPayout optionPayout) {
            ComparisonResult result = this.executeDataRule(optionPayout);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)OptionPayoutOptionTypePresent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"OptionPayout", (RosettaPath)path, (String)OptionPayoutOptionTypePresent.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)OptionPayoutOptionTypePresent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"OptionPayout", (RosettaPath)path, (String)OptionPayoutOptionTypePresent.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(OptionPayout optionPayout) {
            try {
                if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)optionPayout).map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).map("getProduct", underlier -> underlier.getProduct()).map("getNonTransferableProduct", product -> product.getNonTransferableProduct())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)optionPayout).map("getOptionType", _optionPayout -> _optionPayout.getOptionType()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

