/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="EconomicTermsNotionalResetOnPerformancePayout")
@ImplementedBy(value=Default.class)
public interface EconomicTermsNotionalResetOnPerformancePayout
extends Validator<EconomicTerms> {
    public static final String NAME = "EconomicTermsNotionalResetOnPerformancePayout";
    public static final String DEFINITION = "payout -> CreditDefaultPayout -> priceQuantity -> reset is absent and payout -> AssetPayout -> priceQuantity -> reset is absent and payout -> CommodityPayout -> priceQuantity -> reset is absent and payout -> FixedPricePayout -> priceQuantity -> reset is absent and payout -> SettlementPayout -> priceQuantity -> reset is absent and payout -> OptionPayout -> priceQuantity -> reset is absent";

    public static class NoOp
    implements EconomicTermsNotionalResetOnPerformancePayout {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EconomicTerms economicTerms) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements EconomicTermsNotionalResetOnPerformancePayout {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EconomicTerms economicTerms) {
            ComparisonResult result = this.executeDataRule(economicTerms);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)EconomicTermsNotionalResetOnPerformancePayout.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsNotionalResetOnPerformancePayout.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)EconomicTermsNotionalResetOnPerformancePayout.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsNotionalResetOnPerformancePayout.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(EconomicTerms economicTerms) {
            try {
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getPriceQuantity", creditDefaultPayout -> creditDefaultPayout.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getAssetPayout", payout -> payout.getAssetPayout()).map("getPriceQuantity", assetPayout -> assetPayout.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getFixedPricePayout", payout -> payout.getFixedPricePayout()).map("getPriceQuantity", fixedPricePayout -> fixedPricePayout.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getSettlementPayout", payout -> payout.getSettlementPayout()).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

