/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="EconomicTermsMarketPrice")
@ImplementedBy(value=Default.class)
public interface EconomicTermsMarketPrice
extends Validator<EconomicTerms> {
    public static final String NAME = "EconomicTermsMarketPrice";
    public static final String DEFINITION = "if payout -> CreditDefaultPayout -> generalTerms -> indexReferenceInformation is absent then payout -> CreditDefaultPayout -> transactedPrice -> marketFixedRate is absent and payout -> CreditDefaultPayout -> transactedPrice -> marketPrice is absent";

    public static class NoOp
    implements EconomicTermsMarketPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EconomicTerms economicTerms) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements EconomicTermsMarketPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EconomicTerms economicTerms) {
            ComparisonResult result = this.executeDataRule(economicTerms);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)EconomicTermsMarketPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsMarketPrice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)EconomicTermsMarketPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsMarketPrice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(EconomicTerms economicTerms) {
            try {
                if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getTransactedPrice", creditDefaultPayout -> creditDefaultPayout.getTransactedPrice()).map("getMarketFixedRate", transactedPrice -> transactedPrice.getMarketFixedRate())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getTransactedPrice", creditDefaultPayout -> creditDefaultPayout.getTransactedPrice()).map("getMarketPrice", transactedPrice -> transactedPrice.getMarketPrice())));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

