/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.product.asset.BondReference;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="BondReferenceBondUnderlier")
@ImplementedBy(value=Default.class)
public interface BondReferenceBondUnderlier
extends Validator<BondReference> {
    public static final String NAME = "BondReferenceBondUnderlier";
    public static final String DEFINITION = "bond -> instrumentType = InstrumentTypeEnum -> Debt";

    public static class NoOp
    implements BondReferenceBondUnderlier {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BondReference bondReference) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements BondReferenceBondUnderlier {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BondReference bondReference) {
            ComparisonResult result = this.executeDataRule(bondReference);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)BondReferenceBondUnderlier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BondReference", (RosettaPath)path, (String)BondReferenceBondUnderlier.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)BondReferenceBondUnderlier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BondReference", (RosettaPath)path, (String)BondReferenceBondUnderlier.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(BondReference bondReference) {
            try {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)bondReference).map("getBond", _bondReference -> _bondReference.getBond()).map("getInstrumentType", security -> security.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)InstrumentTypeEnum.DEBT)), (CardinalityOperator)CardinalityOperator.All);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

