/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.staticdata.asset.common.ListedDerivative;
import cdm.observable.asset.DividendApplicability;
import cdm.observable.asset.Price;
import cdm.observable.common.DeterminationMethodEnum;
import cdm.product.asset.EquityUnderlierProvisions;
import cdm.product.asset.ReturnTermsBase;
import cdm.product.asset.ValuationTerms;
import cdm.product.asset.VolatilityCapFloor;
import cdm.product.asset.meta.VolatilityReturnTermsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="VolatilityReturnTerms", builder=VolatilityReturnTermsBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="VolatilityReturnTerms", model="cdm", builder=VolatilityReturnTermsBuilderImpl.class, version="7.0.0-dev.50")
public interface VolatilityReturnTerms
extends ReturnTermsBase {
    public static final VolatilityReturnTermsMeta metaData = new VolatilityReturnTermsMeta();

    public Price getVolatilityStrikePrice();

    public VolatilityCapFloor getVolatilityCapFloor();

    public ListedDerivative getExchangeTradedContractNearest();

    @Override
    public VolatilityReturnTerms build();

    @Override
    public VolatilityReturnTermsBuilder toBuilder();

    public static VolatilityReturnTermsBuilder builder() {
        return new VolatilityReturnTermsBuilderImpl();
    }

    default public RosettaMetaData<? extends VolatilityReturnTerms> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VolatilityReturnTerms> getType() {
        return VolatilityReturnTerms.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("valuationTerms"), processor, ValuationTerms.class, this.getValuationTerms(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("annualizationFactor"), Integer.class, (Object)this.getAnnualizationFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendApplicability"), processor, DividendApplicability.class, this.getDividendApplicability(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityUnderlierProvisions"), processor, EquityUnderlierProvisions.class, this.getEquityUnderlierProvisions(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sharePriceDividendAdjustment"), Boolean.class, (Object)this.getSharePriceDividendAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedN"), Integer.class, (Object)this.getExpectedN(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialLevel"), BigDecimal.class, (Object)this.getInitialLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialLevelSource"), DeterminationMethodEnum.class, (Object)this.getInitialLevelSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("meanAdjustment"), Boolean.class, (Object)this.getMeanAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("performance"), String.class, (Object)this.getPerformance(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("volatilityStrikePrice"), processor, Price.class, this.getVolatilityStrikePrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("volatilityCapFloor"), processor, VolatilityCapFloor.class, this.getVolatilityCapFloor(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeTradedContractNearest"), processor, ListedDerivative.class, this.getExchangeTradedContractNearest(), new AttributeMeta[0]);
    }

    public static class VolatilityReturnTermsBuilderImpl
    extends ReturnTermsBase.ReturnTermsBaseBuilderImpl
    implements VolatilityReturnTermsBuilder {
        protected Price.PriceBuilder volatilityStrikePrice;
        protected VolatilityCapFloor.VolatilityCapFloorBuilder volatilityCapFloor;
        protected ListedDerivative.ListedDerivativeBuilder exchangeTradedContractNearest;

        @Override
        @RosettaAttribute(value="volatilityStrikePrice", isRequired=true)
        @RuneAttribute(value="volatilityStrikePrice", isRequired=true)
        public Price.PriceBuilder getVolatilityStrikePrice() {
            return this.volatilityStrikePrice;
        }

        @Override
        public Price.PriceBuilder getOrCreateVolatilityStrikePrice() {
            Price.PriceBuilder result = this.volatilityStrikePrice != null ? this.volatilityStrikePrice : (this.volatilityStrikePrice = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="volatilityCapFloor")
        @RuneAttribute(value="volatilityCapFloor")
        public VolatilityCapFloor.VolatilityCapFloorBuilder getVolatilityCapFloor() {
            return this.volatilityCapFloor;
        }

        @Override
        public VolatilityCapFloor.VolatilityCapFloorBuilder getOrCreateVolatilityCapFloor() {
            VolatilityCapFloor.VolatilityCapFloorBuilder result = this.volatilityCapFloor != null ? this.volatilityCapFloor : (this.volatilityCapFloor = VolatilityCapFloor.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedContractNearest")
        @RuneAttribute(value="exchangeTradedContractNearest")
        public ListedDerivative.ListedDerivativeBuilder getExchangeTradedContractNearest() {
            return this.exchangeTradedContractNearest;
        }

        @Override
        public ListedDerivative.ListedDerivativeBuilder getOrCreateExchangeTradedContractNearest() {
            ListedDerivative.ListedDerivativeBuilder result = this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest : (this.exchangeTradedContractNearest = ListedDerivative.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="valuationTerms", isRequired=true)
        @RuneAttribute(value="valuationTerms", isRequired=true)
        public VolatilityReturnTermsBuilder setValuationTerms(ValuationTerms _valuationTerms) {
            this.valuationTerms = _valuationTerms == null ? null : _valuationTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="annualizationFactor")
        @RuneAttribute(value="annualizationFactor")
        public VolatilityReturnTermsBuilder setAnnualizationFactor(Integer _annualizationFactor) {
            this.annualizationFactor = _annualizationFactor == null ? null : _annualizationFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendApplicability")
        @RuneAttribute(value="dividendApplicability")
        public VolatilityReturnTermsBuilder setDividendApplicability(DividendApplicability _dividendApplicability) {
            this.dividendApplicability = _dividendApplicability == null ? null : _dividendApplicability.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityUnderlierProvisions")
        @RuneAttribute(value="equityUnderlierProvisions")
        public VolatilityReturnTermsBuilder setEquityUnderlierProvisions(EquityUnderlierProvisions _equityUnderlierProvisions) {
            this.equityUnderlierProvisions = _equityUnderlierProvisions == null ? null : _equityUnderlierProvisions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="sharePriceDividendAdjustment")
        @RuneAttribute(value="sharePriceDividendAdjustment")
        public VolatilityReturnTermsBuilder setSharePriceDividendAdjustment(Boolean _sharePriceDividendAdjustment) {
            this.sharePriceDividendAdjustment = _sharePriceDividendAdjustment == null ? null : _sharePriceDividendAdjustment;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedN", isRequired=true)
        @RuneAttribute(value="expectedN", isRequired=true)
        public VolatilityReturnTermsBuilder setExpectedN(Integer _expectedN) {
            this.expectedN = _expectedN == null ? null : _expectedN;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialLevel")
        @RuneAttribute(value="initialLevel")
        public VolatilityReturnTermsBuilder setInitialLevel(BigDecimal _initialLevel) {
            this.initialLevel = _initialLevel == null ? null : _initialLevel;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialLevelSource")
        @RuneAttribute(value="initialLevelSource")
        public VolatilityReturnTermsBuilder setInitialLevelSource(DeterminationMethodEnum _initialLevelSource) {
            this.initialLevelSource = _initialLevelSource == null ? null : _initialLevelSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="meanAdjustment")
        @RuneAttribute(value="meanAdjustment")
        public VolatilityReturnTermsBuilder setMeanAdjustment(Boolean _meanAdjustment) {
            this.meanAdjustment = _meanAdjustment == null ? null : _meanAdjustment;
            return this;
        }

        @Override
        @RosettaAttribute(value="performance")
        @RuneAttribute(value="performance")
        public VolatilityReturnTermsBuilder setPerformance(String _performance) {
            this.performance = _performance == null ? null : _performance;
            return this;
        }

        @Override
        @RosettaAttribute(value="volatilityStrikePrice", isRequired=true)
        @RuneAttribute(value="volatilityStrikePrice", isRequired=true)
        public VolatilityReturnTermsBuilder setVolatilityStrikePrice(Price _volatilityStrikePrice) {
            this.volatilityStrikePrice = _volatilityStrikePrice == null ? null : _volatilityStrikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="volatilityCapFloor")
        @RuneAttribute(value="volatilityCapFloor")
        public VolatilityReturnTermsBuilder setVolatilityCapFloor(VolatilityCapFloor _volatilityCapFloor) {
            this.volatilityCapFloor = _volatilityCapFloor == null ? null : _volatilityCapFloor.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedContractNearest")
        @RuneAttribute(value="exchangeTradedContractNearest")
        public VolatilityReturnTermsBuilder setExchangeTradedContractNearest(ListedDerivative _exchangeTradedContractNearest) {
            this.exchangeTradedContractNearest = _exchangeTradedContractNearest == null ? null : _exchangeTradedContractNearest.toBuilder();
            return this;
        }

        @Override
        public VolatilityReturnTerms build() {
            return new VolatilityReturnTermsImpl(this);
        }

        @Override
        public VolatilityReturnTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder prune() {
            super.prune();
            if (this.volatilityStrikePrice != null && !this.volatilityStrikePrice.prune().hasData()) {
                this.volatilityStrikePrice = null;
            }
            if (this.volatilityCapFloor != null && !this.volatilityCapFloor.prune().hasData()) {
                this.volatilityCapFloor = null;
            }
            if (this.exchangeTradedContractNearest != null && !this.exchangeTradedContractNearest.prune().hasData()) {
                this.exchangeTradedContractNearest = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getVolatilityStrikePrice() != null && this.getVolatilityStrikePrice().hasData()) {
                return true;
            }
            if (this.getVolatilityCapFloor() != null && this.getVolatilityCapFloor().hasData()) {
                return true;
            }
            return this.getExchangeTradedContractNearest() != null && this.getExchangeTradedContractNearest().hasData();
        }

        @Override
        public VolatilityReturnTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VolatilityReturnTermsBuilder o = (VolatilityReturnTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVolatilityStrikePrice(), (RosettaModelObjectBuilder)o.getVolatilityStrikePrice(), this::setVolatilityStrikePrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVolatilityCapFloor(), (RosettaModelObjectBuilder)o.getVolatilityCapFloor(), this::setVolatilityCapFloor);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeTradedContractNearest(), (RosettaModelObjectBuilder)o.getExchangeTradedContractNearest(), this::setExchangeTradedContractNearest);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilityReturnTerms _that = (VolatilityReturnTerms)this.getType().cast(o);
            if (!Objects.equals(this.volatilityStrikePrice, _that.getVolatilityStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.volatilityCapFloor, _that.getVolatilityCapFloor())) {
                return false;
            }
            return Objects.equals(this.exchangeTradedContractNearest, _that.getExchangeTradedContractNearest());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.volatilityStrikePrice != null ? this.volatilityStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.volatilityCapFloor != null ? this.volatilityCapFloor.hashCode() : 0);
            _result = 31 * _result + (this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilityReturnTermsBuilder {volatilityStrikePrice=" + this.volatilityStrikePrice + ", volatilityCapFloor=" + this.volatilityCapFloor + ", exchangeTradedContractNearest=" + this.exchangeTradedContractNearest + '}' + " " + super.toString();
        }
    }

    public static interface VolatilityReturnTermsBuilder
    extends VolatilityReturnTerms,
    ReturnTermsBase.ReturnTermsBaseBuilder {
        public Price.PriceBuilder getOrCreateVolatilityStrikePrice();

        @Override
        public Price.PriceBuilder getVolatilityStrikePrice();

        public VolatilityCapFloor.VolatilityCapFloorBuilder getOrCreateVolatilityCapFloor();

        @Override
        public VolatilityCapFloor.VolatilityCapFloorBuilder getVolatilityCapFloor();

        public ListedDerivative.ListedDerivativeBuilder getOrCreateExchangeTradedContractNearest();

        @Override
        public ListedDerivative.ListedDerivativeBuilder getExchangeTradedContractNearest();

        @Override
        public VolatilityReturnTermsBuilder setValuationTerms(ValuationTerms var1);

        @Override
        public VolatilityReturnTermsBuilder setAnnualizationFactor(Integer var1);

        @Override
        public VolatilityReturnTermsBuilder setDividendApplicability(DividendApplicability var1);

        @Override
        public VolatilityReturnTermsBuilder setEquityUnderlierProvisions(EquityUnderlierProvisions var1);

        @Override
        public VolatilityReturnTermsBuilder setSharePriceDividendAdjustment(Boolean var1);

        @Override
        public VolatilityReturnTermsBuilder setExpectedN(Integer var1);

        @Override
        public VolatilityReturnTermsBuilder setInitialLevel(BigDecimal var1);

        @Override
        public VolatilityReturnTermsBuilder setInitialLevelSource(DeterminationMethodEnum var1);

        @Override
        public VolatilityReturnTermsBuilder setMeanAdjustment(Boolean var1);

        @Override
        public VolatilityReturnTermsBuilder setPerformance(String var1);

        public VolatilityReturnTermsBuilder setVolatilityStrikePrice(Price var1);

        public VolatilityReturnTermsBuilder setVolatilityCapFloor(VolatilityCapFloor var1);

        public VolatilityReturnTermsBuilder setExchangeTradedContractNearest(ListedDerivative var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("valuationTerms"), processor, ValuationTerms.ValuationTermsBuilder.class, (RosettaModelObjectBuilder)this.getValuationTerms(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("annualizationFactor"), Integer.class, (Object)this.getAnnualizationFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendApplicability"), processor, DividendApplicability.DividendApplicabilityBuilder.class, (RosettaModelObjectBuilder)this.getDividendApplicability(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityUnderlierProvisions"), processor, EquityUnderlierProvisions.EquityUnderlierProvisionsBuilder.class, (RosettaModelObjectBuilder)this.getEquityUnderlierProvisions(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sharePriceDividendAdjustment"), Boolean.class, (Object)this.getSharePriceDividendAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedN"), Integer.class, (Object)this.getExpectedN(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialLevel"), BigDecimal.class, (Object)this.getInitialLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialLevelSource"), DeterminationMethodEnum.class, (Object)this.getInitialLevelSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("meanAdjustment"), Boolean.class, (Object)this.getMeanAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("performance"), String.class, (Object)this.getPerformance(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("volatilityStrikePrice"), processor, Price.PriceBuilder.class, this.getVolatilityStrikePrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("volatilityCapFloor"), processor, VolatilityCapFloor.VolatilityCapFloorBuilder.class, this.getVolatilityCapFloor(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeTradedContractNearest"), processor, ListedDerivative.ListedDerivativeBuilder.class, this.getExchangeTradedContractNearest(), new AttributeMeta[0]);
        }

        @Override
        public VolatilityReturnTermsBuilder prune();
    }

    public static class VolatilityReturnTermsImpl
    extends ReturnTermsBase.ReturnTermsBaseImpl
    implements VolatilityReturnTerms {
        private final Price volatilityStrikePrice;
        private final VolatilityCapFloor volatilityCapFloor;
        private final ListedDerivative exchangeTradedContractNearest;

        protected VolatilityReturnTermsImpl(VolatilityReturnTermsBuilder builder) {
            super(builder);
            this.volatilityStrikePrice = Optional.ofNullable(builder.getVolatilityStrikePrice()).map(f -> f.build()).orElse(null);
            this.volatilityCapFloor = Optional.ofNullable(builder.getVolatilityCapFloor()).map(f -> f.build()).orElse(null);
            this.exchangeTradedContractNearest = Optional.ofNullable(builder.getExchangeTradedContractNearest()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="volatilityStrikePrice", isRequired=true)
        @RuneAttribute(value="volatilityStrikePrice", isRequired=true)
        public Price getVolatilityStrikePrice() {
            return this.volatilityStrikePrice;
        }

        @Override
        @RosettaAttribute(value="volatilityCapFloor")
        @RuneAttribute(value="volatilityCapFloor")
        public VolatilityCapFloor getVolatilityCapFloor() {
            return this.volatilityCapFloor;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedContractNearest")
        @RuneAttribute(value="exchangeTradedContractNearest")
        public ListedDerivative getExchangeTradedContractNearest() {
            return this.exchangeTradedContractNearest;
        }

        @Override
        public VolatilityReturnTerms build() {
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder toBuilder() {
            VolatilityReturnTermsBuilder builder = VolatilityReturnTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VolatilityReturnTermsBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getVolatilityStrikePrice()).ifPresent(builder::setVolatilityStrikePrice);
            Optional.ofNullable(this.getVolatilityCapFloor()).ifPresent(builder::setVolatilityCapFloor);
            Optional.ofNullable(this.getExchangeTradedContractNearest()).ifPresent(builder::setExchangeTradedContractNearest);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilityReturnTerms _that = (VolatilityReturnTerms)this.getType().cast(o);
            if (!Objects.equals(this.volatilityStrikePrice, _that.getVolatilityStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.volatilityCapFloor, _that.getVolatilityCapFloor())) {
                return false;
            }
            return Objects.equals(this.exchangeTradedContractNearest, _that.getExchangeTradedContractNearest());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.volatilityStrikePrice != null ? this.volatilityStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.volatilityCapFloor != null ? this.volatilityCapFloor.hashCode() : 0);
            _result = 31 * _result + (this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilityReturnTerms {volatilityStrikePrice=" + this.volatilityStrikePrice + ", volatilityCapFloor=" + this.volatilityCapFloor + ", exchangeTradedContractNearest=" + this.exchangeTradedContractNearest + '}' + " " + super.toString();
        }
    }
}

