/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.datetime.DayOfWeekEnum;
import cdm.base.math.Quantity;
import cdm.observable.asset.Price;
import cdm.product.asset.meta.AssetDeliveryProfileBlockMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AssetDeliveryProfileBlock", builder=AssetDeliveryProfileBlockBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="AssetDeliveryProfileBlock", model="cdm", builder=AssetDeliveryProfileBlockBuilderImpl.class, version="7.0.0-dev.50")
public interface AssetDeliveryProfileBlock
extends RosettaModelObject {
    public static final AssetDeliveryProfileBlockMeta metaData = new AssetDeliveryProfileBlockMeta();

    public LocalTime getStartTime();

    public LocalTime getEndTime();

    public List<DayOfWeekEnum> getDayOfWeek();

    public Quantity getDeliveryCapacity();

    public Price getPriceTimeIntervalQuantity();

    public AssetDeliveryProfileBlock build();

    public AssetDeliveryProfileBlockBuilder toBuilder();

    public static AssetDeliveryProfileBlockBuilder builder() {
        return new AssetDeliveryProfileBlockBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetDeliveryProfileBlock> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetDeliveryProfileBlock> getType() {
        return AssetDeliveryProfileBlock.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("startTime"), LocalTime.class, (Object)this.getStartTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("endTime"), LocalTime.class, (Object)this.getEndTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayOfWeek"), DayOfWeekEnum.class, this.getDayOfWeek(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryCapacity"), processor, Quantity.class, this.getDeliveryCapacity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceTimeIntervalQuantity"), processor, Price.class, this.getPriceTimeIntervalQuantity(), new AttributeMeta[0]);
    }

    public static class AssetDeliveryProfileBlockBuilderImpl
    implements AssetDeliveryProfileBlockBuilder {
        protected LocalTime startTime;
        protected LocalTime endTime;
        protected List<DayOfWeekEnum> dayOfWeek = new ArrayList<DayOfWeekEnum>();
        protected Quantity.QuantityBuilder deliveryCapacity;
        protected Price.PriceBuilder priceTimeIntervalQuantity;

        @Override
        @RosettaAttribute(value="startTime")
        @RuneAttribute(value="startTime")
        public LocalTime getStartTime() {
            return this.startTime;
        }

        @Override
        @RosettaAttribute(value="endTime")
        @RuneAttribute(value="endTime")
        public LocalTime getEndTime() {
            return this.endTime;
        }

        @Override
        @RosettaAttribute(value="dayOfWeek")
        @RuneAttribute(value="dayOfWeek")
        public List<DayOfWeekEnum> getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        @RuneAttribute(value="deliveryCapacity")
        public Quantity.QuantityBuilder getDeliveryCapacity() {
            return this.deliveryCapacity;
        }

        @Override
        public Quantity.QuantityBuilder getOrCreateDeliveryCapacity() {
            Quantity.QuantityBuilder result = this.deliveryCapacity != null ? this.deliveryCapacity : (this.deliveryCapacity = Quantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceTimeIntervalQuantity")
        @RuneAttribute(value="priceTimeIntervalQuantity")
        public Price.PriceBuilder getPriceTimeIntervalQuantity() {
            return this.priceTimeIntervalQuantity;
        }

        @Override
        public Price.PriceBuilder getOrCreatePriceTimeIntervalQuantity() {
            Price.PriceBuilder result = this.priceTimeIntervalQuantity != null ? this.priceTimeIntervalQuantity : (this.priceTimeIntervalQuantity = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="startTime")
        @RuneAttribute(value="startTime")
        public AssetDeliveryProfileBlockBuilder setStartTime(LocalTime _startTime) {
            this.startTime = _startTime == null ? null : _startTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="endTime")
        @RuneAttribute(value="endTime")
        public AssetDeliveryProfileBlockBuilder setEndTime(LocalTime _endTime) {
            this.endTime = _endTime == null ? null : _endTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="dayOfWeek")
        @RuneAttribute(value="dayOfWeek")
        public AssetDeliveryProfileBlockBuilder addDayOfWeek(DayOfWeekEnum _dayOfWeek) {
            if (_dayOfWeek != null) {
                this.dayOfWeek.add(_dayOfWeek);
            }
            return this;
        }

        @Override
        public AssetDeliveryProfileBlockBuilder addDayOfWeek(DayOfWeekEnum _dayOfWeek, int idx) {
            this.getIndex(this.dayOfWeek, idx, () -> _dayOfWeek);
            return this;
        }

        @Override
        public AssetDeliveryProfileBlockBuilder addDayOfWeek(List<DayOfWeekEnum> dayOfWeeks) {
            if (dayOfWeeks != null) {
                for (DayOfWeekEnum toAdd : dayOfWeeks) {
                    this.dayOfWeek.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="dayOfWeek")
        public AssetDeliveryProfileBlockBuilder setDayOfWeek(List<DayOfWeekEnum> dayOfWeeks) {
            this.dayOfWeek = dayOfWeeks == null ? new ArrayList<DayOfWeekEnum>() : (List)dayOfWeeks.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        @RuneAttribute(value="deliveryCapacity")
        public AssetDeliveryProfileBlockBuilder setDeliveryCapacity(Quantity _deliveryCapacity) {
            this.deliveryCapacity = _deliveryCapacity == null ? null : _deliveryCapacity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceTimeIntervalQuantity")
        @RuneAttribute(value="priceTimeIntervalQuantity")
        public AssetDeliveryProfileBlockBuilder setPriceTimeIntervalQuantity(Price _priceTimeIntervalQuantity) {
            this.priceTimeIntervalQuantity = _priceTimeIntervalQuantity == null ? null : _priceTimeIntervalQuantity.toBuilder();
            return this;
        }

        @Override
        public AssetDeliveryProfileBlock build() {
            return new AssetDeliveryProfileBlockImpl(this);
        }

        @Override
        public AssetDeliveryProfileBlockBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetDeliveryProfileBlockBuilder prune() {
            if (this.deliveryCapacity != null && !this.deliveryCapacity.prune().hasData()) {
                this.deliveryCapacity = null;
            }
            if (this.priceTimeIntervalQuantity != null && !this.priceTimeIntervalQuantity.prune().hasData()) {
                this.priceTimeIntervalQuantity = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStartTime() != null) {
                return true;
            }
            if (this.getEndTime() != null) {
                return true;
            }
            if (this.getDayOfWeek() != null && !this.getDayOfWeek().isEmpty()) {
                return true;
            }
            if (this.getDeliveryCapacity() != null && this.getDeliveryCapacity().hasData()) {
                return true;
            }
            return this.getPriceTimeIntervalQuantity() != null && this.getPriceTimeIntervalQuantity().hasData();
        }

        public AssetDeliveryProfileBlockBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetDeliveryProfileBlockBuilder o = (AssetDeliveryProfileBlockBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryCapacity(), (RosettaModelObjectBuilder)o.getDeliveryCapacity(), this::setDeliveryCapacity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPriceTimeIntervalQuantity(), (RosettaModelObjectBuilder)o.getPriceTimeIntervalQuantity(), this::setPriceTimeIntervalQuantity);
            merger.mergeBasic((Object)this.getStartTime(), (Object)o.getStartTime(), this::setStartTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEndTime(), (Object)o.getEndTime(), this::setEndTime, new AttributeMeta[0]);
            merger.mergeBasic(this.getDayOfWeek(), o.getDayOfWeek(), this::addDayOfWeek);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetDeliveryProfileBlock _that = this.getType().cast(o);
            if (!Objects.equals(this.startTime, _that.getStartTime())) {
                return false;
            }
            if (!Objects.equals(this.endTime, _that.getEndTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dayOfWeek, _that.getDayOfWeek())) {
                return false;
            }
            if (!Objects.equals(this.deliveryCapacity, _that.getDeliveryCapacity())) {
                return false;
            }
            return Objects.equals(this.priceTimeIntervalQuantity, _that.getPriceTimeIntervalQuantity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.startTime != null ? this.startTime.hashCode() : 0);
            _result = 31 * _result + (this.endTime != null ? this.endTime.hashCode() : 0);
            _result = 31 * _result + (this.dayOfWeek != null ? this.dayOfWeek.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.deliveryCapacity != null ? this.deliveryCapacity.hashCode() : 0);
            _result = 31 * _result + (this.priceTimeIntervalQuantity != null ? this.priceTimeIntervalQuantity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetDeliveryProfileBlockBuilder {startTime=" + this.startTime + ", endTime=" + this.endTime + ", dayOfWeek=" + this.dayOfWeek + ", deliveryCapacity=" + this.deliveryCapacity + ", priceTimeIntervalQuantity=" + this.priceTimeIntervalQuantity + '}';
        }
    }

    public static interface AssetDeliveryProfileBlockBuilder
    extends AssetDeliveryProfileBlock,
    RosettaModelObjectBuilder {
        public Quantity.QuantityBuilder getOrCreateDeliveryCapacity();

        @Override
        public Quantity.QuantityBuilder getDeliveryCapacity();

        public Price.PriceBuilder getOrCreatePriceTimeIntervalQuantity();

        @Override
        public Price.PriceBuilder getPriceTimeIntervalQuantity();

        public AssetDeliveryProfileBlockBuilder setStartTime(LocalTime var1);

        public AssetDeliveryProfileBlockBuilder setEndTime(LocalTime var1);

        public AssetDeliveryProfileBlockBuilder addDayOfWeek(DayOfWeekEnum var1);

        public AssetDeliveryProfileBlockBuilder addDayOfWeek(DayOfWeekEnum var1, int var2);

        public AssetDeliveryProfileBlockBuilder addDayOfWeek(List<DayOfWeekEnum> var1);

        public AssetDeliveryProfileBlockBuilder setDayOfWeek(List<DayOfWeekEnum> var1);

        public AssetDeliveryProfileBlockBuilder setDeliveryCapacity(Quantity var1);

        public AssetDeliveryProfileBlockBuilder setPriceTimeIntervalQuantity(Price var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("startTime"), LocalTime.class, (Object)this.getStartTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("endTime"), LocalTime.class, (Object)this.getEndTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayOfWeek"), DayOfWeekEnum.class, this.getDayOfWeek(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryCapacity"), processor, Quantity.QuantityBuilder.class, this.getDeliveryCapacity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceTimeIntervalQuantity"), processor, Price.PriceBuilder.class, this.getPriceTimeIntervalQuantity(), new AttributeMeta[0]);
        }

        public AssetDeliveryProfileBlockBuilder prune();
    }

    public static class AssetDeliveryProfileBlockImpl
    implements AssetDeliveryProfileBlock {
        private final LocalTime startTime;
        private final LocalTime endTime;
        private final List<DayOfWeekEnum> dayOfWeek;
        private final Quantity deliveryCapacity;
        private final Price priceTimeIntervalQuantity;

        protected AssetDeliveryProfileBlockImpl(AssetDeliveryProfileBlockBuilder builder) {
            this.startTime = builder.getStartTime();
            this.endTime = builder.getEndTime();
            this.dayOfWeek = Optional.ofNullable(builder.getDayOfWeek()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.deliveryCapacity = Optional.ofNullable(builder.getDeliveryCapacity()).map(f -> f.build()).orElse(null);
            this.priceTimeIntervalQuantity = Optional.ofNullable(builder.getPriceTimeIntervalQuantity()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="startTime")
        @RuneAttribute(value="startTime")
        public LocalTime getStartTime() {
            return this.startTime;
        }

        @Override
        @RosettaAttribute(value="endTime")
        @RuneAttribute(value="endTime")
        public LocalTime getEndTime() {
            return this.endTime;
        }

        @Override
        @RosettaAttribute(value="dayOfWeek")
        @RuneAttribute(value="dayOfWeek")
        public List<DayOfWeekEnum> getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        @RuneAttribute(value="deliveryCapacity")
        public Quantity getDeliveryCapacity() {
            return this.deliveryCapacity;
        }

        @Override
        @RosettaAttribute(value="priceTimeIntervalQuantity")
        @RuneAttribute(value="priceTimeIntervalQuantity")
        public Price getPriceTimeIntervalQuantity() {
            return this.priceTimeIntervalQuantity;
        }

        @Override
        public AssetDeliveryProfileBlock build() {
            return this;
        }

        @Override
        public AssetDeliveryProfileBlockBuilder toBuilder() {
            AssetDeliveryProfileBlockBuilder builder = AssetDeliveryProfileBlock.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetDeliveryProfileBlockBuilder builder) {
            Optional.ofNullable(this.getStartTime()).ifPresent(builder::setStartTime);
            Optional.ofNullable(this.getEndTime()).ifPresent(builder::setEndTime);
            Optional.ofNullable(this.getDayOfWeek()).ifPresent(builder::setDayOfWeek);
            Optional.ofNullable(this.getDeliveryCapacity()).ifPresent(builder::setDeliveryCapacity);
            Optional.ofNullable(this.getPriceTimeIntervalQuantity()).ifPresent(builder::setPriceTimeIntervalQuantity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetDeliveryProfileBlock _that = this.getType().cast(o);
            if (!Objects.equals(this.startTime, _that.getStartTime())) {
                return false;
            }
            if (!Objects.equals(this.endTime, _that.getEndTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dayOfWeek, _that.getDayOfWeek())) {
                return false;
            }
            if (!Objects.equals(this.deliveryCapacity, _that.getDeliveryCapacity())) {
                return false;
            }
            return Objects.equals(this.priceTimeIntervalQuantity, _that.getPriceTimeIntervalQuantity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.startTime != null ? this.startTime.hashCode() : 0);
            _result = 31 * _result + (this.endTime != null ? this.endTime.hashCode() : 0);
            _result = 31 * _result + (this.dayOfWeek != null ? this.dayOfWeek.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.deliveryCapacity != null ? this.deliveryCapacity.hashCode() : 0);
            _result = 31 * _result + (this.priceTimeIntervalQuantity != null ? this.priceTimeIntervalQuantity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetDeliveryProfileBlock {startTime=" + this.startTime + ", endTime=" + this.endTime + ", dayOfWeek=" + this.dayOfWeek + ", deliveryCapacity=" + this.deliveryCapacity + ", priceTimeIntervalQuantity=" + this.priceTimeIntervalQuantity + '}';
        }
    }
}

