/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.BasketConstituent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="BasketConstituentBasketsOfBaskets")
@ImplementedBy(value=Default.class)
public interface BasketConstituentBasketsOfBaskets
extends Validator<BasketConstituent> {
    public static final String NAME = "BasketConstituentBasketsOfBaskets";
    public static final String DEFINITION = "Basket is absent";

    public static class NoOp
    implements BasketConstituentBasketsOfBaskets {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BasketConstituent basketConstituent) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements BasketConstituentBasketsOfBaskets {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BasketConstituent basketConstituent) {
            ComparisonResult result = this.executeDataRule(basketConstituent);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)BasketConstituentBasketsOfBaskets.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BasketConstituent", (RosettaPath)path, (String)BasketConstituentBasketsOfBaskets.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)BasketConstituentBasketsOfBaskets.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BasketConstituent", (RosettaPath)path, (String)BasketConstituentBasketsOfBaskets.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(BasketConstituent basketConstituent) {
            try {
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)basketConstituent).map("getBasket", _basketConstituent -> _basketConstituent.getBasket()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

