/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.fro;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.observable.asset.fro.FloatingRateIndexCalculationMethodEnum;
import cdm.observable.asset.fro.FloatingRateIndexCategoryEnum;
import cdm.observable.asset.fro.FloatingRateIndexFixingDetails;
import cdm.observable.asset.fro.FloatingRateIndexStyleEnum;
import cdm.observable.asset.fro.meta.FloatingRateIndexCalculationDefaultsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FloatingRateIndexCalculationDefaults", builder=FloatingRateIndexCalculationDefaultsBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="FloatingRateIndexCalculationDefaults", model="cdm", builder=FloatingRateIndexCalculationDefaultsBuilderImpl.class, version="7.0.0-dev.50")
public interface FloatingRateIndexCalculationDefaults
extends RosettaModelObject {
    public static final FloatingRateIndexCalculationDefaultsMeta metaData = new FloatingRateIndexCalculationDefaultsMeta();

    public FloatingRateIndexCategoryEnum getCategory();

    public FloatingRateIndexStyleEnum getIndexStyle();

    public FloatingRateIndexCalculationMethodEnum getMethod();

    public List<? extends FloatingRateIndexFixingDetails> getFixing();

    public DayCountFractionEnum getDayCountFraction();

    public BusinessCenters getApplicableBusinessDays();

    public BusinessCenterEnum getPublicationCalendar();

    public FloatingRateIndexCalculationDefaults build();

    public FloatingRateIndexCalculationDefaultsBuilder toBuilder();

    public static FloatingRateIndexCalculationDefaultsBuilder builder() {
        return new FloatingRateIndexCalculationDefaultsBuilderImpl();
    }

    default public RosettaMetaData<? extends FloatingRateIndexCalculationDefaults> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FloatingRateIndexCalculationDefaults> getType() {
        return FloatingRateIndexCalculationDefaults.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("category"), FloatingRateIndexCategoryEnum.class, (Object)this.getCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexStyle"), FloatingRateIndexStyleEnum.class, (Object)this.getIndexStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("method"), FloatingRateIndexCalculationMethodEnum.class, (Object)this.getMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixing"), processor, FloatingRateIndexFixingDetails.class, this.getFixing(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayCountFraction"), DayCountFractionEnum.class, (Object)this.getDayCountFraction(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("applicableBusinessDays"), processor, BusinessCenters.class, this.getApplicableBusinessDays(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("publicationCalendar"), BusinessCenterEnum.class, (Object)this.getPublicationCalendar(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FloatingRateIndexCalculationDefaultsBuilderImpl
    implements FloatingRateIndexCalculationDefaultsBuilder {
        protected FloatingRateIndexCategoryEnum category;
        protected FloatingRateIndexStyleEnum indexStyle;
        protected FloatingRateIndexCalculationMethodEnum method;
        protected List<FloatingRateIndexFixingDetails.FloatingRateIndexFixingDetailsBuilder> fixing = new ArrayList<FloatingRateIndexFixingDetails.FloatingRateIndexFixingDetailsBuilder>();
        protected DayCountFractionEnum dayCountFraction;
        protected BusinessCenters.BusinessCentersBuilder applicableBusinessDays;
        protected BusinessCenterEnum publicationCalendar;

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public FloatingRateIndexCategoryEnum getCategory() {
            return this.category;
        }

        @Override
        @RosettaAttribute(value="indexStyle")
        @RuneAttribute(value="indexStyle")
        public FloatingRateIndexStyleEnum getIndexStyle() {
            return this.indexStyle;
        }

        @Override
        @RosettaAttribute(value="method")
        @RuneAttribute(value="method")
        public FloatingRateIndexCalculationMethodEnum getMethod() {
            return this.method;
        }

        @Override
        @RosettaAttribute(value="fixing")
        @RuneAttribute(value="fixing")
        public List<? extends FloatingRateIndexFixingDetails.FloatingRateIndexFixingDetailsBuilder> getFixing() {
            return this.fixing;
        }

        @Override
        public FloatingRateIndexFixingDetails.FloatingRateIndexFixingDetailsBuilder getOrCreateFixing(int index) {
            if (this.fixing == null) {
                this.fixing = new ArrayList<FloatingRateIndexFixingDetails.FloatingRateIndexFixingDetailsBuilder>();
            }
            return (FloatingRateIndexFixingDetails.FloatingRateIndexFixingDetailsBuilder)this.getIndex(this.fixing, index, () -> {
                FloatingRateIndexFixingDetails.FloatingRateIndexFixingDetailsBuilder newFixing = FloatingRateIndexFixingDetails.builder();
                return newFixing;
            });
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFractionEnum getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="applicableBusinessDays")
        @RuneAttribute(value="applicableBusinessDays")
        public BusinessCenters.BusinessCentersBuilder getApplicableBusinessDays() {
            return this.applicableBusinessDays;
        }

        @Override
        public BusinessCenters.BusinessCentersBuilder getOrCreateApplicableBusinessDays() {
            BusinessCenters.BusinessCentersBuilder result = this.applicableBusinessDays != null ? this.applicableBusinessDays : (this.applicableBusinessDays = BusinessCenters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="publicationCalendar")
        @RuneAttribute(value="publicationCalendar")
        public BusinessCenterEnum getPublicationCalendar() {
            return this.publicationCalendar;
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public FloatingRateIndexCalculationDefaultsBuilder setCategory(FloatingRateIndexCategoryEnum _category) {
            this.category = _category == null ? null : _category;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexStyle")
        @RuneAttribute(value="indexStyle")
        public FloatingRateIndexCalculationDefaultsBuilder setIndexStyle(FloatingRateIndexStyleEnum _indexStyle) {
            this.indexStyle = _indexStyle == null ? null : _indexStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="method")
        @RuneAttribute(value="method")
        public FloatingRateIndexCalculationDefaultsBuilder setMethod(FloatingRateIndexCalculationMethodEnum _method) {
            this.method = _method == null ? null : _method;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixing")
        @RuneAttribute(value="fixing")
        public FloatingRateIndexCalculationDefaultsBuilder addFixing(FloatingRateIndexFixingDetails _fixing) {
            if (_fixing != null) {
                this.fixing.add(_fixing.toBuilder());
            }
            return this;
        }

        @Override
        public FloatingRateIndexCalculationDefaultsBuilder addFixing(FloatingRateIndexFixingDetails _fixing, int idx) {
            this.getIndex(this.fixing, idx, () -> _fixing.toBuilder());
            return this;
        }

        @Override
        public FloatingRateIndexCalculationDefaultsBuilder addFixing(List<? extends FloatingRateIndexFixingDetails> fixings) {
            if (fixings != null) {
                for (FloatingRateIndexFixingDetails floatingRateIndexFixingDetails : fixings) {
                    this.fixing.add(floatingRateIndexFixingDetails.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fixing")
        public FloatingRateIndexCalculationDefaultsBuilder setFixing(List<? extends FloatingRateIndexFixingDetails> fixings) {
            this.fixing = fixings == null ? new ArrayList<FloatingRateIndexFixingDetails.FloatingRateIndexFixingDetailsBuilder>() : (List)fixings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public FloatingRateIndexCalculationDefaultsBuilder setDayCountFraction(DayCountFractionEnum _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction;
            return this;
        }

        @Override
        @RosettaAttribute(value="applicableBusinessDays")
        @RuneAttribute(value="applicableBusinessDays")
        public FloatingRateIndexCalculationDefaultsBuilder setApplicableBusinessDays(BusinessCenters _applicableBusinessDays) {
            this.applicableBusinessDays = _applicableBusinessDays == null ? null : _applicableBusinessDays.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="publicationCalendar")
        @RuneAttribute(value="publicationCalendar")
        public FloatingRateIndexCalculationDefaultsBuilder setPublicationCalendar(BusinessCenterEnum _publicationCalendar) {
            this.publicationCalendar = _publicationCalendar == null ? null : _publicationCalendar;
            return this;
        }

        @Override
        public FloatingRateIndexCalculationDefaults build() {
            return new FloatingRateIndexCalculationDefaultsImpl(this);
        }

        @Override
        public FloatingRateIndexCalculationDefaultsBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingRateIndexCalculationDefaultsBuilder prune() {
            this.fixing = this.fixing.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.applicableBusinessDays != null && !this.applicableBusinessDays.prune().hasData()) {
                this.applicableBusinessDays = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCategory() != null) {
                return true;
            }
            if (this.getIndexStyle() != null) {
                return true;
            }
            if (this.getMethod() != null) {
                return true;
            }
            if (this.getFixing() != null && this.getFixing().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDayCountFraction() != null) {
                return true;
            }
            if (this.getApplicableBusinessDays() != null && this.getApplicableBusinessDays().hasData()) {
                return true;
            }
            return this.getPublicationCalendar() != null;
        }

        public FloatingRateIndexCalculationDefaultsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FloatingRateIndexCalculationDefaultsBuilder o = (FloatingRateIndexCalculationDefaultsBuilder)other;
            merger.mergeRosetta(this.getFixing(), o.getFixing(), this::getOrCreateFixing);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApplicableBusinessDays(), (RosettaModelObjectBuilder)o.getApplicableBusinessDays(), this::setApplicableBusinessDays);
            merger.mergeBasic((Object)this.getCategory(), (Object)o.getCategory(), this::setCategory, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIndexStyle(), (Object)o.getIndexStyle(), this::setIndexStyle, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMethod(), (Object)o.getMethod(), this::setMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDayCountFraction(), (Object)o.getDayCountFraction(), this::setDayCountFraction, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPublicationCalendar(), (Object)o.getPublicationCalendar(), this::setPublicationCalendar, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateIndexCalculationDefaults _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.category, (Object)_that.getCategory())) {
                return false;
            }
            if (!Objects.equals((Object)this.indexStyle, (Object)_that.getIndexStyle())) {
                return false;
            }
            if (!Objects.equals((Object)this.method, (Object)_that.getMethod())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixing, _that.getFixing())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayCountFraction, (Object)_that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.applicableBusinessDays, _that.getApplicableBusinessDays())) {
                return false;
            }
            return Objects.equals((Object)this.publicationCalendar, (Object)_that.getPublicationCalendar());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.category != null ? ((Object)((Object)this.category)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.indexStyle != null ? ((Object)((Object)this.indexStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.method != null ? ((Object)((Object)this.method)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixing != null ? this.fixing.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? ((Object)((Object)this.dayCountFraction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.applicableBusinessDays != null ? this.applicableBusinessDays.hashCode() : 0);
            _result = 31 * _result + (this.publicationCalendar != null ? ((Object)((Object)this.publicationCalendar)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateIndexCalculationDefaultsBuilder {category=" + (Object)((Object)this.category) + ", indexStyle=" + (Object)((Object)this.indexStyle) + ", method=" + (Object)((Object)this.method) + ", fixing=" + this.fixing + ", dayCountFraction=" + (Object)((Object)this.dayCountFraction) + ", applicableBusinessDays=" + this.applicableBusinessDays + ", publicationCalendar=" + (Object)((Object)this.publicationCalendar) + '}';
        }
    }

    public static interface FloatingRateIndexCalculationDefaultsBuilder
    extends FloatingRateIndexCalculationDefaults,
    RosettaModelObjectBuilder {
        public FloatingRateIndexFixingDetails.FloatingRateIndexFixingDetailsBuilder getOrCreateFixing(int var1);

        public List<? extends FloatingRateIndexFixingDetails.FloatingRateIndexFixingDetailsBuilder> getFixing();

        public BusinessCenters.BusinessCentersBuilder getOrCreateApplicableBusinessDays();

        @Override
        public BusinessCenters.BusinessCentersBuilder getApplicableBusinessDays();

        public FloatingRateIndexCalculationDefaultsBuilder setCategory(FloatingRateIndexCategoryEnum var1);

        public FloatingRateIndexCalculationDefaultsBuilder setIndexStyle(FloatingRateIndexStyleEnum var1);

        public FloatingRateIndexCalculationDefaultsBuilder setMethod(FloatingRateIndexCalculationMethodEnum var1);

        public FloatingRateIndexCalculationDefaultsBuilder addFixing(FloatingRateIndexFixingDetails var1);

        public FloatingRateIndexCalculationDefaultsBuilder addFixing(FloatingRateIndexFixingDetails var1, int var2);

        public FloatingRateIndexCalculationDefaultsBuilder addFixing(List<? extends FloatingRateIndexFixingDetails> var1);

        public FloatingRateIndexCalculationDefaultsBuilder setFixing(List<? extends FloatingRateIndexFixingDetails> var1);

        public FloatingRateIndexCalculationDefaultsBuilder setDayCountFraction(DayCountFractionEnum var1);

        public FloatingRateIndexCalculationDefaultsBuilder setApplicableBusinessDays(BusinessCenters var1);

        public FloatingRateIndexCalculationDefaultsBuilder setPublicationCalendar(BusinessCenterEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("category"), FloatingRateIndexCategoryEnum.class, (Object)this.getCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexStyle"), FloatingRateIndexStyleEnum.class, (Object)this.getIndexStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("method"), FloatingRateIndexCalculationMethodEnum.class, (Object)this.getMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixing"), processor, FloatingRateIndexFixingDetails.FloatingRateIndexFixingDetailsBuilder.class, this.getFixing(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayCountFraction"), DayCountFractionEnum.class, (Object)this.getDayCountFraction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("applicableBusinessDays"), processor, BusinessCenters.BusinessCentersBuilder.class, this.getApplicableBusinessDays(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("publicationCalendar"), BusinessCenterEnum.class, (Object)this.getPublicationCalendar(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FloatingRateIndexCalculationDefaultsBuilder prune();
    }

    public static class FloatingRateIndexCalculationDefaultsImpl
    implements FloatingRateIndexCalculationDefaults {
        private final FloatingRateIndexCategoryEnum category;
        private final FloatingRateIndexStyleEnum indexStyle;
        private final FloatingRateIndexCalculationMethodEnum method;
        private final List<? extends FloatingRateIndexFixingDetails> fixing;
        private final DayCountFractionEnum dayCountFraction;
        private final BusinessCenters applicableBusinessDays;
        private final BusinessCenterEnum publicationCalendar;

        protected FloatingRateIndexCalculationDefaultsImpl(FloatingRateIndexCalculationDefaultsBuilder builder) {
            this.category = builder.getCategory();
            this.indexStyle = builder.getIndexStyle();
            this.method = builder.getMethod();
            this.fixing = Optional.ofNullable(builder.getFixing()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.dayCountFraction = builder.getDayCountFraction();
            this.applicableBusinessDays = Optional.ofNullable(builder.getApplicableBusinessDays()).map(f -> f.build()).orElse(null);
            this.publicationCalendar = builder.getPublicationCalendar();
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public FloatingRateIndexCategoryEnum getCategory() {
            return this.category;
        }

        @Override
        @RosettaAttribute(value="indexStyle")
        @RuneAttribute(value="indexStyle")
        public FloatingRateIndexStyleEnum getIndexStyle() {
            return this.indexStyle;
        }

        @Override
        @RosettaAttribute(value="method")
        @RuneAttribute(value="method")
        public FloatingRateIndexCalculationMethodEnum getMethod() {
            return this.method;
        }

        @Override
        @RosettaAttribute(value="fixing")
        @RuneAttribute(value="fixing")
        public List<? extends FloatingRateIndexFixingDetails> getFixing() {
            return this.fixing;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFractionEnum getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="applicableBusinessDays")
        @RuneAttribute(value="applicableBusinessDays")
        public BusinessCenters getApplicableBusinessDays() {
            return this.applicableBusinessDays;
        }

        @Override
        @RosettaAttribute(value="publicationCalendar")
        @RuneAttribute(value="publicationCalendar")
        public BusinessCenterEnum getPublicationCalendar() {
            return this.publicationCalendar;
        }

        @Override
        public FloatingRateIndexCalculationDefaults build() {
            return this;
        }

        @Override
        public FloatingRateIndexCalculationDefaultsBuilder toBuilder() {
            FloatingRateIndexCalculationDefaultsBuilder builder = FloatingRateIndexCalculationDefaults.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingRateIndexCalculationDefaultsBuilder builder) {
            Optional.ofNullable(this.getCategory()).ifPresent(builder::setCategory);
            Optional.ofNullable(this.getIndexStyle()).ifPresent(builder::setIndexStyle);
            Optional.ofNullable(this.getMethod()).ifPresent(builder::setMethod);
            Optional.ofNullable(this.getFixing()).ifPresent(builder::setFixing);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getApplicableBusinessDays()).ifPresent(builder::setApplicableBusinessDays);
            Optional.ofNullable(this.getPublicationCalendar()).ifPresent(builder::setPublicationCalendar);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateIndexCalculationDefaults _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.category, (Object)_that.getCategory())) {
                return false;
            }
            if (!Objects.equals((Object)this.indexStyle, (Object)_that.getIndexStyle())) {
                return false;
            }
            if (!Objects.equals((Object)this.method, (Object)_that.getMethod())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixing, _that.getFixing())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayCountFraction, (Object)_that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.applicableBusinessDays, _that.getApplicableBusinessDays())) {
                return false;
            }
            return Objects.equals((Object)this.publicationCalendar, (Object)_that.getPublicationCalendar());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.category != null ? ((Object)((Object)this.category)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.indexStyle != null ? ((Object)((Object)this.indexStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.method != null ? ((Object)((Object)this.method)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixing != null ? this.fixing.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? ((Object)((Object)this.dayCountFraction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.applicableBusinessDays != null ? this.applicableBusinessDays.hashCode() : 0);
            _result = 31 * _result + (this.publicationCalendar != null ? ((Object)((Object)this.publicationCalendar)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateIndexCalculationDefaults {category=" + (Object)((Object)this.category) + ", indexStyle=" + (Object)((Object)this.indexStyle) + ", method=" + (Object)((Object)this.method) + ", fixing=" + this.fixing + ", dayCountFraction=" + (Object)((Object)this.dayCountFraction) + ", applicableBusinessDays=" + this.applicableBusinessDays + ", publicationCalendar=" + (Object)((Object)this.publicationCalendar) + '}';
        }
    }
}

