/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.observable.asset.Price;
import cdm.product.asset.VarianceReturnTerms;
import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=StandardizedScheduleFXVarianceNotionalAmountDefault.class)
public abstract class StandardizedScheduleFXVarianceNotionalAmount
implements RosettaFunction {
    public BigDecimal evaluate(PerformancePayout performancePayout) {
        BigDecimal amount = this.doEvaluate(performancePayout);
        return amount;
    }

    protected abstract BigDecimal doEvaluate(PerformancePayout var1);

    protected abstract MapperS<? extends VarianceReturnTerms> varianceReturnTerms(PerformancePayout var1);

    protected abstract MapperS<? extends NonNegativeQuantitySchedule> vegaNotionalAmount(PerformancePayout var1);

    protected abstract MapperS<? extends Price> fixedRate(PerformancePayout var1);

    public static class StandardizedScheduleFXVarianceNotionalAmountDefault
    extends StandardizedScheduleFXVarianceNotionalAmount {
        @Override
        protected BigDecimal doEvaluate(PerformancePayout performancePayout) {
            BigDecimal amount = null;
            return this.assignOutput(amount, performancePayout);
        }

        protected BigDecimal assignOutput(BigDecimal amount, PerformancePayout performancePayout) {
            amount = (BigDecimal)MapperMaths.divide((Mapper)this.vegaNotionalAmount(performancePayout).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)new BigDecimal("0.02")), (Mapper)this.fixedRate(performancePayout).map("getValue", price -> price.getValue()))).get();
            return amount;
        }

        @Override
        protected MapperS<? extends VarianceReturnTerms> varianceReturnTerms(PerformancePayout performancePayout) {
            return MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getVarianceReturnTerms", returnTerms -> returnTerms.getVarianceReturnTerms());
        }

        @Override
        protected MapperS<? extends NonNegativeQuantitySchedule> vegaNotionalAmount(PerformancePayout performancePayout) {
            return this.varianceReturnTerms(performancePayout).map("getVegaNotionalAmount", _varianceReturnTerms -> _varianceReturnTerms.getVegaNotionalAmount());
        }

        @Override
        protected MapperS<? extends Price> fixedRate(PerformancePayout performancePayout) {
            return this.varianceReturnTerms(performancePayout).map("getVarianceStrikePrice", _varianceReturnTerms -> _varianceReturnTerms.getVarianceStrikePrice());
        }
    }
}

