/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.observable.asset.PriceQuantity;
import cdm.product.template.SettlementPayout;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=StandardizedScheduleFXSwapNotionalDefault.class)
public abstract class StandardizedScheduleFXSwapNotional
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public NonNegativeQuantitySchedule evaluate(SettlementPayout farLeg, TradeLot tradeLot) {
        NonNegativeQuantitySchedule quantity;
        NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantityBuilder = this.doEvaluate(farLeg, tradeLot);
        if (quantityBuilder == null) {
            quantity = null;
        } else {
            quantity = quantityBuilder.build();
            this.objectValidator.validate(NonNegativeQuantitySchedule.class, (RosettaModelObject)quantity);
        }
        return quantity;
    }

    protected abstract NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(SettlementPayout var1, TradeLot var2);

    protected abstract MapperS<? extends PriceQuantity> priceQuantity(SettlementPayout var1, TradeLot var2);

    protected abstract MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> exchangedCurrencies(SettlementPayout var1, TradeLot var2);

    protected abstract MapperS<? extends FieldWithMetaNonNegativeQuantitySchedule> extractedExchangedCurrency(SettlementPayout var1, TradeLot var2);

    public static class StandardizedScheduleFXSwapNotionalDefault
    extends StandardizedScheduleFXSwapNotional {
        @Override
        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(SettlementPayout farLeg, TradeLot tradeLot) {
            NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantity = NonNegativeQuantitySchedule.builder();
            return this.assignOutput(quantity, farLeg, tradeLot);
        }

        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder assignOutput(NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantity, SettlementPayout farLeg, TradeLot tradeLot) {
            FieldWithMetaNonNegativeQuantitySchedule fieldWithMetaNonNegativeQuantitySchedule = (FieldWithMetaNonNegativeQuantitySchedule)this.extractedExchangedCurrency(farLeg, tradeLot).get();
            quantity = fieldWithMetaNonNegativeQuantitySchedule == null ? null : (NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder)this.toBuilder(fieldWithMetaNonNegativeQuantitySchedule.getValue());
            return Optional.ofNullable(quantity).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends PriceQuantity> priceQuantity(SettlementPayout farLeg, TradeLot tradeLot) {
            MapperC thenArg = MapperS.of((Object)tradeLot).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.mapC("getPrice", _priceQuantity -> _priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()), (Mapper)MapperS.of((Object)farLeg).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).mapC("getPriceSchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getPriceSchedule()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule.getValue()), (CardinalityOperator)CardinalityOperator.All).get());
            return MapperS.of((Object)((PriceQuantity)thenArg.get()));
        }

        @Override
        protected MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> exchangedCurrencies(SettlementPayout farLeg, TradeLot tradeLot) {
            return this.priceQuantity(farLeg, tradeLot).mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity());
        }

        @Override
        protected MapperS<? extends FieldWithMetaNonNegativeQuantitySchedule> extractedExchangedCurrency(SettlementPayout farLeg, TradeLot tradeLot) {
            if (ExpressionOperators.areEqual((Mapper)this.exchangedCurrencies(farLeg, tradeLot).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)"USD"), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg0 = this.exchangedCurrencies(farLeg, tradeLot).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)"USD"), (CardinalityOperator)CardinalityOperator.All).get());
                return MapperS.of((Object)((FieldWithMetaNonNegativeQuantitySchedule)thenArg0.get()));
            }
            if (ExpressionOperators.areEqual((Mapper)this.exchangedCurrencies(farLeg, tradeLot).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)"EUR"), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg1 = this.exchangedCurrencies(farLeg, tradeLot).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)"EUR"), (CardinalityOperator)CardinalityOperator.All).get());
                return MapperS.of((Object)((FieldWithMetaNonNegativeQuantitySchedule)thenArg1.get()));
            }
            if (ExpressionOperators.areEqual((Mapper)this.exchangedCurrencies(farLeg, tradeLot).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)"JPY"), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg2 = this.exchangedCurrencies(farLeg, tradeLot).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)"JPY"), (CardinalityOperator)CardinalityOperator.All).get());
                return MapperS.of((Object)((FieldWithMetaNonNegativeQuantitySchedule)thenArg2.get()));
            }
            if (ExpressionOperators.areEqual((Mapper)this.exchangedCurrencies(farLeg, tradeLot).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)"GBP"), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg3 = this.exchangedCurrencies(farLeg, tradeLot).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)"GBP"), (CardinalityOperator)CardinalityOperator.All).get());
                return MapperS.of((Object)((FieldWithMetaNonNegativeQuantitySchedule)thenArg3.get()));
            }
            if (ExpressionOperators.areEqual((Mapper)this.exchangedCurrencies(farLeg, tradeLot).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)"CHF"), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg4 = this.exchangedCurrencies(farLeg, tradeLot).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)"CHF"), (CardinalityOperator)CardinalityOperator.All).get());
                return MapperS.of((Object)((FieldWithMetaNonNegativeQuantitySchedule)thenArg4.get()));
            }
            return this.exchangedCurrencies(farLeg, tradeLot).sort(item -> item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue())).first();
        }
    }
}

