/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.functions.AdjustableDateResolution;
import cdm.event.common.Trade;
import cdm.product.template.EconomicTerms;
import cdm.product.template.NonTransferableProduct;
import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import cdm.product.template.util.ProductDeepPathUtil;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import javax.inject.Inject;

@ImplementedBy(value=AuxiliarTerminationDateDefault.class)
public abstract class AuxiliarTerminationDate
implements RosettaFunction {
    @Inject
    protected AdjustableDateResolution adjustableDateResolution;
    @Inject
    protected ProductDeepPathUtil productDeepPathUtil;

    public Date evaluate(Trade trade) {
        Date terminationDate = this.doEvaluate(trade);
        return terminationDate;
    }

    protected abstract Date doEvaluate(Trade var1);

    protected abstract MapperS<? extends NonTransferableProduct> product(Trade var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(Trade var1);

    public static class AuxiliarTerminationDateDefault
    extends AuxiliarTerminationDate {
        @Override
        protected Date doEvaluate(Trade trade) {
            Date terminationDate = null;
            return this.assignOutput(terminationDate, trade);
        }

        protected Date assignOutput(Date terminationDate, Trade trade) {
            if (ExpressionOperators.exists((Mapper)this.economicTerms(trade).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg0 = this.economicTerms(trade).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).mapItem(item -> MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)item.get())));
                terminationDate = (Date)thenArg0.max().get();
            } else if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((OptionPayout)this.economicTerms(trade).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getProduct", underlier -> underlier.getProduct()).map("chooseEconomicTerms", _product -> this.productDeepPathUtil.chooseEconomicTerms((Product)_product)).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg1 = MapperS.of((Object)((OptionPayout)this.economicTerms(trade).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getProduct", underlier -> underlier.getProduct()).map("chooseEconomicTerms", _product -> this.productDeepPathUtil.chooseEconomicTerms((Product)_product)).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).mapItem(item -> MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)item.get())));
                terminationDate = (Date)thenArg1.max().get();
            } else {
                terminationDate = null;
            }
            return terminationDate;
        }

        @Override
        protected MapperS<? extends NonTransferableProduct> product(Trade trade) {
            return MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct());
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(Trade trade) {
            return this.product(trade).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms());
        }
    }
}

