/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.transaction.additionalterms.validation.datarule;

import cdm.legaldocumentation.transaction.additionalterms.Nationalization;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="NationalizationAssignmentOfClaim")
@ImplementedBy(value=Default.class)
public interface NationalizationAssignmentOfClaim
extends Validator<Nationalization> {
    public static final String NAME = "NationalizationAssignmentOfClaim";
    public static final String DEFINITION = "if nationalizationIsApplicable = False then assignmentOfClaim is absent";

    public static class NoOp
    implements NationalizationAssignmentOfClaim {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Nationalization nationalization) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements NationalizationAssignmentOfClaim {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Nationalization nationalization) {
            ComparisonResult result = this.executeDataRule(nationalization);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)NationalizationAssignmentOfClaim.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Nationalization", (RosettaPath)path, (String)NationalizationAssignmentOfClaim.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)NationalizationAssignmentOfClaim.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Nationalization", (RosettaPath)path, (String)NationalizationAssignmentOfClaim.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Nationalization nationalization) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)nationalization).map("getNationalizationIsApplicable", _nationalization -> _nationalization.getNationalizationIsApplicable()), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)nationalization).map("getAssignmentOfClaim", _nationalization -> _nationalization.getAssignmentOfClaim()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

