/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.RatingAgencyValue;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="RatingAgencyValueAgencyValueType")
@ImplementedBy(value=Default.class)
public interface RatingAgencyValueAgencyValueType
extends Validator<RatingAgencyValue> {
    public static final String NAME = "RatingAgencyValueAgencyValueType";
    public static final String DEFINITION = "((agency exists and notation exists and ratingType exists) or (agency is absent and notation is absent and ratingType is absent)) and (scale is absent and debt is absent and outlook is absent and creditWatch is absent)";

    public static class NoOp
    implements RatingAgencyValueAgencyValueType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, RatingAgencyValue ratingAgencyValue) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements RatingAgencyValueAgencyValueType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, RatingAgencyValue ratingAgencyValue) {
            ComparisonResult result = this.executeDataRule(ratingAgencyValue);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)RatingAgencyValueAgencyValueType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"RatingAgencyValue", (RosettaPath)path, (String)RatingAgencyValueAgencyValueType.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)RatingAgencyValueAgencyValueType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"RatingAgencyValue", (RosettaPath)path, (String)RatingAgencyValueAgencyValueType.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(RatingAgencyValue ratingAgencyValue) {
            try {
                return ExpressionOperators.exists((Mapper)MapperS.of((Object)ratingAgencyValue).map("getAgency", _ratingAgencyValue -> _ratingAgencyValue.getAgency())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)ratingAgencyValue).map("getNotation", _ratingAgencyValue -> _ratingAgencyValue.getNotation()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)ratingAgencyValue).map("getRatingType", _ratingAgencyValue -> _ratingAgencyValue.getRatingType()))).or(ExpressionOperators.notExists((Mapper)MapperS.of((Object)ratingAgencyValue).map("getAgency", _ratingAgencyValue -> _ratingAgencyValue.getAgency())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)ratingAgencyValue).map("getNotation", _ratingAgencyValue -> _ratingAgencyValue.getNotation()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)ratingAgencyValue).map("getRatingType", _ratingAgencyValue -> _ratingAgencyValue.getRatingType())))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)ratingAgencyValue).map("getScale", _ratingAgencyValue -> _ratingAgencyValue.getScale())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)ratingAgencyValue).map("getDebt", _ratingAgencyValue -> _ratingAgencyValue.getDebt()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)ratingAgencyValue).map("getOutlook", _ratingAgencyValue -> _ratingAgencyValue.getOutlook()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)ratingAgencyValue).map("getCreditWatch", _ratingAgencyValue -> _ratingAgencyValue.getCreditWatch()))));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

