/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.base.Enums;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import java.util.List;

public class IsoCurrencyMappingProcessor
extends MappingProcessor {
    public IsoCurrencyMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext mappingContext) {
        super(modelPath, synonymPaths, mappingContext);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        if (builder instanceof FieldWithMetaString.FieldWithMetaStringBuilder) {
            FieldWithMetaString.FieldWithMetaStringBuilder currencyBuilder = (FieldWithMetaString.FieldWithMetaStringBuilder)builder;
            String currencyValue = currencyBuilder.getValue();
            if (this.setCurrency(currencyBuilder, this.getSynonymToEnumMap().getEnumValueOptional(ISOCurrencyCodeEnum.class, currencyValue).orElse((ISOCurrencyCodeEnum)((Object)Enums.getIfPresent(ISOCurrencyCodeEnum.class, (String)currencyValue).orNull())))) {
                return;
            }
            MappingProcessorUtils.filterMappings((List)this.getMappings(), (RosettaPath)this.getModelPath()).forEach(m -> MappingProcessorUtils.updateMappingFail((Mapping)m, (String)String.format("Element with value \"%s\" could not be mapped to a ISO currency code", currencyValue)));
        }
    }

    private boolean setCurrency(FieldWithMetaString.FieldWithMetaStringBuilder currencyBuilder, ISOCurrencyCodeEnum isoCurrencyCode) {
        if (isoCurrencyCode != null) {
            currencyBuilder.setValue(isoCurrencyCode.name()).setMeta(MetaFields.builder().setScheme("http://www.fpml.org/ext/iso4217").build());
            return true;
        }
        currencyBuilder.setValue(null);
        return false;
    }
}

