/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.legaldocumentation.csa.AccessConditions;
import cdm.legaldocumentation.csa.AdditionalTerminationEvent;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

public class AdditionalTerminationEventMappingProcessor
extends MappingProcessor {
    private static final String APPLICABLE = "applicable";
    private static final List<String> SUFFIXES = Arrays.asList("_additional_termination_event", "_additional_termination_events");

    public AdditionalTerminationEventMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext mappingContext) {
        super(modelPath, synonymPaths, mappingContext);
    }

    public void map(Path accessConditionsPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        Optional<AdditionalTerminationEvent> additionalTerminationEventBuilder;
        AccessConditions.AccessConditionsBuilder accessConditionsBuilder = (AccessConditions.AccessConditionsBuilder)builder;
        accessConditionsBuilder.setAdditionalTerminationEvent(new ArrayList());
        Path eventsPath = accessConditionsPath.addElement("additional_termination_event");
        int index = 0;
        while ((additionalTerminationEventBuilder = this.getAdditionalTerminationEvent(eventsPath, "name", index++)).isPresent()) {
            accessConditionsBuilder.addAdditionalTerminationEvent(additionalTerminationEventBuilder.get());
        }
        this.getAdditionalTerminationEvent(accessConditionsPath, "specify", null).ifPresent(accessConditionsBuilder::addAdditionalTerminationEvent);
    }

    private Optional<AdditionalTerminationEvent> getAdditionalTerminationEvent(Path basePath, String synonym, Integer index) {
        boolean applicablePartySet;
        AdditionalTerminationEvent.AdditionalTerminationEventBuilder eventBuilder = AdditionalTerminationEvent.builder();
        this.setValueAndUpdateMappings(basePath.addElement(synonym, index), eventBuilder::setName);
        boolean nameSet = eventBuilder.hasData();
        CreateiQMappingProcessorUtils.PARTIES.forEach(party -> SUFFIXES.forEach(suffix -> this.setValueAndUpdateMappings(basePath.addElement(party + suffix, index), value -> this.addIfApplicable(eventBuilder, (String)party, (String)value, nameSet))));
        boolean bl = applicablePartySet = Optional.ofNullable(eventBuilder.getApplicableParty()).map(Collection::isEmpty).orElse(true) == false;
        if (nameSet || applicablePartySet) {
            MappingProcessorUtils.updateMappings((Path)basePath, (List)this.getMappings(), (RosettaPath)this.getModelPath());
        }
        return eventBuilder.hasData() && applicablePartySet ? Optional.of(eventBuilder.build()) : Optional.empty();
    }

    private void addIfApplicable(AdditionalTerminationEvent.AdditionalTerminationEventBuilder eventBuilder, String party, String value, boolean nameSet) {
        if (APPLICABLE.equals(value) && nameSet) {
            eventBuilder.addApplicableParty(CreateiQMappingProcessorUtils.toCounterpartyRoleEnum(party));
        }
    }
}

