/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.legaldocumentation.csa.AdditionalTerminationEventEnum;
import cdm.legaldocumentation.csa.CSASpecifiedConditionEnum;
import cdm.legaldocumentation.csa.meta.SpecifiedConditionPartyElectionMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SpecifiedConditionPartyElection", builder=SpecifiedConditionPartyElectionBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="SpecifiedConditionPartyElection", model="cdm", builder=SpecifiedConditionPartyElectionBuilderImpl.class, version="7.0.0-dev.50")
public interface SpecifiedConditionPartyElection
extends RosettaModelObject {
    public static final SpecifiedConditionPartyElectionMeta metaData = new SpecifiedConditionPartyElectionMeta();

    public CounterpartyRoleEnum getParty();

    public List<CSASpecifiedConditionEnum> getSpecifiedCondition();

    public List<AdditionalTerminationEventEnum> getAdditionalTerminationEvent();

    public String getSpecifiedAdditionalTerminationEvent();

    public SpecifiedConditionPartyElection build();

    public SpecifiedConditionPartyElectionBuilder toBuilder();

    public static SpecifiedConditionPartyElectionBuilder builder() {
        return new SpecifiedConditionPartyElectionBuilderImpl();
    }

    default public RosettaMetaData<? extends SpecifiedConditionPartyElection> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SpecifiedConditionPartyElection> getType() {
        return SpecifiedConditionPartyElection.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("specifiedCondition"), CSASpecifiedConditionEnum.class, this.getSpecifiedCondition(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("additionalTerminationEvent"), AdditionalTerminationEventEnum.class, this.getAdditionalTerminationEvent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("specifiedAdditionalTerminationEvent"), String.class, (Object)this.getSpecifiedAdditionalTerminationEvent(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SpecifiedConditionPartyElectionBuilderImpl
    implements SpecifiedConditionPartyElectionBuilder {
        protected CounterpartyRoleEnum party;
        protected List<CSASpecifiedConditionEnum> specifiedCondition = new ArrayList<CSASpecifiedConditionEnum>();
        protected List<AdditionalTerminationEventEnum> additionalTerminationEvent = new ArrayList<AdditionalTerminationEventEnum>();
        protected String specifiedAdditionalTerminationEvent;

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="specifiedCondition")
        @RuneAttribute(value="specifiedCondition")
        public List<CSASpecifiedConditionEnum> getSpecifiedCondition() {
            return this.specifiedCondition;
        }

        @Override
        @RosettaAttribute(value="additionalTerminationEvent")
        @RuneAttribute(value="additionalTerminationEvent")
        public List<AdditionalTerminationEventEnum> getAdditionalTerminationEvent() {
            return this.additionalTerminationEvent;
        }

        @Override
        @RosettaAttribute(value="specifiedAdditionalTerminationEvent")
        @RuneAttribute(value="specifiedAdditionalTerminationEvent")
        public String getSpecifiedAdditionalTerminationEvent() {
            return this.specifiedAdditionalTerminationEvent;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public SpecifiedConditionPartyElectionBuilder setParty(CounterpartyRoleEnum _party) {
            this.party = _party == null ? null : _party;
            return this;
        }

        @Override
        @RosettaAttribute(value="specifiedCondition")
        @RuneAttribute(value="specifiedCondition")
        public SpecifiedConditionPartyElectionBuilder addSpecifiedCondition(CSASpecifiedConditionEnum _specifiedCondition) {
            if (_specifiedCondition != null) {
                this.specifiedCondition.add(_specifiedCondition);
            }
            return this;
        }

        @Override
        public SpecifiedConditionPartyElectionBuilder addSpecifiedCondition(CSASpecifiedConditionEnum _specifiedCondition, int idx) {
            this.getIndex(this.specifiedCondition, idx, () -> _specifiedCondition);
            return this;
        }

        @Override
        public SpecifiedConditionPartyElectionBuilder addSpecifiedCondition(List<CSASpecifiedConditionEnum> specifiedConditions) {
            if (specifiedConditions != null) {
                for (CSASpecifiedConditionEnum toAdd : specifiedConditions) {
                    this.specifiedCondition.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="specifiedCondition")
        public SpecifiedConditionPartyElectionBuilder setSpecifiedCondition(List<CSASpecifiedConditionEnum> specifiedConditions) {
            this.specifiedCondition = specifiedConditions == null ? new ArrayList<CSASpecifiedConditionEnum>() : (List)specifiedConditions.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalTerminationEvent")
        @RuneAttribute(value="additionalTerminationEvent")
        public SpecifiedConditionPartyElectionBuilder addAdditionalTerminationEvent(AdditionalTerminationEventEnum _additionalTerminationEvent) {
            if (_additionalTerminationEvent != null) {
                this.additionalTerminationEvent.add(_additionalTerminationEvent);
            }
            return this;
        }

        @Override
        public SpecifiedConditionPartyElectionBuilder addAdditionalTerminationEvent(AdditionalTerminationEventEnum _additionalTerminationEvent, int idx) {
            this.getIndex(this.additionalTerminationEvent, idx, () -> _additionalTerminationEvent);
            return this;
        }

        @Override
        public SpecifiedConditionPartyElectionBuilder addAdditionalTerminationEvent(List<AdditionalTerminationEventEnum> additionalTerminationEvents) {
            if (additionalTerminationEvents != null) {
                for (AdditionalTerminationEventEnum toAdd : additionalTerminationEvents) {
                    this.additionalTerminationEvent.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalTerminationEvent")
        public SpecifiedConditionPartyElectionBuilder setAdditionalTerminationEvent(List<AdditionalTerminationEventEnum> additionalTerminationEvents) {
            this.additionalTerminationEvent = additionalTerminationEvents == null ? new ArrayList<AdditionalTerminationEventEnum>() : (List)additionalTerminationEvents.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="specifiedAdditionalTerminationEvent")
        @RuneAttribute(value="specifiedAdditionalTerminationEvent")
        public SpecifiedConditionPartyElectionBuilder setSpecifiedAdditionalTerminationEvent(String _specifiedAdditionalTerminationEvent) {
            this.specifiedAdditionalTerminationEvent = _specifiedAdditionalTerminationEvent == null ? null : _specifiedAdditionalTerminationEvent;
            return this;
        }

        @Override
        public SpecifiedConditionPartyElection build() {
            return new SpecifiedConditionPartyElectionImpl(this);
        }

        @Override
        public SpecifiedConditionPartyElectionBuilder toBuilder() {
            return this;
        }

        @Override
        public SpecifiedConditionPartyElectionBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getParty() != null) {
                return true;
            }
            if (this.getSpecifiedCondition() != null && !this.getSpecifiedCondition().isEmpty()) {
                return true;
            }
            if (this.getAdditionalTerminationEvent() != null && !this.getAdditionalTerminationEvent().isEmpty()) {
                return true;
            }
            return this.getSpecifiedAdditionalTerminationEvent() != null;
        }

        public SpecifiedConditionPartyElectionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SpecifiedConditionPartyElectionBuilder o = (SpecifiedConditionPartyElectionBuilder)other;
            merger.mergeBasic((Object)this.getParty(), (Object)o.getParty(), this::setParty, new AttributeMeta[0]);
            merger.mergeBasic(this.getSpecifiedCondition(), o.getSpecifiedCondition(), this::addSpecifiedCondition);
            merger.mergeBasic(this.getAdditionalTerminationEvent(), o.getAdditionalTerminationEvent(), this::addAdditionalTerminationEvent);
            merger.mergeBasic((Object)this.getSpecifiedAdditionalTerminationEvent(), (Object)o.getSpecifiedAdditionalTerminationEvent(), this::setSpecifiedAdditionalTerminationEvent, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SpecifiedConditionPartyElection _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.specifiedCondition, _that.getSpecifiedCondition())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalTerminationEvent, _that.getAdditionalTerminationEvent())) {
                return false;
            }
            return Objects.equals(this.specifiedAdditionalTerminationEvent, _that.getSpecifiedAdditionalTerminationEvent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.specifiedCondition != null ? this.specifiedCondition.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.additionalTerminationEvent != null ? this.additionalTerminationEvent.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.specifiedAdditionalTerminationEvent != null ? this.specifiedAdditionalTerminationEvent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SpecifiedConditionPartyElectionBuilder {party=" + (Object)((Object)this.party) + ", specifiedCondition=" + this.specifiedCondition + ", additionalTerminationEvent=" + this.additionalTerminationEvent + ", specifiedAdditionalTerminationEvent=" + this.specifiedAdditionalTerminationEvent + '}';
        }
    }

    public static interface SpecifiedConditionPartyElectionBuilder
    extends SpecifiedConditionPartyElection,
    RosettaModelObjectBuilder {
        public SpecifiedConditionPartyElectionBuilder setParty(CounterpartyRoleEnum var1);

        public SpecifiedConditionPartyElectionBuilder addSpecifiedCondition(CSASpecifiedConditionEnum var1);

        public SpecifiedConditionPartyElectionBuilder addSpecifiedCondition(CSASpecifiedConditionEnum var1, int var2);

        public SpecifiedConditionPartyElectionBuilder addSpecifiedCondition(List<CSASpecifiedConditionEnum> var1);

        public SpecifiedConditionPartyElectionBuilder setSpecifiedCondition(List<CSASpecifiedConditionEnum> var1);

        public SpecifiedConditionPartyElectionBuilder addAdditionalTerminationEvent(AdditionalTerminationEventEnum var1);

        public SpecifiedConditionPartyElectionBuilder addAdditionalTerminationEvent(AdditionalTerminationEventEnum var1, int var2);

        public SpecifiedConditionPartyElectionBuilder addAdditionalTerminationEvent(List<AdditionalTerminationEventEnum> var1);

        public SpecifiedConditionPartyElectionBuilder setAdditionalTerminationEvent(List<AdditionalTerminationEventEnum> var1);

        public SpecifiedConditionPartyElectionBuilder setSpecifiedAdditionalTerminationEvent(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("specifiedCondition"), CSASpecifiedConditionEnum.class, this.getSpecifiedCondition(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("additionalTerminationEvent"), AdditionalTerminationEventEnum.class, this.getAdditionalTerminationEvent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("specifiedAdditionalTerminationEvent"), String.class, (Object)this.getSpecifiedAdditionalTerminationEvent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public SpecifiedConditionPartyElectionBuilder prune();
    }

    public static class SpecifiedConditionPartyElectionImpl
    implements SpecifiedConditionPartyElection {
        private final CounterpartyRoleEnum party;
        private final List<CSASpecifiedConditionEnum> specifiedCondition;
        private final List<AdditionalTerminationEventEnum> additionalTerminationEvent;
        private final String specifiedAdditionalTerminationEvent;

        protected SpecifiedConditionPartyElectionImpl(SpecifiedConditionPartyElectionBuilder builder) {
            this.party = builder.getParty();
            this.specifiedCondition = Optional.ofNullable(builder.getSpecifiedCondition()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.additionalTerminationEvent = Optional.ofNullable(builder.getAdditionalTerminationEvent()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.specifiedAdditionalTerminationEvent = builder.getSpecifiedAdditionalTerminationEvent();
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="specifiedCondition")
        @RuneAttribute(value="specifiedCondition")
        public List<CSASpecifiedConditionEnum> getSpecifiedCondition() {
            return this.specifiedCondition;
        }

        @Override
        @RosettaAttribute(value="additionalTerminationEvent")
        @RuneAttribute(value="additionalTerminationEvent")
        public List<AdditionalTerminationEventEnum> getAdditionalTerminationEvent() {
            return this.additionalTerminationEvent;
        }

        @Override
        @RosettaAttribute(value="specifiedAdditionalTerminationEvent")
        @RuneAttribute(value="specifiedAdditionalTerminationEvent")
        public String getSpecifiedAdditionalTerminationEvent() {
            return this.specifiedAdditionalTerminationEvent;
        }

        @Override
        public SpecifiedConditionPartyElection build() {
            return this;
        }

        @Override
        public SpecifiedConditionPartyElectionBuilder toBuilder() {
            SpecifiedConditionPartyElectionBuilder builder = SpecifiedConditionPartyElection.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SpecifiedConditionPartyElectionBuilder builder) {
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getSpecifiedCondition()).ifPresent(builder::setSpecifiedCondition);
            Optional.ofNullable(this.getAdditionalTerminationEvent()).ifPresent(builder::setAdditionalTerminationEvent);
            Optional.ofNullable(this.getSpecifiedAdditionalTerminationEvent()).ifPresent(builder::setSpecifiedAdditionalTerminationEvent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SpecifiedConditionPartyElection _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.specifiedCondition, _that.getSpecifiedCondition())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalTerminationEvent, _that.getAdditionalTerminationEvent())) {
                return false;
            }
            return Objects.equals(this.specifiedAdditionalTerminationEvent, _that.getSpecifiedAdditionalTerminationEvent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.specifiedCondition != null ? this.specifiedCondition.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.additionalTerminationEvent != null ? this.additionalTerminationEvent.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.specifiedAdditionalTerminationEvent != null ? this.specifiedAdditionalTerminationEvent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SpecifiedConditionPartyElection {party=" + (Object)((Object)this.party) + ", specifiedCondition=" + this.specifiedCondition + ", additionalTerminationEvent=" + this.additionalTerminationEvent + ", specifiedAdditionalTerminationEvent=" + this.specifiedAdditionalTerminationEvent + '}';
        }
    }
}

