/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.legaldocumentation.csa.SecurityInterestObligationsEnum;
import cdm.legaldocumentation.csa.SecurityInterestObligeeEnum;
import cdm.legaldocumentation.csa.meta.SecurityInterestForObligationsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SecurityInterestForObligations", builder=SecurityInterestForObligationsBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="SecurityInterestForObligations", model="cdm", builder=SecurityInterestForObligationsBuilderImpl.class, version="7.0.0-dev.50")
public interface SecurityInterestForObligations
extends RosettaModelObject {
    public static final SecurityInterestForObligationsMeta metaData = new SecurityInterestForObligationsMeta();

    public List<CounterpartyRoleEnum> getParty();

    public SecurityInterestObligationsEnum getObligations();

    public SecurityInterestObligeeEnum getObligee();

    public String getOther();

    public SecurityInterestForObligations build();

    public SecurityInterestForObligationsBuilder toBuilder();

    public static SecurityInterestForObligationsBuilder builder() {
        return new SecurityInterestForObligationsBuilderImpl();
    }

    default public RosettaMetaData<? extends SecurityInterestForObligations> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SecurityInterestForObligations> getType() {
        return SecurityInterestForObligations.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, this.getParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("obligations"), SecurityInterestObligationsEnum.class, (Object)this.getObligations(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("obligee"), SecurityInterestObligeeEnum.class, (Object)this.getObligee(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("other"), String.class, (Object)this.getOther(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SecurityInterestForObligationsBuilderImpl
    implements SecurityInterestForObligationsBuilder {
        protected List<CounterpartyRoleEnum> party = new ArrayList<CounterpartyRoleEnum>();
        protected SecurityInterestObligationsEnum obligations;
        protected SecurityInterestObligeeEnum obligee;
        protected String other;

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<CounterpartyRoleEnum> getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="obligations", isRequired=true)
        @RuneAttribute(value="obligations", isRequired=true)
        public SecurityInterestObligationsEnum getObligations() {
            return this.obligations;
        }

        @Override
        @RosettaAttribute(value="obligee", isRequired=true)
        @RuneAttribute(value="obligee", isRequired=true)
        public SecurityInterestObligeeEnum getObligee() {
            return this.obligee;
        }

        @Override
        @RosettaAttribute(value="other")
        @RuneAttribute(value="other")
        public String getOther() {
            return this.other;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public SecurityInterestForObligationsBuilder addParty(CounterpartyRoleEnum _party) {
            if (_party != null) {
                this.party.add(_party);
            }
            return this;
        }

        @Override
        public SecurityInterestForObligationsBuilder addParty(CounterpartyRoleEnum _party, int idx) {
            this.getIndex(this.party, idx, () -> _party);
            return this;
        }

        @Override
        public SecurityInterestForObligationsBuilder addParty(List<CounterpartyRoleEnum> partys) {
            if (partys != null) {
                for (CounterpartyRoleEnum toAdd : partys) {
                    this.party.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public SecurityInterestForObligationsBuilder setParty(List<CounterpartyRoleEnum> partys) {
            this.party = partys == null ? new ArrayList<CounterpartyRoleEnum>() : (List)partys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="obligations", isRequired=true)
        @RuneAttribute(value="obligations", isRequired=true)
        public SecurityInterestForObligationsBuilder setObligations(SecurityInterestObligationsEnum _obligations) {
            this.obligations = _obligations == null ? null : _obligations;
            return this;
        }

        @Override
        @RosettaAttribute(value="obligee", isRequired=true)
        @RuneAttribute(value="obligee", isRequired=true)
        public SecurityInterestForObligationsBuilder setObligee(SecurityInterestObligeeEnum _obligee) {
            this.obligee = _obligee == null ? null : _obligee;
            return this;
        }

        @Override
        @RosettaAttribute(value="other")
        @RuneAttribute(value="other")
        public SecurityInterestForObligationsBuilder setOther(String _other) {
            this.other = _other == null ? null : _other;
            return this;
        }

        @Override
        public SecurityInterestForObligations build() {
            return new SecurityInterestForObligationsImpl(this);
        }

        @Override
        public SecurityInterestForObligationsBuilder toBuilder() {
            return this;
        }

        @Override
        public SecurityInterestForObligationsBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getParty() != null && !this.getParty().isEmpty()) {
                return true;
            }
            if (this.getObligations() != null) {
                return true;
            }
            if (this.getObligee() != null) {
                return true;
            }
            return this.getOther() != null;
        }

        public SecurityInterestForObligationsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SecurityInterestForObligationsBuilder o = (SecurityInterestForObligationsBuilder)other;
            merger.mergeBasic(this.getParty(), o.getParty(), this::addParty);
            merger.mergeBasic((Object)this.getObligations(), (Object)o.getObligations(), this::setObligations, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getObligee(), (Object)o.getObligee(), this::setObligee, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOther(), (Object)o.getOther(), this::setOther, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SecurityInterestForObligations _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.obligations, (Object)_that.getObligations())) {
                return false;
            }
            if (!Objects.equals((Object)this.obligee, (Object)_that.getObligee())) {
                return false;
            }
            return Objects.equals(this.other, _that.getOther());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? this.party.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.obligations != null ? ((Object)((Object)this.obligations)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.obligee != null ? ((Object)((Object)this.obligee)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.other != null ? this.other.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SecurityInterestForObligationsBuilder {party=" + this.party + ", obligations=" + (Object)((Object)this.obligations) + ", obligee=" + (Object)((Object)this.obligee) + ", other=" + this.other + '}';
        }
    }

    public static interface SecurityInterestForObligationsBuilder
    extends SecurityInterestForObligations,
    RosettaModelObjectBuilder {
        public SecurityInterestForObligationsBuilder addParty(CounterpartyRoleEnum var1);

        public SecurityInterestForObligationsBuilder addParty(CounterpartyRoleEnum var1, int var2);

        public SecurityInterestForObligationsBuilder addParty(List<CounterpartyRoleEnum> var1);

        public SecurityInterestForObligationsBuilder setParty(List<CounterpartyRoleEnum> var1);

        public SecurityInterestForObligationsBuilder setObligations(SecurityInterestObligationsEnum var1);

        public SecurityInterestForObligationsBuilder setObligee(SecurityInterestObligeeEnum var1);

        public SecurityInterestForObligationsBuilder setOther(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, this.getParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("obligations"), SecurityInterestObligationsEnum.class, (Object)this.getObligations(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("obligee"), SecurityInterestObligeeEnum.class, (Object)this.getObligee(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("other"), String.class, (Object)this.getOther(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public SecurityInterestForObligationsBuilder prune();
    }

    public static class SecurityInterestForObligationsImpl
    implements SecurityInterestForObligations {
        private final List<CounterpartyRoleEnum> party;
        private final SecurityInterestObligationsEnum obligations;
        private final SecurityInterestObligeeEnum obligee;
        private final String other;

        protected SecurityInterestForObligationsImpl(SecurityInterestForObligationsBuilder builder) {
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.obligations = builder.getObligations();
            this.obligee = builder.getObligee();
            this.other = builder.getOther();
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<CounterpartyRoleEnum> getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="obligations", isRequired=true)
        @RuneAttribute(value="obligations", isRequired=true)
        public SecurityInterestObligationsEnum getObligations() {
            return this.obligations;
        }

        @Override
        @RosettaAttribute(value="obligee", isRequired=true)
        @RuneAttribute(value="obligee", isRequired=true)
        public SecurityInterestObligeeEnum getObligee() {
            return this.obligee;
        }

        @Override
        @RosettaAttribute(value="other")
        @RuneAttribute(value="other")
        public String getOther() {
            return this.other;
        }

        @Override
        public SecurityInterestForObligations build() {
            return this;
        }

        @Override
        public SecurityInterestForObligationsBuilder toBuilder() {
            SecurityInterestForObligationsBuilder builder = SecurityInterestForObligations.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SecurityInterestForObligationsBuilder builder) {
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getObligations()).ifPresent(builder::setObligations);
            Optional.ofNullable(this.getObligee()).ifPresent(builder::setObligee);
            Optional.ofNullable(this.getOther()).ifPresent(builder::setOther);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SecurityInterestForObligations _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.obligations, (Object)_that.getObligations())) {
                return false;
            }
            if (!Objects.equals((Object)this.obligee, (Object)_that.getObligee())) {
                return false;
            }
            return Objects.equals(this.other, _that.getOther());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? this.party.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.obligations != null ? ((Object)((Object)this.obligations)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.obligee != null ? ((Object)((Object)this.obligee)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.other != null ? this.other.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SecurityInterestForObligations {party=" + this.party + ", obligations=" + (Object)((Object)this.obligations) + ", obligee=" + (Object)((Object)this.obligee) + ", other=" + this.other + '}';
        }
    }
}

