/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.legaldocumentation.csa.ValuationTimeDayEnum;
import cdm.legaldocumentation.csa.ValuationTimeEnum;
import cdm.legaldocumentation.csa.meta.LegacyValuationTimeMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LegacyValuationTime", builder=LegacyValuationTimeBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="LegacyValuationTime", model="cdm", builder=LegacyValuationTimeBuilderImpl.class, version="7.0.0-dev.50")
public interface LegacyValuationTime
extends RosettaModelObject {
    public static final LegacyValuationTimeMeta metaData = new LegacyValuationTimeMeta();

    public ValuationTimeDayEnum getDay();

    public List<BusinessCenterEnum> getLocation();

    public ValuationTimeEnum getTime();

    public LocalTime getHourminutetime();

    public BusinessCenterEnum getTimezone();

    public String getAdditionalLanguage();

    public LegacyValuationTime build();

    public LegacyValuationTimeBuilder toBuilder();

    public static LegacyValuationTimeBuilder builder() {
        return new LegacyValuationTimeBuilderImpl();
    }

    default public RosettaMetaData<? extends LegacyValuationTime> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LegacyValuationTime> getType() {
        return LegacyValuationTime.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("day"), ValuationTimeDayEnum.class, (Object)this.getDay(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("location"), BusinessCenterEnum.class, this.getLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("time"), ValuationTimeEnum.class, (Object)this.getTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("hourminutetime"), LocalTime.class, (Object)this.getHourminutetime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("timezone"), BusinessCenterEnum.class, (Object)this.getTimezone(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("additionalLanguage"), String.class, (Object)this.getAdditionalLanguage(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class LegacyValuationTimeBuilderImpl
    implements LegacyValuationTimeBuilder {
        protected ValuationTimeDayEnum day;
        protected List<BusinessCenterEnum> location = new ArrayList<BusinessCenterEnum>();
        protected ValuationTimeEnum time;
        protected LocalTime hourminutetime;
        protected BusinessCenterEnum timezone;
        protected String additionalLanguage;

        @Override
        @RosettaAttribute(value="day")
        @RuneAttribute(value="day")
        public ValuationTimeDayEnum getDay() {
            return this.day;
        }

        @Override
        @RosettaAttribute(value="location")
        @RuneAttribute(value="location")
        public List<BusinessCenterEnum> getLocation() {
            return this.location;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public ValuationTimeEnum getTime() {
            return this.time;
        }

        @Override
        @RosettaAttribute(value="hourminutetime")
        @RuneAttribute(value="hourminutetime")
        public LocalTime getHourminutetime() {
            return this.hourminutetime;
        }

        @Override
        @RosettaAttribute(value="timezone")
        @RuneAttribute(value="timezone")
        public BusinessCenterEnum getTimezone() {
            return this.timezone;
        }

        @Override
        @RosettaAttribute(value="additionalLanguage")
        @RuneAttribute(value="additionalLanguage")
        public String getAdditionalLanguage() {
            return this.additionalLanguage;
        }

        @Override
        @RosettaAttribute(value="day")
        @RuneAttribute(value="day")
        public LegacyValuationTimeBuilder setDay(ValuationTimeDayEnum _day) {
            this.day = _day == null ? null : _day;
            return this;
        }

        @Override
        @RosettaAttribute(value="location")
        @RuneAttribute(value="location")
        public LegacyValuationTimeBuilder addLocation(BusinessCenterEnum _location) {
            if (_location != null) {
                this.location.add(_location);
            }
            return this;
        }

        @Override
        public LegacyValuationTimeBuilder addLocation(BusinessCenterEnum _location, int idx) {
            this.getIndex(this.location, idx, () -> _location);
            return this;
        }

        @Override
        public LegacyValuationTimeBuilder addLocation(List<BusinessCenterEnum> locations) {
            if (locations != null) {
                for (BusinessCenterEnum toAdd : locations) {
                    this.location.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="location")
        public LegacyValuationTimeBuilder setLocation(List<BusinessCenterEnum> locations) {
            this.location = locations == null ? new ArrayList<BusinessCenterEnum>() : (List)locations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public LegacyValuationTimeBuilder setTime(ValuationTimeEnum _time) {
            this.time = _time == null ? null : _time;
            return this;
        }

        @Override
        @RosettaAttribute(value="hourminutetime")
        @RuneAttribute(value="hourminutetime")
        public LegacyValuationTimeBuilder setHourminutetime(LocalTime _hourminutetime) {
            this.hourminutetime = _hourminutetime == null ? null : _hourminutetime;
            return this;
        }

        @Override
        @RosettaAttribute(value="timezone")
        @RuneAttribute(value="timezone")
        public LegacyValuationTimeBuilder setTimezone(BusinessCenterEnum _timezone) {
            this.timezone = _timezone == null ? null : _timezone;
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalLanguage")
        @RuneAttribute(value="additionalLanguage")
        public LegacyValuationTimeBuilder setAdditionalLanguage(String _additionalLanguage) {
            this.additionalLanguage = _additionalLanguage == null ? null : _additionalLanguage;
            return this;
        }

        @Override
        public LegacyValuationTime build() {
            return new LegacyValuationTimeImpl(this);
        }

        @Override
        public LegacyValuationTimeBuilder toBuilder() {
            return this;
        }

        @Override
        public LegacyValuationTimeBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getDay() != null) {
                return true;
            }
            if (this.getLocation() != null && !this.getLocation().isEmpty()) {
                return true;
            }
            if (this.getTime() != null) {
                return true;
            }
            if (this.getHourminutetime() != null) {
                return true;
            }
            if (this.getTimezone() != null) {
                return true;
            }
            return this.getAdditionalLanguage() != null;
        }

        public LegacyValuationTimeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LegacyValuationTimeBuilder o = (LegacyValuationTimeBuilder)other;
            merger.mergeBasic((Object)this.getDay(), (Object)o.getDay(), this::setDay, new AttributeMeta[0]);
            merger.mergeBasic(this.getLocation(), o.getLocation(), this::addLocation);
            merger.mergeBasic((Object)this.getTime(), (Object)o.getTime(), this::setTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getHourminutetime(), (Object)o.getHourminutetime(), this::setHourminutetime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTimezone(), (Object)o.getTimezone(), this::setTimezone, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdditionalLanguage(), (Object)o.getAdditionalLanguage(), this::setAdditionalLanguage, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegacyValuationTime _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.day, (Object)_that.getDay())) {
                return false;
            }
            if (!ListEquals.listEquals(this.location, _that.getLocation())) {
                return false;
            }
            if (!Objects.equals((Object)this.time, (Object)_that.getTime())) {
                return false;
            }
            if (!Objects.equals(this.hourminutetime, _that.getHourminutetime())) {
                return false;
            }
            if (!Objects.equals((Object)this.timezone, (Object)_that.getTimezone())) {
                return false;
            }
            return Objects.equals(this.additionalLanguage, _that.getAdditionalLanguage());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.day != null ? ((Object)((Object)this.day)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.location != null ? this.location.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.time != null ? ((Object)((Object)this.time)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.hourminutetime != null ? this.hourminutetime.hashCode() : 0);
            _result = 31 * _result + (this.timezone != null ? ((Object)((Object)this.timezone)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.additionalLanguage != null ? this.additionalLanguage.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegacyValuationTimeBuilder {day=" + (Object)((Object)this.day) + ", location=" + this.location + ", time=" + (Object)((Object)this.time) + ", hourminutetime=" + this.hourminutetime + ", timezone=" + (Object)((Object)this.timezone) + ", additionalLanguage=" + this.additionalLanguage + '}';
        }
    }

    public static interface LegacyValuationTimeBuilder
    extends LegacyValuationTime,
    RosettaModelObjectBuilder {
        public LegacyValuationTimeBuilder setDay(ValuationTimeDayEnum var1);

        public LegacyValuationTimeBuilder addLocation(BusinessCenterEnum var1);

        public LegacyValuationTimeBuilder addLocation(BusinessCenterEnum var1, int var2);

        public LegacyValuationTimeBuilder addLocation(List<BusinessCenterEnum> var1);

        public LegacyValuationTimeBuilder setLocation(List<BusinessCenterEnum> var1);

        public LegacyValuationTimeBuilder setTime(ValuationTimeEnum var1);

        public LegacyValuationTimeBuilder setHourminutetime(LocalTime var1);

        public LegacyValuationTimeBuilder setTimezone(BusinessCenterEnum var1);

        public LegacyValuationTimeBuilder setAdditionalLanguage(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("day"), ValuationTimeDayEnum.class, (Object)this.getDay(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("location"), BusinessCenterEnum.class, this.getLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("time"), ValuationTimeEnum.class, (Object)this.getTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("hourminutetime"), LocalTime.class, (Object)this.getHourminutetime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("timezone"), BusinessCenterEnum.class, (Object)this.getTimezone(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("additionalLanguage"), String.class, (Object)this.getAdditionalLanguage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public LegacyValuationTimeBuilder prune();
    }

    public static class LegacyValuationTimeImpl
    implements LegacyValuationTime {
        private final ValuationTimeDayEnum day;
        private final List<BusinessCenterEnum> location;
        private final ValuationTimeEnum time;
        private final LocalTime hourminutetime;
        private final BusinessCenterEnum timezone;
        private final String additionalLanguage;

        protected LegacyValuationTimeImpl(LegacyValuationTimeBuilder builder) {
            this.day = builder.getDay();
            this.location = Optional.ofNullable(builder.getLocation()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.time = builder.getTime();
            this.hourminutetime = builder.getHourminutetime();
            this.timezone = builder.getTimezone();
            this.additionalLanguage = builder.getAdditionalLanguage();
        }

        @Override
        @RosettaAttribute(value="day")
        @RuneAttribute(value="day")
        public ValuationTimeDayEnum getDay() {
            return this.day;
        }

        @Override
        @RosettaAttribute(value="location")
        @RuneAttribute(value="location")
        public List<BusinessCenterEnum> getLocation() {
            return this.location;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public ValuationTimeEnum getTime() {
            return this.time;
        }

        @Override
        @RosettaAttribute(value="hourminutetime")
        @RuneAttribute(value="hourminutetime")
        public LocalTime getHourminutetime() {
            return this.hourminutetime;
        }

        @Override
        @RosettaAttribute(value="timezone")
        @RuneAttribute(value="timezone")
        public BusinessCenterEnum getTimezone() {
            return this.timezone;
        }

        @Override
        @RosettaAttribute(value="additionalLanguage")
        @RuneAttribute(value="additionalLanguage")
        public String getAdditionalLanguage() {
            return this.additionalLanguage;
        }

        @Override
        public LegacyValuationTime build() {
            return this;
        }

        @Override
        public LegacyValuationTimeBuilder toBuilder() {
            LegacyValuationTimeBuilder builder = LegacyValuationTime.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegacyValuationTimeBuilder builder) {
            Optional.ofNullable(this.getDay()).ifPresent(builder::setDay);
            Optional.ofNullable(this.getLocation()).ifPresent(builder::setLocation);
            Optional.ofNullable(this.getTime()).ifPresent(builder::setTime);
            Optional.ofNullable(this.getHourminutetime()).ifPresent(builder::setHourminutetime);
            Optional.ofNullable(this.getTimezone()).ifPresent(builder::setTimezone);
            Optional.ofNullable(this.getAdditionalLanguage()).ifPresent(builder::setAdditionalLanguage);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegacyValuationTime _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.day, (Object)_that.getDay())) {
                return false;
            }
            if (!ListEquals.listEquals(this.location, _that.getLocation())) {
                return false;
            }
            if (!Objects.equals((Object)this.time, (Object)_that.getTime())) {
                return false;
            }
            if (!Objects.equals(this.hourminutetime, _that.getHourminutetime())) {
                return false;
            }
            if (!Objects.equals((Object)this.timezone, (Object)_that.getTimezone())) {
                return false;
            }
            return Objects.equals(this.additionalLanguage, _that.getAdditionalLanguage());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.day != null ? ((Object)((Object)this.day)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.location != null ? this.location.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.time != null ? ((Object)((Object)this.time)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.hourminutetime != null ? this.hourminutetime.hashCode() : 0);
            _result = 31 * _result + (this.timezone != null ? ((Object)((Object)this.timezone)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.additionalLanguage != null ? this.additionalLanguage.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegacyValuationTime {day=" + (Object)((Object)this.day) + ", location=" + this.location + ", time=" + (Object)((Object)this.time) + ", hourminutetime=" + this.hourminutetime + ", timezone=" + (Object)((Object)this.timezone) + ", additionalLanguage=" + this.additionalLanguage + '}';
        }
    }
}

