/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.contract.processor;

import cdm.base.staticdata.party.AncillaryParty;
import cdm.base.staticdata.party.AncillaryRoleEnum;
import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.product.template.TradableProduct;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.util.CollectionUtils;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartyMappingHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartyMappingHelper.class);
    static final String PARTY_MAPPING_HELPER_KEY = "PARTY_MAPPING_HELPER";
    private final Map<String, CounterpartyRoleEnum> partyExternalReferenceToCounterpartyRoleEnumMap;
    private final List<Mapping> mappings;
    private final CompletableFuture<Map<String, CounterpartyRoleEnum>> bothCounterpartiesCollected = new CompletableFuture();
    private final TradableProduct.TradableProductBuilder tradableProductBuilder;
    private final Function<String, Optional<String>> translator;
    private final ExecutorService executor;
    private final List<CompletableFuture<?>> invokedTasks;

    PartyMappingHelper(MappingContext context, TradableProduct.TradableProductBuilder tradableProductBuilder, Function<String, Optional<String>> translator) {
        this.mappings = context.getMappings();
        this.executor = context.getExecutor();
        this.invokedTasks = context.getInvokedTasks();
        this.tradableProductBuilder = tradableProductBuilder;
        this.translator = translator;
        this.partyExternalReferenceToCounterpartyRoleEnumMap = new LinkedHashMap<String, CounterpartyRoleEnum>();
    }

    public static synchronized Optional<PartyMappingHelper> getInstance(MappingContext mappingContext) {
        return Optional.ofNullable((PartyMappingHelper)mappingContext.getMappingParams().get(PARTY_MAPPING_HELPER_KEY));
    }

    public static synchronized PartyMappingHelper getInstanceOrThrow(MappingContext mappingContext) {
        return PartyMappingHelper.getInstance(mappingContext).orElseThrow(() -> new IllegalStateException("PartyMappingHelper not found."));
    }

    public void setCounterpartyRoleEnum(RosettaPath modelPath, Path synonymPath, Consumer<CounterpartyRoleEnum> setter) {
        MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)synonymPath.addElement("href"), partyExternalReference -> {
            String partyReference = this.translatePartyExternalReference((String)partyExternalReference);
            Optional<CounterpartyRoleEnum> counterpartyEnum = this.getOrCreateCounterpartyRoleEnum(partyReference);
            counterpartyEnum.ifPresent(setter);
            return counterpartyEnum.isPresent();
        }, this.mappings, (RosettaPath)modelPath);
    }

    public void setCounterpartyRoleEnum(String partyReference, Consumer<CounterpartyRoleEnum> setter) {
        this.getOrCreateCounterpartyRoleEnum(this.translatePartyExternalReference(partyReference)).ifPresent(setter);
    }

    public String translatePartyExternalReference(String partyExternalReference) {
        return Optional.ofNullable(this.translator).flatMap(t -> (Optional)t.apply(partyExternalReference)).orElse(partyExternalReference);
    }

    void addCounterparties() {
        this.invokedTasks.add((CompletableFuture<?>)this.bothCounterpartiesCollected.thenAcceptAsync(map -> {
            LOGGER.info("Setting TradableProduct.counterparty");
            this.tradableProductBuilder.setCounterparty(map.entrySet().stream().map(extRefCounterpartyEntry -> Counterparty.builder().setRole((CounterpartyRoleEnum)((Object)((Object)((Object)extRefCounterpartyEntry.getValue())))).setPartyReference(ReferenceWithMetaParty.builder().setExternalReference((String)extRefCounterpartyEntry.getKey())).build()).collect(Collectors.toList()));
        }, (Executor)this.executor));
    }

    public CompletableFuture<Map<String, CounterpartyRoleEnum>> getBothCounterpartiesCollectedFuture() {
        return this.bothCounterpartiesCollected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CounterpartyRoleEnum> getOrCreateCounterpartyRoleEnum(String externalReference) {
        Map<String, CounterpartyRoleEnum> map = this.partyExternalReferenceToCounterpartyRoleEnumMap;
        synchronized (map) {
            Optional<CounterpartyRoleEnum> counterpartyEnum = Optional.ofNullable(this.partyExternalReferenceToCounterpartyRoleEnumMap.computeIfAbsent(externalReference, key -> {
                if (this.partyExternalReferenceToCounterpartyRoleEnumMap.isEmpty()) {
                    LOGGER.info("Adding CounterpartyRoleEnum.PARTY_1 for {}", (Object)externalReference);
                    return CounterpartyRoleEnum.PARTY_1;
                }
                if (this.partyExternalReferenceToCounterpartyRoleEnumMap.size() == 1) {
                    LOGGER.info("Adding CounterpartyRoleEnum.PARTY_2 for {}", (Object)externalReference);
                    return CounterpartyRoleEnum.PARTY_2;
                }
                return null;
            }));
            if (!this.bothCounterpartiesCollected.isDone() && this.partyExternalReferenceToCounterpartyRoleEnumMap.size() == 2) {
                LOGGER.debug("Both counterparties collected");
                this.bothCounterpartiesCollected.complete(this.partyExternalReferenceToCounterpartyRoleEnumMap);
            }
            return counterpartyEnum;
        }
    }

    public void setAncillaryRoleEnum(RosettaPath modelPath, Path synonymPath, Consumer<AncillaryRoleEnum> setter, AncillaryRoleEnum role) {
        MappingProcessorUtils.setValueAndUpdateMappings((Path)synonymPath.addElement("href"), partyExternalReference -> {
            String translatedPartyRef = this.translatePartyExternalReference((String)partyExternalReference);
            LOGGER.info("Adding {} for {}", (Object)role, (Object)translatedPartyRef);
            setter.accept(role);
            this.addAncillaryParty(translatedPartyRef, role);
        }, this.mappings, (RosettaPath)modelPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAncillaryParty(String partyExternalReference, AncillaryRoleEnum role) {
        TradableProduct.TradableProductBuilder tradableProductBuilder = this.tradableProductBuilder;
        synchronized (tradableProductBuilder) {
            LOGGER.info("Adding {} as {} to TradableProduct.ancillaryParty", (Object)partyExternalReference, (Object)role);
            List ancillaryParties = CollectionUtils.emptyIfNull(this.tradableProductBuilder.getAncillaryParty());
            Optional<AncillaryParty.AncillaryPartyBuilder> ancillaryPartyReference = ancillaryParties.stream().filter(r -> role == r.getRole()).findFirst();
            if (ancillaryPartyReference.isPresent()) {
                ancillaryPartyReference.get().addPartyReference(ReferenceWithMetaParty.builder().setExternalReference(partyExternalReference).build());
            } else {
                ancillaryParties.add(AncillaryParty.builder().setRole(role).addPartyReference(ReferenceWithMetaParty.builder().setExternalReference(partyExternalReference)));
            }
            this.tradableProductBuilder.setAncillaryParty(ancillaryParties.stream().map(AncillaryParty::build).sorted(Comparator.comparing(AncillaryParty::getRole)).collect(Collectors.toList()));
        }
    }
}

