/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.swap.functions;

import cdm.observable.asset.Price;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.FloatingRateCalculationModel;
import fpml.confirmation.FloatingRateIndexModel;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapInitialRateDefault.class)
public abstract class MapInitialRate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Price evaluate(FloatingRateCalculationModel fpmlFloatingRateCalculationModel, FloatingRateIndexModel fpmlFloatingRateIndexModel) {
        Price initialRate;
        Price.PriceBuilder initialRateBuilder = this.doEvaluate(fpmlFloatingRateCalculationModel, fpmlFloatingRateIndexModel);
        if (initialRateBuilder == null) {
            initialRate = null;
        } else {
            initialRate = initialRateBuilder.build();
            this.objectValidator.validate(Price.class, (RosettaModelObject)initialRate);
        }
        return initialRate;
    }

    protected abstract Price.PriceBuilder doEvaluate(FloatingRateCalculationModel var1, FloatingRateIndexModel var2);

    public static class MapInitialRateDefault
    extends MapInitialRate {
        @Override
        protected Price.PriceBuilder doEvaluate(FloatingRateCalculationModel fpmlFloatingRateCalculationModel, FloatingRateIndexModel fpmlFloatingRateIndexModel) {
            Price.PriceBuilder initialRate = Price.builder();
            return this.assignOutput(initialRate, fpmlFloatingRateCalculationModel, fpmlFloatingRateIndexModel);
        }

        protected Price.PriceBuilder assignOutput(Price.PriceBuilder initialRate, FloatingRateCalculationModel fpmlFloatingRateCalculationModel, FloatingRateIndexModel fpmlFloatingRateIndexModel) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlFloatingRateCalculationModel).map("getInitialRate", floatingRateCalculationModel -> floatingRateCalculationModel.getInitialRate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                PriceTypeEnum ifThenElseResult = null;
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlFloatingRateIndexModel)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = PriceTypeEnum.INTEREST_RATE;
                }
                initialRate = (Price.PriceBuilder)this.toBuilder(Price.builder().setValue((BigDecimal)MapperS.of((Object)fpmlFloatingRateCalculationModel).map("getInitialRate", floatingRateCalculationModel -> floatingRateCalculationModel.getInitialRate()).get()).setUnit(null).setPerUnitOf(null).setPriceType(ifThenElseResult).build());
            } else {
                initialRate = null;
            }
            return Optional.ofNullable(initialRate).map(o -> o.prune()).orElse(null);
        }
    }
}

