/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.fxoption.functions;

import cdm.base.math.UnitType;
import cdm.ingest.fpml.confirmation.common.functions.MapCurrency;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceComposite;
import cdm.observable.asset.PriceTypeEnum;
import cdm.product.template.OptionStrike;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.Currency;
import fpml.confirmation.FxOption;
import fpml.confirmation.StrikeQuoteBasisEnum;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapFxOptionStrikePriceDefault.class)
public abstract class MapFxOptionStrikePrice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapCurrency mapCurrency;

    public OptionStrike evaluate(FxOption fpmlFxOption) {
        OptionStrike strike;
        OptionStrike.OptionStrikeBuilder strikeBuilder = this.doEvaluate(fpmlFxOption);
        if (strikeBuilder == null) {
            strike = null;
        } else {
            strike = strikeBuilder.build();
            this.objectValidator.validate(OptionStrike.class, (RosettaModelObject)strike);
        }
        return strike;
    }

    protected abstract OptionStrike.OptionStrikeBuilder doEvaluate(FxOption var1);

    protected abstract MapperS<? extends UnitType> priceUnits(FxOption var1);

    protected abstract MapperS<? extends UnitType> perUnitOf(FxOption var1);

    public static class MapFxOptionStrikePriceDefault
    extends MapFxOptionStrikePrice {
        @Override
        protected OptionStrike.OptionStrikeBuilder doEvaluate(FxOption fpmlFxOption) {
            OptionStrike.OptionStrikeBuilder strike = OptionStrike.builder();
            return this.assignOutput(strike, fpmlFxOption);
        }

        protected OptionStrike.OptionStrikeBuilder assignOutput(OptionStrike.OptionStrikeBuilder strike, FxOption fpmlFxOption) {
            strike = (OptionStrike.OptionStrikeBuilder)this.toBuilder(OptionStrike.builder().setStrikePrice(Price.builder().setValue((BigDecimal)MapperS.of((Object)fpmlFxOption).map("getStrike", fxOption -> fxOption.getStrike()).map("getRate", fxStrikePrice -> fxStrikePrice.getRate()).get()).setUnit((UnitType)this.priceUnits(fpmlFxOption).get()).setPerUnitOf((UnitType)this.perUnitOf(fpmlFxOption).get()).setPriceType(PriceTypeEnum.EXCHANGE_RATE).setComposite(PriceComposite.builder().setBaseValue((BigDecimal)MapperS.of((Object)fpmlFxOption).map("getSpotRate", fxOption -> fxOption.getSpotRate()).get()).setOperand(null).setArithmeticOperator(null).build()).build()).build());
            return Optional.ofNullable(strike).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends UnitType> priceUnits(FxOption fpmlFxOption) {
            Currency ifThenElseResult = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)fpmlFxOption).map("getStrike", fxOption -> fxOption.getStrike()).map("getStrikeQuoteBasis", fxStrikePrice -> fxStrikePrice.getStrikeQuoteBasis()), (Mapper)MapperS.of((Object)((Object)StrikeQuoteBasisEnum.CALL_CURRENCY_PER_PUT_CURRENCY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (Currency)MapperS.of((Object)fpmlFxOption).map("getCallCurrencyAmount", fxOption -> fxOption.getCallCurrencyAmount()).map("getCurrency", nonNegativeMoney -> nonNegativeMoney.getCurrency()).get() : (Currency)MapperS.of((Object)fpmlFxOption).map("getPutCurrencyAmount", fxOption -> fxOption.getPutCurrencyAmount()).map("getCurrency", nonNegativeMoney -> nonNegativeMoney.getCurrency()).get();
            return MapperS.of((Object)UnitType.builder().setCurrency(this.mapCurrency.evaluate(ifThenElseResult)).build());
        }

        @Override
        protected MapperS<? extends UnitType> perUnitOf(FxOption fpmlFxOption) {
            Currency ifThenElseResult = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)fpmlFxOption).map("getStrike", fxOption -> fxOption.getStrike()).map("getStrikeQuoteBasis", fxStrikePrice -> fxStrikePrice.getStrikeQuoteBasis()), (Mapper)MapperS.of((Object)((Object)StrikeQuoteBasisEnum.CALL_CURRENCY_PER_PUT_CURRENCY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (Currency)MapperS.of((Object)fpmlFxOption).map("getPutCurrencyAmount", fxOption -> fxOption.getPutCurrencyAmount()).map("getCurrency", nonNegativeMoney -> nonNegativeMoney.getCurrency()).get() : (Currency)MapperS.of((Object)fpmlFxOption).map("getCallCurrencyAmount", fxOption -> fxOption.getCallCurrencyAmount()).map("getCurrency", nonNegativeMoney -> nonNegativeMoney.getCurrency()).get();
            return MapperS.of((Object)UnitType.builder().setCurrency(this.mapCurrency.evaluate(ifThenElseResult)).build());
        }
    }
}

