/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.bondoption.functions;

import cdm.base.math.UnitType;
import cdm.ingest.fpml.confirmation.common.functions.MapCurrency;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapOptionStrikePrice;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapOptionStrikeReferenceSwapCurve;
import cdm.product.template.OptionStrike;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.BondOptionStrike;
import fpml.confirmation.Currency;
import fpml.confirmation.ReferenceSwapCurve;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapBondOptionStrikeToOptionStrikeDefault.class)
public abstract class MapBondOptionStrikeToOptionStrike
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapCurrency mapCurrency;
    @Inject
    protected MapOptionStrikePrice mapOptionStrikePrice;
    @Inject
    protected MapOptionStrikeReferenceSwapCurve mapOptionStrikeReferenceSwapCurve;

    public OptionStrike evaluate(BondOptionStrike fpmlBondOptionStrike) {
        OptionStrike optionStrikePrice;
        OptionStrike.OptionStrikeBuilder optionStrikePriceBuilder = this.doEvaluate(fpmlBondOptionStrike);
        if (optionStrikePriceBuilder == null) {
            optionStrikePrice = null;
        } else {
            optionStrikePrice = optionStrikePriceBuilder.build();
            this.objectValidator.validate(OptionStrike.class, (RosettaModelObject)optionStrikePrice);
        }
        return optionStrikePrice;
    }

    protected abstract OptionStrike.OptionStrikeBuilder doEvaluate(BondOptionStrike var1);

    protected abstract MapperS<? extends UnitType> unit(BondOptionStrike var1);

    protected abstract MapperS<? extends UnitType> perUnitOf(BondOptionStrike var1);

    public static class MapBondOptionStrikeToOptionStrikeDefault
    extends MapBondOptionStrikeToOptionStrike {
        @Override
        protected OptionStrike.OptionStrikeBuilder doEvaluate(BondOptionStrike fpmlBondOptionStrike) {
            OptionStrike.OptionStrikeBuilder optionStrikePrice = OptionStrike.builder();
            return this.assignOutput(optionStrikePrice, fpmlBondOptionStrike);
        }

        protected OptionStrike.OptionStrikeBuilder assignOutput(OptionStrike.OptionStrikeBuilder optionStrikePrice, BondOptionStrike fpmlBondOptionStrike) {
            optionStrikePrice = ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlBondOptionStrike).map("getPrice", bondOptionStrike -> bondOptionStrike.getPrice())).getOrDefault(Boolean.valueOf(false)) != false ? (OptionStrike.OptionStrikeBuilder)this.toBuilder(this.mapOptionStrikePrice.evaluate((BigDecimal)MapperS.of((Object)fpmlBondOptionStrike).map("getPrice", bondOptionStrike -> bondOptionStrike.getPrice()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).get(), (BigDecimal)MapperS.of((Object)fpmlBondOptionStrike).map("getPrice", bondOptionStrike -> bondOptionStrike.getPrice()).map("getStrikePercentage", optionStrike -> optionStrike.getStrikePercentage()).get(), (UnitType)this.unit(fpmlBondOptionStrike).get(), (UnitType)this.perUnitOf(fpmlBondOptionStrike).get())) : (OptionStrike.OptionStrikeBuilder)this.toBuilder(this.mapOptionStrikeReferenceSwapCurve.evaluate((ReferenceSwapCurve)MapperS.of((Object)fpmlBondOptionStrike).map("getReferenceSwapCurve", bondOptionStrike -> bondOptionStrike.getReferenceSwapCurve()).get()));
            return Optional.ofNullable(optionStrikePrice).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends UnitType> unit(BondOptionStrike fpmlBondOptionStrike) {
            return MapperS.of((Object)UnitType.builder().setCurrency(this.mapCurrency.evaluate((Currency)MapperS.of((Object)fpmlBondOptionStrike).map("getPrice", bondOptionStrike -> bondOptionStrike.getPrice()).map("getCurrency", optionStrike -> optionStrike.getCurrency()).get())).build());
        }

        @Override
        protected MapperS<? extends UnitType> perUnitOf(BondOptionStrike fpmlBondOptionStrike) {
            return MapperS.of((Object)UnitType.builder().setCurrency(this.mapCurrency.evaluate((Currency)MapperS.of((Object)fpmlBondOptionStrike).map("getPrice", bondOptionStrike -> bondOptionStrike.getPrice()).map("getCurrency", optionStrike -> optionStrike.getCurrency()).get())).build());
        }
    }
}

