/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.DatedValue;
import cdm.base.math.UnitType;
import cdm.ingest.fpml.confirmation.common.functions.MapCurrency;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapScheduleToDatedValueList;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.Currency;
import fpml.confirmation.Step;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapInterestRatePriceScheduleDefault.class)
public abstract class MapInterestRatePriceSchedule
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapCurrency mapCurrency;
    @Inject
    protected MapScheduleToDatedValueList mapScheduleToDatedValueList;

    public PriceSchedule evaluate(BigDecimal fpmlRate, List<? extends Step> fpmlStepList, Currency fpmlCurrency, ArithmeticOperationEnum arithmeticOperator) {
        PriceSchedule priceSchedule;
        PriceSchedule.PriceScheduleBuilder priceScheduleBuilder = this.doEvaluate(fpmlRate, fpmlStepList, fpmlCurrency, arithmeticOperator);
        if (priceScheduleBuilder == null) {
            priceSchedule = null;
        } else {
            priceSchedule = priceScheduleBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)priceSchedule);
        }
        return priceSchedule;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(BigDecimal var1, List<? extends Step> var2, Currency var3, ArithmeticOperationEnum var4);

    protected abstract MapperS<? extends UnitType> priceUnits(BigDecimal var1, List<? extends Step> var2, Currency var3, ArithmeticOperationEnum var4);

    public static class MapInterestRatePriceScheduleDefault
    extends MapInterestRatePriceSchedule {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(BigDecimal fpmlRate, List<? extends Step> fpmlStepList, Currency fpmlCurrency, ArithmeticOperationEnum arithmeticOperator) {
            if (fpmlStepList == null) {
                fpmlStepList = Collections.emptyList();
            }
            PriceSchedule.PriceScheduleBuilder priceSchedule = PriceSchedule.builder();
            return this.assignOutput(priceSchedule, fpmlRate, fpmlStepList, fpmlCurrency, arithmeticOperator);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder priceSchedule, BigDecimal fpmlRate, List<? extends Step> fpmlStepList, Currency fpmlCurrency, ArithmeticOperationEnum arithmeticOperator) {
            priceSchedule = ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlRate)).getOrDefault(Boolean.valueOf(false)) != false ? (PriceSchedule.PriceScheduleBuilder)this.toBuilder(PriceSchedule.builder().setValue(fpmlRate).setDatedValue(new ArrayList<DatedValue>(this.mapScheduleToDatedValueList.evaluate(fpmlStepList))).setUnit((UnitType)this.priceUnits(fpmlRate, fpmlStepList, fpmlCurrency, arithmeticOperator).get()).setPerUnitOf((UnitType)this.priceUnits(fpmlRate, fpmlStepList, fpmlCurrency, arithmeticOperator).get()).setArithmeticOperator(arithmeticOperator).setPriceType(PriceTypeEnum.INTEREST_RATE).build()) : null;
            return Optional.ofNullable(priceSchedule).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends UnitType> priceUnits(BigDecimal fpmlRate, List<? extends Step> fpmlStepList, Currency fpmlCurrency, ArithmeticOperationEnum arithmeticOperator) {
            return MapperS.of((Object)UnitType.builder().setCurrency(this.mapCurrency.evaluate(fpmlCurrency)).build());
        }
    }
}

