/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.staticdata.asset.common.Asset;
import cdm.base.staticdata.asset.common.Instrument;
import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapIdentifiedAssetToSecurity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.confirmation.ExchangeId;
import fpml.confirmation.IdentifiedAsset;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapIdentifiedAssetToAssetSecurityDefault.class)
public abstract class MapIdentifiedAssetToAssetSecurity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapIdentifiedAssetToSecurity mapIdentifiedAssetToSecurity;

    public Asset evaluate(IdentifiedAsset fpmlIdentifiedAsset, ExchangeId fpmlExchangeId, List<? extends ExchangeId> fpmlRelatedExchangeId, InstrumentTypeEnum instrumentType) {
        Asset asset;
        Asset.AssetBuilder assetBuilder = this.doEvaluate(fpmlIdentifiedAsset, fpmlExchangeId, fpmlRelatedExchangeId, instrumentType);
        if (assetBuilder == null) {
            asset = null;
        } else {
            asset = assetBuilder.build();
            this.objectValidator.validate(Asset.class, (RosettaModelObject)asset);
        }
        return asset;
    }

    protected abstract Asset.AssetBuilder doEvaluate(IdentifiedAsset var1, ExchangeId var2, List<? extends ExchangeId> var3, InstrumentTypeEnum var4);

    public static class MapIdentifiedAssetToAssetSecurityDefault
    extends MapIdentifiedAssetToAssetSecurity {
        @Override
        protected Asset.AssetBuilder doEvaluate(IdentifiedAsset fpmlIdentifiedAsset, ExchangeId fpmlExchangeId, List<? extends ExchangeId> fpmlRelatedExchangeId, InstrumentTypeEnum instrumentType) {
            if (fpmlRelatedExchangeId == null) {
                fpmlRelatedExchangeId = Collections.emptyList();
            }
            Asset.AssetBuilder asset = Asset.builder();
            return this.assignOutput(asset, fpmlIdentifiedAsset, fpmlExchangeId, fpmlRelatedExchangeId, instrumentType);
        }

        protected Asset.AssetBuilder assignOutput(Asset.AssetBuilder asset, IdentifiedAsset fpmlIdentifiedAsset, ExchangeId fpmlExchangeId, List<? extends ExchangeId> fpmlRelatedExchangeId, InstrumentTypeEnum instrumentType) {
            asset = (Asset.AssetBuilder)this.toBuilder(Asset.builder().setInstrument(Instrument.builder().setSecurity(this.mapIdentifiedAssetToSecurity.evaluate(fpmlIdentifiedAsset, fpmlExchangeId, fpmlRelatedExchangeId, instrumentType)).build()).build());
            return Optional.ofNullable(asset).map(o -> o.prune()).orElse(null);
        }
    }
}

