/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.UnitType;
import cdm.ingest.fpml.confirmation.common.functions.MapCurrency;
import cdm.observable.asset.PriceComposite;
import cdm.observable.asset.PriceOperandEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.Currency;
import fpml.confirmation.ExchangeRate;
import fpml.confirmation.QuoteBasisEnum;
import fpml.confirmation.QuotedCurrencyPair;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapExchangeRateToPriceDefault.class)
public abstract class MapExchangeRateToPrice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapCurrency mapCurrency;

    public PriceSchedule evaluate(ExchangeRate fpmlExchangeRate) {
        PriceSchedule price;
        PriceSchedule.PriceScheduleBuilder priceBuilder = this.doEvaluate(fpmlExchangeRate);
        if (priceBuilder == null) {
            price = null;
        } else {
            price = priceBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)price);
        }
        return price;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(ExchangeRate var1);

    protected abstract MapperS<BigDecimal> rate(ExchangeRate var1);

    protected abstract MapperS<BigDecimal> spotRate(ExchangeRate var1);

    protected abstract MapperS<BigDecimal> forwardPoints(ExchangeRate var1);

    protected abstract MapperS<? extends QuotedCurrencyPair> quotedCurrencyPair(ExchangeRate var1);

    protected abstract MapperS<? extends Currency> fpmlCurrency(ExchangeRate var1);

    protected abstract MapperS<? extends Currency> fpmlPerCurrency(ExchangeRate var1);

    public static class MapExchangeRateToPriceDefault
    extends MapExchangeRateToPrice {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(ExchangeRate fpmlExchangeRate) {
            PriceSchedule.PriceScheduleBuilder price = PriceSchedule.builder();
            return this.assignOutput(price, fpmlExchangeRate);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder price, ExchangeRate fpmlExchangeRate) {
            if (ExpressionOperators.exists(this.rate(fpmlExchangeRate)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                PriceComposite ifThenElseResult = null;
                if (ExpressionOperators.exists(this.spotRate(fpmlExchangeRate)).and(ExpressionOperators.exists(this.forwardPoints(fpmlExchangeRate))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = PriceComposite.builder().setBaseValue((BigDecimal)this.spotRate(fpmlExchangeRate).get()).setOperand((BigDecimal)this.forwardPoints(fpmlExchangeRate).get()).setArithmeticOperator(ArithmeticOperationEnum.ADD).setOperandType(PriceOperandEnum.FORWARD_POINT).build();
                }
                price = (PriceSchedule.PriceScheduleBuilder)this.toBuilder(PriceSchedule.builder().setValue((BigDecimal)this.rate(fpmlExchangeRate).get()).setUnit(UnitType.builder().setCurrency(this.mapCurrency.evaluate((Currency)this.fpmlCurrency(fpmlExchangeRate).get())).build()).setPerUnitOf(UnitType.builder().setCurrency(this.mapCurrency.evaluate((Currency)this.fpmlPerCurrency(fpmlExchangeRate).get())).build()).setPriceType(PriceTypeEnum.EXCHANGE_RATE).setComposite(ifThenElseResult).build());
            } else {
                price = null;
            }
            return Optional.ofNullable(price).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> rate(ExchangeRate fpmlExchangeRate) {
            return MapperS.of((Object)fpmlExchangeRate).map("getRate", exchangeRate -> exchangeRate.getRate());
        }

        @Override
        protected MapperS<BigDecimal> spotRate(ExchangeRate fpmlExchangeRate) {
            return MapperS.of((Object)fpmlExchangeRate).map("getExchangeRateSequence", exchangeRate -> exchangeRate.getExchangeRateSequence()).map("getSpotRate", exchangeRateSequence -> exchangeRateSequence.getSpotRate());
        }

        @Override
        protected MapperS<BigDecimal> forwardPoints(ExchangeRate fpmlExchangeRate) {
            return MapperS.of((Object)fpmlExchangeRate).map("getExchangeRateSequence", exchangeRate -> exchangeRate.getExchangeRateSequence()).map("getExchangeRateSequenceSequence", exchangeRateSequence -> exchangeRateSequence.getExchangeRateSequenceSequence()).map("getForwardPoints", exchangeRateSequenceSequence -> exchangeRateSequenceSequence.getForwardPoints());
        }

        @Override
        protected MapperS<? extends QuotedCurrencyPair> quotedCurrencyPair(ExchangeRate fpmlExchangeRate) {
            return MapperS.of((Object)fpmlExchangeRate).map("getQuotedCurrencyPair", exchangeRate -> exchangeRate.getQuotedCurrencyPair());
        }

        @Override
        protected MapperS<? extends Currency> fpmlCurrency(ExchangeRate fpmlExchangeRate) {
            if (ExpressionOperators.areEqual((Mapper)this.quotedCurrencyPair(fpmlExchangeRate).map("getQuoteBasis", _quotedCurrencyPair -> _quotedCurrencyPair.getQuoteBasis()), (Mapper)MapperS.of((Object)((Object)QuoteBasisEnum.CURRENCY_1_PER_CURRENCY_2)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.quotedCurrencyPair(fpmlExchangeRate).map("getCurrency1", _quotedCurrencyPair -> _quotedCurrencyPair.getCurrency1());
            }
            return this.quotedCurrencyPair(fpmlExchangeRate).map("getCurrency2", _quotedCurrencyPair -> _quotedCurrencyPair.getCurrency2());
        }

        @Override
        protected MapperS<? extends Currency> fpmlPerCurrency(ExchangeRate fpmlExchangeRate) {
            if (ExpressionOperators.areEqual((Mapper)this.quotedCurrencyPair(fpmlExchangeRate).map("getQuoteBasis", _quotedCurrencyPair -> _quotedCurrencyPair.getQuoteBasis()), (Mapper)MapperS.of((Object)((Object)QuoteBasisEnum.CURRENCY_1_PER_CURRENCY_2)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.quotedCurrencyPair(fpmlExchangeRate).map("getCurrency2", _quotedCurrencyPair -> _quotedCurrencyPair.getCurrency2());
            }
            return this.quotedCurrencyPair(fpmlExchangeRate).map("getCurrency1", _quotedCurrencyPair -> _quotedCurrencyPair.getCurrency1());
        }
    }
}

