/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.asset.common.TaxonomyClassification;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.base.staticdata.asset.common.TaxonomyValue;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapCommodityClassificationOrdinal;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.CommodityClassification;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapCommodityClassificationToTaxonomyDefault.class)
public abstract class MapCommodityClassificationToTaxonomy
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapCommodityClassificationOrdinal mapCommodityClassificationOrdinal;

    public Taxonomy evaluate(CommodityClassification fpmlCommodityClassification) {
        Taxonomy taxonomy;
        Taxonomy.TaxonomyBuilder taxonomyBuilder = this.doEvaluate(fpmlCommodityClassification);
        if (taxonomyBuilder == null) {
            taxonomy = null;
        } else {
            taxonomy = taxonomyBuilder.build();
            this.objectValidator.validate(Taxonomy.class, (RosettaModelObject)taxonomy);
        }
        return taxonomy;
    }

    protected abstract Taxonomy.TaxonomyBuilder doEvaluate(CommodityClassification var1);

    protected abstract MapperS<String> scheme(CommodityClassification var1);

    protected abstract MapperS<TaxonomySourceEnum> source(CommodityClassification var1);

    public static class MapCommodityClassificationToTaxonomyDefault
    extends MapCommodityClassificationToTaxonomy {
        @Override
        protected Taxonomy.TaxonomyBuilder doEvaluate(CommodityClassification fpmlCommodityClassification) {
            Taxonomy.TaxonomyBuilder taxonomy = Taxonomy.builder();
            return this.assignOutput(taxonomy, fpmlCommodityClassification);
        }

        protected Taxonomy.TaxonomyBuilder assignOutput(Taxonomy.TaxonomyBuilder taxonomy, CommodityClassification fpmlCommodityClassification) {
            taxonomy = (Taxonomy.TaxonomyBuilder)this.toBuilder(Taxonomy.builder().setSource((TaxonomySourceEnum)((Object)this.source(fpmlCommodityClassification).get())).setValue(TaxonomyValue.builder().setNameValue(null).setClassification(MapperS.of((Object)fpmlCommodityClassification).mapC("getCode", commodityClassification -> commodityClassification.getCode()).mapItem(item -> MapperS.of((Object)TaxonomyClassification.builder().setValue((String)item.map("getValue", commodityClassificationLayer -> commodityClassificationLayer.getValue()).get()).setOrdinal(this.mapCommodityClassificationOrdinal.evaluate((String)item.map("getCommodityClassificationScheme", commodityClassificationLayer -> commodityClassificationLayer.getCommodityClassificationScheme()).get())).build())).getMulti()).build()).build());
            return Optional.ofNullable(taxonomy).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<String> scheme(CommodityClassification fpmlCommodityClassification) {
            return MapperS.of((Object)fpmlCommodityClassification).mapC("getCode", commodityClassification -> commodityClassification.getCode()).first().map("getCommodityClassificationScheme", commodityClassificationLayer -> commodityClassificationLayer.getCommodityClassificationScheme());
        }

        @Override
        protected MapperS<TaxonomySourceEnum> source(CommodityClassification fpmlCommodityClassification) {
            if (ExpressionOperators.areEqual(this.scheme(fpmlCommodityClassification), (Mapper)MapperS.of((Object)"http://www.fpml.org/coding-scheme/isda-layer-1-commodity-classification"), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((Object)TaxonomySourceEnum.ISDA));
            }
            if (ExpressionOperators.areEqual(this.scheme(fpmlCommodityClassification), (Mapper)MapperS.of((Object)"http://www.fpml.org/coding-scheme/esma-emir-refit-layer-1-commodity-classification"), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((Object)TaxonomySourceEnum.EMIR));
            }
            return MapperS.ofNull();
        }
    }
}

