/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.ingest.fpml.confirmation.pricequantity.functions.MapBasketConstituentWithLocation;
import cdm.observable.asset.Basket;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.BasketConstituent;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapBasketDefault.class)
public abstract class MapBasket
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapBasketConstituentWithLocation mapBasketConstituentWithLocation;

    public Basket evaluate(fpml.confirmation.Basket fpmlBasket) {
        Basket basket;
        Basket.BasketBuilder basketBuilder = this.doEvaluate(fpmlBasket);
        if (basketBuilder == null) {
            basket = null;
        } else {
            basket = basketBuilder.build();
            this.objectValidator.validate(Basket.class, (RosettaModelObject)basket);
        }
        return basket;
    }

    protected abstract Basket.BasketBuilder doEvaluate(fpml.confirmation.Basket var1);

    public static class MapBasketDefault
    extends MapBasket {
        @Override
        protected Basket.BasketBuilder doEvaluate(fpml.confirmation.Basket fpmlBasket) {
            Basket.BasketBuilder basket = Basket.builder();
            return this.assignOutput(basket, fpmlBasket);
        }

        protected Basket.BasketBuilder assignOutput(Basket.BasketBuilder basket, fpml.confirmation.Basket fpmlBasket) {
            basket = (Basket.BasketBuilder)this.toBuilder(Basket.builder().setIdentifier(Collections.emptyList()).setBasketConstituent(MapperS.of((Object)fpmlBasket).mapC("getBasketConstituent", _basket -> _basket.getBasketConstituent()).mapItem(item -> MapperS.of((Object)this.mapBasketConstituentWithLocation.evaluate((BasketConstituent)item.get()))).getMulti()).build());
            return Optional.ofNullable(basket).map(o -> o.prune()).orElse(null);
        }
    }
}

