/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.payment.functions;

import cdm.base.datetime.AdjustableDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import fpml.confirmation.PrincipalExchange;
import java.time.LocalDate;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapPrincipalPaymentDateDefault.class)
public abstract class MapPrincipalPaymentDate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public AdjustableDate evaluate(PrincipalExchange fpmlPrincipalExchange) {
        AdjustableDate principalPaymentDate;
        AdjustableDate.AdjustableDateBuilder principalPaymentDateBuilder = this.doEvaluate(fpmlPrincipalExchange);
        if (principalPaymentDateBuilder == null) {
            principalPaymentDate = null;
        } else {
            principalPaymentDate = principalPaymentDateBuilder.build();
            this.objectValidator.validate(AdjustableDate.class, (RosettaModelObject)principalPaymentDate);
        }
        return principalPaymentDate;
    }

    protected abstract AdjustableDate.AdjustableDateBuilder doEvaluate(PrincipalExchange var1);

    public static class MapPrincipalPaymentDateDefault
    extends MapPrincipalPaymentDate {
        @Override
        protected AdjustableDate.AdjustableDateBuilder doEvaluate(PrincipalExchange fpmlPrincipalExchange) {
            AdjustableDate.AdjustableDateBuilder principalPaymentDate = AdjustableDate.builder();
            return this.assignOutput(principalPaymentDate, fpmlPrincipalExchange);
        }

        protected AdjustableDate.AdjustableDateBuilder assignOutput(AdjustableDate.AdjustableDateBuilder principalPaymentDate, PrincipalExchange fpmlPrincipalExchange) {
            principalPaymentDate = (AdjustableDate.AdjustableDateBuilder)this.toBuilder(AdjustableDate.builder().setAdjustedDateValue((Date)MapperS.of((Object)fpmlPrincipalExchange).map("getAdjustedPrincipalExchangeDate", principalExchange -> principalExchange.getAdjustedPrincipalExchangeDate()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())).get()).setUnadjustedDate((Date)MapperS.of((Object)fpmlPrincipalExchange).map("getUnadjustedPrincipalExchangeDate", principalExchange -> principalExchange.getUnadjustedPrincipalExchangeDate()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())).get()).build());
            return Optional.ofNullable(principalPaymentDate).map(o -> o.prune()).orElse(null);
        }
    }
}

