/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.payment.functions;

import cdm.base.math.UnitType;
import cdm.base.staticdata.party.Counterparty;
import cdm.ingest.fpml.confirmation.common.functions.MapCurrency;
import cdm.ingest.fpml.confirmation.payment.functions.MapPrincipalPayerReceiver;
import cdm.ingest.fpml.confirmation.payment.functions.MapPrincipalPaymentDate;
import cdm.observable.asset.Money;
import cdm.product.common.settlement.PrincipalPayment;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.Currency;
import fpml.confirmation.PayerReceiverModel;
import fpml.confirmation.PrincipalExchange;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapPrincipalPaymentDefault.class)
public abstract class MapPrincipalPayment
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapCurrency mapCurrency;
    @Inject
    protected MapPrincipalPayerReceiver mapPrincipalPayerReceiver;
    @Inject
    protected MapPrincipalPaymentDate mapPrincipalPaymentDate;

    public PrincipalPayment evaluate(PrincipalExchange fpmlPrincipalExchange, Currency fpmlCurrency, PayerReceiverModel fpmlPayerReceiverModel, List<? extends Counterparty> cdmCounterpartyList) {
        PrincipalPayment principalPayment;
        PrincipalPayment.PrincipalPaymentBuilder principalPaymentBuilder = this.doEvaluate(fpmlPrincipalExchange, fpmlCurrency, fpmlPayerReceiverModel, cdmCounterpartyList);
        if (principalPaymentBuilder == null) {
            principalPayment = null;
        } else {
            principalPayment = principalPaymentBuilder.build();
            this.objectValidator.validate(PrincipalPayment.class, (RosettaModelObject)principalPayment);
        }
        return principalPayment;
    }

    protected abstract PrincipalPayment.PrincipalPaymentBuilder doEvaluate(PrincipalExchange var1, Currency var2, PayerReceiverModel var3, List<? extends Counterparty> var4);

    protected abstract MapperS<BigDecimal> amount(PrincipalExchange var1, Currency var2, PayerReceiverModel var3, List<? extends Counterparty> var4);

    public static class MapPrincipalPaymentDefault
    extends MapPrincipalPayment {
        @Override
        protected PrincipalPayment.PrincipalPaymentBuilder doEvaluate(PrincipalExchange fpmlPrincipalExchange, Currency fpmlCurrency, PayerReceiverModel fpmlPayerReceiverModel, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            PrincipalPayment.PrincipalPaymentBuilder principalPayment = PrincipalPayment.builder();
            return this.assignOutput(principalPayment, fpmlPrincipalExchange, fpmlCurrency, fpmlPayerReceiverModel, cdmCounterpartyList);
        }

        protected PrincipalPayment.PrincipalPaymentBuilder assignOutput(PrincipalPayment.PrincipalPaymentBuilder principalPayment, PrincipalExchange fpmlPrincipalExchange, Currency fpmlCurrency, PayerReceiverModel fpmlPayerReceiverModel, List<? extends Counterparty> cdmCounterpartyList) {
            BigDecimal ifThenElseResult = ExpressionOperators.lessThan(this.amount(fpmlPrincipalExchange, fpmlCurrency, fpmlPayerReceiverModel, cdmCounterpartyList), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)MapperMaths.multiply(this.amount(fpmlPrincipalExchange, fpmlCurrency, fpmlPayerReceiverModel, cdmCounterpartyList), (Mapper)MapperS.of((Object)BigDecimal.valueOf(-1L))).get() : (BigDecimal)this.amount(fpmlPrincipalExchange, fpmlCurrency, fpmlPayerReceiverModel, cdmCounterpartyList).get();
            principalPayment = (PrincipalPayment.PrincipalPaymentBuilder)this.toBuilder(PrincipalPayment.builder().setPrincipalPaymentDate(this.mapPrincipalPaymentDate.evaluate(fpmlPrincipalExchange)).setPayerReceiver(this.mapPrincipalPayerReceiver.evaluate(fpmlPrincipalExchange, fpmlPayerReceiverModel, cdmCounterpartyList)).setPrincipalAmount(Money.builder().setValue(ifThenElseResult).setUnit(UnitType.builder().setCurrency(this.mapCurrency.evaluate(fpmlCurrency)).build()).build()).build());
            return Optional.ofNullable(principalPayment).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> amount(PrincipalExchange fpmlPrincipalExchange, Currency fpmlCurrency, PayerReceiverModel fpmlPayerReceiverModel, List<? extends Counterparty> cdmCounterpartyList) {
            return MapperS.of((Object)fpmlPrincipalExchange).map("getPrincipalExchangeAmount", principalExchange -> principalExchange.getPrincipalExchangeAmount());
        }
    }
}

