/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.payment.functions;

import cdm.event.common.TransferState;
import cdm.ingest.fpml.confirmation.payment.functions.MapNonNegativePaymentToTransferState;
import cdm.observable.asset.FeeTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.CommodityPremium;
import fpml.confirmation.NonNegativePayment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=MapCommodityPremiumListToTransferStateListDefault.class)
public abstract class MapCommodityPremiumListToTransferStateList
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapNonNegativePaymentToTransferState mapNonNegativePaymentToTransferState;

    public List<? extends TransferState> evaluate(List<? extends CommodityPremium> fpmlCommodityPremiumList, FeeTypeEnum cdmFeeType) {
        List transferStateList;
        List<TransferState.TransferStateBuilder> transferStateListBuilder = this.doEvaluate(fpmlCommodityPremiumList, cdmFeeType);
        if (transferStateListBuilder == null) {
            transferStateList = null;
        } else {
            transferStateList = transferStateListBuilder.stream().map(TransferState::build).collect(Collectors.toList());
            this.objectValidator.validate(TransferState.class, transferStateList);
        }
        return transferStateList;
    }

    protected abstract List<TransferState.TransferStateBuilder> doEvaluate(List<? extends CommodityPremium> var1, FeeTypeEnum var2);

    public static class MapCommodityPremiumListToTransferStateListDefault
    extends MapCommodityPremiumListToTransferStateList {
        @Override
        protected List<TransferState.TransferStateBuilder> doEvaluate(List<? extends CommodityPremium> fpmlCommodityPremiumList, FeeTypeEnum cdmFeeType) {
            if (fpmlCommodityPremiumList == null) {
                fpmlCommodityPremiumList = Collections.emptyList();
            }
            ArrayList<TransferState.TransferStateBuilder> transferStateList = new ArrayList<TransferState.TransferStateBuilder>();
            return this.assignOutput(transferStateList, fpmlCommodityPremiumList, cdmFeeType);
        }

        protected List<TransferState.TransferStateBuilder> assignOutput(List<TransferState.TransferStateBuilder> transferStateList, List<? extends CommodityPremium> fpmlCommodityPremiumList, FeeTypeEnum cdmFeeType) {
            transferStateList.addAll(this.toBuilder(MapperC.of(fpmlCommodityPremiumList).mapItem(item -> MapperS.of((Object)this.mapNonNegativePaymentToTransferState.evaluate((NonNegativePayment)item.get(), cdmFeeType))).getMulti()));
            return Optional.ofNullable(transferStateList).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

