/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.legal.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.ingest.fpml.confirmation.legal.functions.MapContractualParty;
import cdm.legaldocumentation.common.AgreementName;
import cdm.legaldocumentation.common.LegalAgreement;
import cdm.legaldocumentation.common.LegalAgreementIdentification;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.records.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapLegalAgreementDefault.class)
public abstract class MapLegalAgreement
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapContractualParty mapContractualParty;

    public LegalAgreement evaluate(Date fpmlAgreementDate, List<? extends Counterparty> cdmCounterpartyList, AgreementName cdmAgreementName, Integer cdmVintage) {
        LegalAgreement legalAgreement;
        LegalAgreement.LegalAgreementBuilder legalAgreementBuilder = this.doEvaluate(fpmlAgreementDate, cdmCounterpartyList, cdmAgreementName, cdmVintage);
        if (legalAgreementBuilder == null) {
            legalAgreement = null;
        } else {
            legalAgreement = legalAgreementBuilder.build();
            this.objectValidator.validate(LegalAgreement.class, (RosettaModelObject)legalAgreement);
        }
        return legalAgreement;
    }

    protected abstract LegalAgreement.LegalAgreementBuilder doEvaluate(Date var1, List<? extends Counterparty> var2, AgreementName var3, Integer var4);

    public static class MapLegalAgreementDefault
    extends MapLegalAgreement {
        @Override
        protected LegalAgreement.LegalAgreementBuilder doEvaluate(Date fpmlAgreementDate, List<? extends Counterparty> cdmCounterpartyList, AgreementName cdmAgreementName, Integer cdmVintage) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            LegalAgreement.LegalAgreementBuilder legalAgreement = LegalAgreement.builder();
            return this.assignOutput(legalAgreement, fpmlAgreementDate, cdmCounterpartyList, cdmAgreementName, cdmVintage);
        }

        protected LegalAgreement.LegalAgreementBuilder assignOutput(LegalAgreement.LegalAgreementBuilder legalAgreement, Date fpmlAgreementDate, List<? extends Counterparty> cdmCounterpartyList, AgreementName cdmAgreementName, Integer cdmVintage) {
            legalAgreement = (LegalAgreement.LegalAgreementBuilder)this.toBuilder(LegalAgreement.builder().setAgreementDate(fpmlAgreementDate).setContractualParty(new ArrayList<ReferenceWithMetaParty>(this.mapContractualParty.evaluate(cdmCounterpartyList))).setLegalAgreementIdentification(LegalAgreementIdentification.builder().setGoverningLaw(null).setAgreementName(cdmAgreementName).setPublisher(null).setVintage(cdmVintage).build()).build());
            return Optional.ofNullable(legalAgreement).map(o -> o.prune()).orElse(null);
        }
    }
}

