/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.workflow.processor;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.BusinessDayConventionEnum;
import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.datetime.RollConventionEnum;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.UnitType;
import cdm.base.staticdata.asset.common.AssetIdTypeEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyIdentifier;
import cdm.event.common.ExecutionTypeEnum;
import cdm.event.common.TradeState;
import cdm.event.workflow.EventTimestampQualificationEnum;
import cdm.event.workflow.WorkflowStep;
import cdm.observable.asset.PriceQuantity;
import cdm.observable.asset.PriceTypeEnum;
import cdm.product.asset.InterestRatePayout;
import cdm.product.collateral.CollateralProvisions;
import cdm.product.collateral.CollateralTypeEnum;
import cdm.product.common.settlement.DeliveryMethodEnum;
import cdm.product.template.AssetPayout;
import cdm.product.template.EconomicTerms;
import cdm.product.template.TradableProduct;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.translation.flat.Capture;
import com.regnosys.rosetta.common.translation.flat.FlatFileMappingProcessor;
import com.regnosys.rosetta.common.translation.flat.IndexCapturePath;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class FISMapperMappingProcessor
extends FlatFileMappingProcessor<WorkflowStep.WorkflowStepBuilder> {
    private static final String BORROWER = "Borrower";
    private static final String AGENT_LENDER = "AGENT_LENDER";

    protected void doHardCodings(WorkflowStep.WorkflowStepBuilder workflow) {
    }

    private void staticMappings(FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder> tradeState) {
        ((TradeState.TradeStateBuilder)tradeState.getValue()).getOrCreateTrade().getOrCreateExecutionDetails().setExecutionType(ExecutionTypeEnum.OFF_FACILITY);
        ((TradableProduct.TradableProductBuilder)this.getTradableProduct(tradeState).getValue()).getOrCreateCounterparty(0).setRole(CounterpartyRoleEnum.PARTY_1);
        ((TradableProduct.TradableProductBuilder)this.getTradableProduct(tradeState).getValue()).getOrCreateCounterparty(1).setRole(CounterpartyRoleEnum.PARTY_2);
        ((TradableProduct.TradableProductBuilder)this.getTradableProduct(tradeState).getValue()).getOrCreateCounterparty(1).getOrCreatePartyReference().setExternalReference(BORROWER);
        ((InterestRatePayout.InterestRatePayoutBuilder)this.getIRP(tradeState).getValue()).getOrCreateCalculationPeriodDates().getOrCreateCalculationPeriodFrequency().setPeriod(PeriodExtendedEnum.T);
        ((InterestRatePayout.InterestRatePayoutBuilder)this.getIRP(tradeState).getValue()).getOrCreateCalculationPeriodDates().getOrCreateCalculationPeriodFrequency().setPeriodMultiplier(1);
        ((InterestRatePayout.InterestRatePayoutBuilder)this.getIRP(tradeState).getValue()).getOrCreateCalculationPeriodDates().getOrCreateCalculationPeriodFrequency().setRollConvention(RollConventionEnum.NONE);
        ((InterestRatePayout.InterestRatePayoutBuilder)this.getIRP(tradeState).getValue()).getOrCreatePaymentDates().getOrCreatePaymentDatesAdjustments().setBusinessDayConvention(BusinessDayConventionEnum.MODFOLLOWING);
        ((InterestRatePayout.InterestRatePayoutBuilder)this.getIRP(tradeState).getValue()).getOrCreatePaymentDates().getOrCreatePaymentDatesAdjustments().getOrCreateBusinessCenters().getOrCreateBusinessCenter(0).setValue(BusinessCenterEnum.EUTA);
        ((InterestRatePayout.InterestRatePayoutBuilder)this.getIRP(tradeState).getValue()).getOrCreatePaymentDates().getOrCreatePaymentFrequency().setPeriod(PeriodExtendedEnum.T);
        ((InterestRatePayout.InterestRatePayoutBuilder)this.getIRP(tradeState).getValue()).getOrCreatePaymentDates().getOrCreatePaymentFrequency().setPeriodMultiplier(1);
        ((AssetPayout.AssetPayoutBuilder)this.getSecPO(tradeState).getValue()).getOrCreateUnderlier().getOrCreateInstrument().getOrCreateSecurity().setInstrumentType(InstrumentTypeEnum.EQUITY);
        ((AssetPayout.AssetPayoutBuilder)this.getSecPO(tradeState).getValue()).getOrCreatePayerReceiver().setPayer(CounterpartyRoleEnum.PARTY_1);
        ((AssetPayout.AssetPayoutBuilder)this.getSecPO(tradeState).getValue()).getOrCreatePayerReceiver().setReceiver(CounterpartyRoleEnum.PARTY_2);
    }

    public FISMapperMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
        Multimap<String, FlatFileMappingProcessor.MappingConsumer<TradeState.TradeStateBuilder>> commonMappings = this.buildCommonMappings();
        this.buildTradeStateMappings(commonMappings);
        this.buildAllocationMappings(commonMappings);
        this.buildTradeStateMapping("Activity_Input_Date", (FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder>)this.capture("ActivityDate"));
        this.buildTradeStateMapping("Activity_Time_In_Milliseconds", (FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder>)this.capture("ActivityTime"));
        this.addPostCaptureProcessors((captures, workflow) -> {
            LocalTime time = LocalTime.parse(((Capture)this.any(captures.get((Object)"ActivityTime")).get()).getValue(), this.localTimeParser);
            LocalDate data = LocalDate.parse(((Capture)this.any(captures.get((Object)"ActivityDate")).get()).getValue(), this.dateParser);
            ZonedDateTime ts = ZonedDateTime.of(data, time, ZoneId.of("Europe/London"));
            workflow.getOrCreateTimestamp(0).setDateTime(ts);
            workflow.getOrCreateTimestamp(0).setQualification(EventTimestampQualificationEnum.EVENT_CREATION_DATE_TIME);
        });
        this.buildTradeStateMapping("Collateral_Type_IND", (FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder>)this.capture("CollateralType"));
        this.buildTradeStateMapping("Activity_Rate", (FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder>)this.capture("ActivityRate"));
        this.addPostCaptureProcessors((captures, workflow) -> {
            Optional colatCap = this.any(captures.get((Object)"CollateralType"));
            Optional rateCap = this.any(captures.get((Object)"ActivityRate"));
            if (colatCap.isPresent() && rateCap.isPresent()) {
                String colat = ((Capture)colatCap.get()).getValue();
                BigDecimal rate = this.parseDecimal(((Capture)rateCap.get()).getValue());
                Stream<InterestRatePayout.InterestRatePayoutBuilder> allIRPs = Streams.concat((Stream[])new Stream[]{Stream.of((TradeState.TradeStateBuilder)this.getTradeState((FlatFileMappingProcessor.PathValue<WorkflowStep.WorkflowStepBuilder>)new FlatFileMappingProcessor.PathValue(BASE_PATH, workflow)).getValue()), Streams.stream((Iterable)Iterables.skip(workflow.getOrCreateBusinessEvent().getAfter(), (int)1))}).map(s -> new FlatFileMappingProcessor.PathValue(BASE_PATH, s)).map(this::getIRP).map(FlatFileMappingProcessor.PathValue::getValue);
                if ("C".equals(colat) && rate.compareTo(BigDecimal.ZERO) >= 0) {
                    allIRPs.forEach(irp -> {
                        irp.getOrCreatePayerReceiver().setPayer(CounterpartyRoleEnum.PARTY_1);
                        irp.getOrCreatePayerReceiver().setReceiver(CounterpartyRoleEnum.PARTY_2);
                    });
                } else {
                    allIRPs.forEach(irp -> {
                        irp.getOrCreatePayerReceiver().setPayer(CounterpartyRoleEnum.PARTY_2);
                        irp.getOrCreatePayerReceiver().setReceiver(CounterpartyRoleEnum.PARTY_1);
                    });
                }
            }
        });
    }

    private Multimap<String, FlatFileMappingProcessor.MappingConsumer<TradeState.TradeStateBuilder>> buildCommonMappings() {
        HashMultimap commonMappings = HashMultimap.create();
        commonMappings.put((Object)"Own_Cpty_LEI", (indexes, value, tradeState) -> {
            Party.PartyBuilder party = ((TradeState.TradeStateBuilder)tradeState.getValue()).getOrCreateTrade().getOrCreateParty(1);
            party.getOrCreatePartyId(0).setIdentifierValue(value);
            party.getOrCreateMeta().setExternalKey(AGENT_LENDER);
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Own_Client_Identifier", (indexes, value, tradeState) -> {
            ((TradeState.TradeStateBuilder)tradeState.getValue()).getOrCreateTrade().getOrCreateParty(1).getOrCreateName().setValue(value);
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Client_Identifier", (indexes, value, tradeState) -> {
            Party.PartyBuilder party = ((TradeState.TradeStateBuilder)tradeState.getValue()).getOrCreateTrade().getOrCreateParty(2);
            party.getOrCreateName().setValue(value);
            party.getOrCreateMeta().setExternalKey(BORROWER);
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Cpty_LEI", (indexes, value, tradeState) -> {
            PartyIdentifier.PartyIdentifierBuilder partyId = ((TradeState.TradeStateBuilder)tradeState.getValue()).getOrCreateTrade().getOrCreateParty(2).getOrCreatePartyId(0);
            partyId.setIdentifierValue(value);
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Effective_Date", (indexes, value, tradeState) -> {
            AdjustableDate.AdjustableDateBuilder orCreateAdjustableDate = ((EconomicTerms.EconomicTermsBuilder)this.getEcTerms((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState).getValue()).getOrCreateEffectiveDate().getOrCreateAdjustableDate();
            orCreateAdjustableDate.setUnadjustedDate(this.parseISODate(value));
            orCreateAdjustableDate.getOrCreateDateAdjustments().setBusinessDayConvention(BusinessDayConventionEnum.MODFOLLOWING);
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Activity_Rate", (indexes, value, tradeState) -> {
            FlatFileMappingProcessor.PathValue<PriceQuantity.PriceQuantityBuilder> pq = this.getPriceQuantityForInterestRatePayout((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState);
            ((PriceQuantity.PriceQuantityBuilder)pq.getValue()).getOrCreatePrice(0).getOrCreateValue().setValue(this.parseDecimal(value)).setPriceType(PriceTypeEnum.INTEREST_RATE);
            Reference.ReferenceBuilderImpl reference = Reference.builder();
            FlatFileMappingProcessor.PathValue<InterestRatePayout.InterestRatePayoutBuilder> irp = this.getIRP((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState);
            ((InterestRatePayout.InterestRatePayoutBuilder)irp.getValue()).getOrCreateRateSpecification().getOrCreateFixedRateSpecification().getOrCreateRateSchedule().getOrCreatePrice().setReference((Reference)reference);
            return Arrays.asList(new FlatFileMappingProcessor.PathValue(pq.getModelPath().append(Path.parse((String)"price[0].value.amount")), (Object)value), new FlatFileMappingProcessor.PathValue(irp.getModelPath().append(Path.parse((String)"rateSpecification.FixedRateSpecification.rateSchedule.price.reference")), (Object)reference));
        });
        commonMappings.put((Object)"Loan_Value", (indexes, value, tradeState) -> {
            FlatFileMappingProcessor.PathValue<PriceQuantity.PriceQuantityBuilder> pq = this.getPriceQuantityForInterestRatePayout((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState);
            ((PriceQuantity.PriceQuantityBuilder)pq.getValue()).getOrCreateQuantity(0).getOrCreateValue().setValue(this.parseDecimal(value));
            Reference.ReferenceBuilderImpl reference = Reference.builder();
            FlatFileMappingProcessor.PathValue<InterestRatePayout.InterestRatePayoutBuilder> irp = this.getIRP((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState);
            ((InterestRatePayout.InterestRatePayoutBuilder)irp.getValue()).getOrCreatePriceQuantity().getOrCreateQuantitySchedule().setReference((Reference)reference);
            return Arrays.asList(new FlatFileMappingProcessor.PathValue(pq.getModelPath().append(Path.parse((String)"quantity[0].value.amount")), (Object)value), new FlatFileMappingProcessor.PathValue(irp.getModelPath().append(Path.parse((String)"priceQuantity.quantitySchedule.reference")), (Object)reference));
        });
        commonMappings.put((Object)"Loan_Value_Currency", (indexes, value, tradeState) -> {
            UnitType.UnitTypeBuilder currencyUnit = UnitType.builder().setCurrency(FieldWithMetaString.builder().setValue(value));
            FlatFileMappingProcessor.PathValue<PriceQuantity.PriceQuantityBuilder> pq = this.getPriceQuantityForInterestRatePayout((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState);
            ((PriceQuantity.PriceQuantityBuilder)pq.getValue()).getOrCreatePrice(0).getOrCreateValue().setUnit(currencyUnit).setPerUnitOf(currencyUnit);
            ((PriceQuantity.PriceQuantityBuilder)pq.getValue()).getOrCreateQuantity(0).getOrCreateValue().setUnit(currencyUnit);
            return Arrays.asList(new FlatFileMappingProcessor.PathValue(pq.getModelPath().append(Path.parse((String)"price[0].value.unitOfAmount.currency.value")), (Object)value), new FlatFileMappingProcessor.PathValue(pq.getModelPath().append(Path.parse((String)"price[0].value.perUnitOfAmount.currency.value")), (Object)value), new FlatFileMappingProcessor.PathValue(pq.getModelPath().append(Path.parse((String)"quantity[0].value.unitOfAmount.currency.value")), (Object)value));
        });
        commonMappings.put((Object)"Activity_Price", (indexes, value, tradeState) -> {
            ((PriceQuantity.PriceQuantityBuilder)this.getPriceQuantityForSecurityFinancePayout((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState).getValue()).getOrCreatePrice(0).getOrCreateValue().setValue(this.parseDecimal(value)).setPriceType(PriceTypeEnum.ASSET_PRICE).setPerUnitOf(UnitType.builder().setFinancialUnit(FinancialUnitEnum.SHARE));
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Security_Prcing_Curr", (indexes, value, tradeState) -> {
            ((PriceQuantity.PriceQuantityBuilder)this.getPriceQuantityForSecurityFinancePayout((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState).getValue()).getOrCreatePrice(0).getOrCreateValue().getOrCreateUnit().getOrCreateCurrency().setValue(value);
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Quantity", (indexes, value, tradeState) -> {
            ((PriceQuantity.PriceQuantityBuilder)this.getPriceQuantityForSecurityFinancePayout((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState).getValue()).getOrCreateQuantity(0).getOrCreateValue().setValue(this.parseDecimal(value)).setUnit(UnitType.builder().setFinancialUnit(FinancialUnitEnum.SHARE));
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Effective_Date", (indexes, value, tradeState) -> {
            AdjustableDate.AdjustableDateBuilder adjDate = ((InterestRatePayout.InterestRatePayoutBuilder)this.getIRP((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState).getValue()).getOrCreateCalculationPeriodDates().getOrCreateEffectiveDate().getOrCreateAdjustableDate();
            adjDate.setAdjustedDateValue(this.parseISODate(value));
            adjDate.getOrCreateMeta().setExternalKey("Effective_Date");
            adjDate.getOrCreateDateAdjustments().setBusinessDayConvention(BusinessDayConventionEnum.MODFOLLOWING);
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Net_Dividend_pct", (indexes, value, tradeState) -> {
            ((AssetPayout.AssetPayoutBuilder)this.getSecPO((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState).getValue()).getOrCreateDividendTerms().getOrCreateManufacturedIncomeRequirement().setTotalRatio(this.parseDecimal(value).divide(BigDecimal.valueOf(100L)));
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Collateral_Type_IND", (indexes, value, tradeState) -> {
            ((CollateralProvisions.CollateralProvisionsBuilder)this.getColPro((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState).getValue()).setCollateralType(this.parseCollateralType(value));
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Required_Trade_Mrgn", (indexes, value, tradeState) -> {
            ((CollateralProvisions.CollateralProvisionsBuilder)this.getColPro((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState).getValue()).getOrCreateEligibleCollateral(0).getOrCreateTreatment().getOrCreateValuationTreatment().setMarginPercentage(this.parseDecimal(value).divide(BigDecimal.valueOf(100L)));
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Minimum_Fee_Currency", (indexes, value, tradeState) -> {
            ((AssetPayout.AssetPayoutBuilder)this.getSecPO((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState).getValue()).getOrCreateMinimumFee().getOrCreateUnit().getOrCreateCurrency().setValue(value);
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Minimum_Fee", (indexes, value, tradeState) -> {
            ((AssetPayout.AssetPayoutBuilder)this.getSecPO((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState).getValue()).getOrCreateMinimumFee().setValue(this.parseDecimal(value));
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Security_Sedol_Code", (indexes, value, tradeState) -> {
            FlatFileMappingProcessor.PathValue<PriceQuantity.PriceQuantityBuilder> pq = this.getPriceQuantityForSecurityFinancePayout((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState);
            Security.SecurityBuilder security = Security.builder().setInstrumentType(InstrumentTypeEnum.EQUITY).addIdentifier(AssetIdentifier.builder().setIdentifierValue(value).setIdentifierType(AssetIdTypeEnum.SEDOL));
            ((PriceQuantity.PriceQuantityBuilder)pq.getValue()).getOrCreateObservable().getOrCreateValue().getOrCreateAsset().getOrCreateInstrument().setSecurity(security);
            Reference.ReferenceBuilderImpl reference = Reference.builder();
            FlatFileMappingProcessor.PathValue<AssetPayout.AssetPayoutBuilder> secLendingPayout = this.getSecPO((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState);
            ((AssetPayout.AssetPayoutBuilder)secLendingPayout.getValue()).getOrCreateUnderlier().getOrCreateInstrument().setSecurity(security);
            return Arrays.asList(new FlatFileMappingProcessor.PathValue(pq.getModelPath().append(Path.parse((String)"observable.value.Asset.value.Instrument.security")), (Object)value), new FlatFileMappingProcessor.PathValue(secLendingPayout.getModelPath().append(Path.parse((String)"securityInformation.identifier.identifier.value")), (Object)reference));
        });
        commonMappings.put((Object)"DVP_Indicator", (indexes, value, tradeState) -> {
            ((AssetPayout.AssetPayoutBuilder)this.getSecPO((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState).getValue()).getOrCreateAssetLeg(0).setDeliveryMethod(this.parseDeliveryMethod(value));
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Security_SettDueDt", (indexes, value, tradeState) -> {
            ((AssetPayout.AssetPayoutBuilder)this.getSecPO((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState).getValue()).getOrCreateAssetLeg(0).getOrCreateSettlementDate().getOrCreateAdjustableDate().setAdjustedDateValue(this.parseISODate(value));
            ((AssetPayout.AssetPayoutBuilder)this.getSecPO((FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder>)tradeState).getValue()).getOrCreateAssetLeg(0).getOrCreateSettlementDate().getOrCreateAdjustableDate().getOrCreateDateAdjustments().setBusinessDayConvention(BusinessDayConventionEnum.NONE);
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Trade_Date", (indexes, value, tradeState) -> {
            ((TradeState.TradeStateBuilder)tradeState.getValue()).getOrCreateTrade().getOrCreateTradeDate().setValue(this.parseISODate(value));
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        commonMappings.put((Object)"Trade_Reference", (indexes, value, tradeState) -> {
            ((TradeState.TradeStateBuilder)tradeState.getValue()).getOrCreateTrade().getOrCreateTradeIdentifier(0).getOrCreateAssignedIdentifier(0).getOrCreateIdentifier().setValue(value);
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        return commonMappings;
    }

    private void buildTradeStateMappings(Multimap<String, FlatFileMappingProcessor.MappingConsumer<TradeState.TradeStateBuilder>> commonMappings) {
        this.addMapping(IndexCapturePath.parse((String)"FIS_TRADE.Activity[0]"), (indexes, value, workflow) -> {
            this.staticMappings(this.getTradeState((FlatFileMappingProcessor.PathValue<WorkflowStep.WorkflowStepBuilder>)workflow));
            return Collections.emptyList();
        });
        this.addMapping(IndexCapturePath.parse((String)"FIS_TRADE.Activity[0]"), (indexes, value, workflow) -> {
            ((WorkflowStep.WorkflowStepBuilder)workflow.getValue()).getOrCreateBusinessEvent().getOrCreateAfter(0).getOrCreateMeta().setExternalKey("TradeState");
            ((WorkflowStep.WorkflowStepBuilder)workflow.getValue()).getOrCreateBusinessEvent().getOrCreateInstruction(0).getOrCreateBefore().setExternalReference("TradeState");
            ((TradableProduct.TradableProductBuilder)this.getTradableProduct(this.getTradeState((FlatFileMappingProcessor.PathValue<WorkflowStep.WorkflowStepBuilder>)workflow)).getValue()).getOrCreateCounterparty(0).getOrCreatePartyReference().setExternalReference(AGENT_LENDER);
            return Collections.emptyList();
        });
        for (Map.Entry mapping : commonMappings.entries()) {
            this.buildTradeStateMapping((String)mapping.getKey(), (FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder>)((FlatFileMappingProcessor.MappingConsumer)(i, v, w) -> ((FlatFileMappingProcessor.MappingConsumer)mapping.getValue()).accept(i, v, this.getTradeState((FlatFileMappingProcessor.PathValue<WorkflowStep.WorkflowStepBuilder>)w))));
        }
        this.buildTradeStateMapping("Trade_Date", (FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder>)((FlatFileMappingProcessor.MappingConsumer)(indexes, value, workflow) -> {
            ((WorkflowStep.WorkflowStepBuilder)workflow.getValue()).getBusinessEvent().setEventDate(this.parseISODate(value));
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(workflow.getModelPath(), (Object)value));
        }));
    }

    private void buildAllocationMappings(Multimap<String, FlatFileMappingProcessor.MappingConsumer<TradeState.TradeStateBuilder>> commonMappings) {
        this.addMapping(IndexCapturePath.parse((String)"FIS_TRADE.Activity[allocationNumPlus1]"), this.allocaNumberMapConsumer((FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder>)((FlatFileMappingProcessor.MappingConsumer)(indexes, value, workflow) -> {
            this.staticMappings(this.getSplitTradeState((FlatFileMappingProcessor.PathValue<WorkflowStep.WorkflowStepBuilder>)workflow, indexes));
            return Collections.emptyList();
        })));
        for (Map.Entry mapping : commonMappings.entries()) {
            this.buildAllocationMapping((String)mapping.getKey(), (FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder>)((FlatFileMappingProcessor.MappingConsumer)(i, v, w) -> ((FlatFileMappingProcessor.MappingConsumer)mapping.getValue()).accept(i, v, this.getSplitTradeState((FlatFileMappingProcessor.PathValue<WorkflowStep.WorkflowStepBuilder>)w, i))));
        }
        commonMappings.put((Object)"Own_Client_Identifier", (indexes, value, tradeState) -> {
            ((TradeState.TradeStateBuilder)tradeState.getValue()).getOrCreateTrade().getOrCreateParty(1).setNameValue(value);
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(tradeState.getModelPath(), (Object)value));
        });
        this.buildAllocationMapping("Fund_LEI", (FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder>)((FlatFileMappingProcessor.MappingConsumer)(i, v, w) -> {
            FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder> splitTradeState = this.getSplitTradeState((FlatFileMappingProcessor.PathValue<WorkflowStep.WorkflowStepBuilder>)w, i);
            Party.PartyBuilder party = ((TradeState.TradeStateBuilder)splitTradeState.getValue()).getOrCreateTrade().getOrCreateParty(0);
            party.getOrCreatePartyId(0).setIdentifierValue(v);
            party.getOrCreateMeta().setExternalKey("Lender" + i.get("allocationNum"));
            ((TradableProduct.TradableProductBuilder)this.getTradableProduct(splitTradeState).getValue()).getOrCreateCounterparty(0).getOrCreatePartyReference().setExternalReference("Lender" + i.get("allocationNum"));
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(splitTradeState.getModelPath(), (Object)v));
        }));
        this.buildAllocationMapping("Fund_cost_Centre_Nme", (FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder>)((FlatFileMappingProcessor.MappingConsumer)(i, v, w) -> {
            ((TradeState.TradeStateBuilder)this.getSplitTradeState((FlatFileMappingProcessor.PathValue<WorkflowStep.WorkflowStepBuilder>)w, i).getValue()).getOrCreateTrade().getOrCreateParty(0).getOrCreateName().setValue(v);
            return Collections.singletonList(new FlatFileMappingProcessor.PathValue(w.getModelPath(), (Object)v));
        }));
        this.buildAllocationMapping("Activity_Input_Date", (FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder>)((FlatFileMappingProcessor.MappingConsumer)(i, v, w) -> Collections.emptyList()));
        this.buildAllocationMapping("Activity_Time_In_Milliseconds", (FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder>)((FlatFileMappingProcessor.MappingConsumer)(i, v, w) -> Collections.emptyList()));
    }

    private DeliveryMethodEnum parseDeliveryMethod(String value) {
        switch (value) {
            case "Y": {
                return DeliveryMethodEnum.DELIVERY_VERSUS_PAYMENT;
            }
        }
        return DeliveryMethodEnum.FREE_OF_PAYMENT;
    }

    private CollateralTypeEnum parseCollateralType(String value) {
        switch (value) {
            case "C": {
                return CollateralTypeEnum.CASH;
            }
            case "CP": {
                return CollateralTypeEnum.CASH_POOL;
            }
            case "NC": {
                return CollateralTypeEnum.NON_CASH;
            }
        }
        throw new RuntimeException("Unknown Collateral type");
    }

    private FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder> getTradeState(FlatFileMappingProcessor.PathValue<WorkflowStep.WorkflowStepBuilder> w) {
        return new FlatFileMappingProcessor.PathValue(w.getModelPath().append(Path.parse((String)"businessEvent.after[0]")), (Object)((WorkflowStep.WorkflowStepBuilder)w.getValue()).getOrCreateBusinessEvent().getOrCreateAfter(0));
    }

    private FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder> getSplitTradeState(FlatFileMappingProcessor.PathValue<WorkflowStep.WorkflowStepBuilder> w, Map<String, Integer> indexes) {
        int i = indexes.get("allocationNum") + 1;
        return new FlatFileMappingProcessor.PathValue(w.getModelPath().append(Path.parse((String)("businessEvent.after[" + i + "]"))), (Object)((WorkflowStep.WorkflowStepBuilder)w.getValue()).getOrCreateBusinessEvent().getOrCreateAfter(i));
    }

    private FlatFileMappingProcessor.PathValue<TradableProduct.TradableProductBuilder> getTradableProduct(FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder> pv) {
        return new FlatFileMappingProcessor.PathValue(pv.getModelPath().append(Path.parse((String)"trade")), (Object)((TradeState.TradeStateBuilder)pv.getValue()).getOrCreateTrade());
    }

    private FlatFileMappingProcessor.PathValue<InterestRatePayout.InterestRatePayoutBuilder> getIRP(FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder> ts) {
        FlatFileMappingProcessor.PathValue<EconomicTerms.EconomicTermsBuilder> et = this.getEcTerms(ts);
        return new FlatFileMappingProcessor.PathValue(et.getModelPath().addElement("payout", Integer.valueOf(1)).addElement("InterestRatePayout"), (Object)((EconomicTerms.EconomicTermsBuilder)et.getValue()).getOrCreatePayout(1).getOrCreateInterestRatePayout());
    }

    private FlatFileMappingProcessor.PathValue<EconomicTerms.EconomicTermsBuilder> getEcTerms(FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder> ts) {
        FlatFileMappingProcessor.PathValue<TradableProduct.TradableProductBuilder> tp = this.getTradableProduct(ts);
        return new FlatFileMappingProcessor.PathValue(tp.getModelPath().append(Path.parse((String)"product.economicTerms")), (Object)((TradableProduct.TradableProductBuilder)tp.getValue()).getOrCreateProduct().getOrCreateEconomicTerms());
    }

    private FlatFileMappingProcessor.PathValue<AssetPayout.AssetPayoutBuilder> getSecPO(FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder> ts) {
        FlatFileMappingProcessor.PathValue<EconomicTerms.EconomicTermsBuilder> et = this.getEcTerms(ts);
        return new FlatFileMappingProcessor.PathValue(et.getModelPath().addElement("payout", Integer.valueOf(0)).addElement("AssetPayout"), (Object)((EconomicTerms.EconomicTermsBuilder)et.getValue()).getOrCreatePayout(0).getOrCreateAssetPayout());
    }

    private FlatFileMappingProcessor.PathValue<CollateralProvisions.CollateralProvisionsBuilder> getColPro(FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder> ts) {
        FlatFileMappingProcessor.PathValue<EconomicTerms.EconomicTermsBuilder> et = this.getEcTerms(ts);
        return new FlatFileMappingProcessor.PathValue(et.getModelPath().addElement("collateral").addElement("collateralProvisions", Integer.valueOf(0)), (Object)((EconomicTerms.EconomicTermsBuilder)et.getValue()).getOrCreateCollateral().getOrCreateCollateralProvisions());
    }

    private FlatFileMappingProcessor.PathValue<PriceQuantity.PriceQuantityBuilder> getPriceQuantityForInterestRatePayout(FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder> ts) {
        FlatFileMappingProcessor.PathValue<TradableProduct.TradableProductBuilder> tp = this.getTradableProduct(ts);
        return new FlatFileMappingProcessor.PathValue(tp.getModelPath().addElement("tradeLot", Integer.valueOf(0)).addElement("priceQuantity", Integer.valueOf(0)), (Object)((TradableProduct.TradableProductBuilder)tp.getValue()).getOrCreateTradeLot(0).getOrCreatePriceQuantity(0));
    }

    private FlatFileMappingProcessor.PathValue<PriceQuantity.PriceQuantityBuilder> getPriceQuantityForSecurityFinancePayout(FlatFileMappingProcessor.PathValue<TradeState.TradeStateBuilder> ts) {
        FlatFileMappingProcessor.PathValue<TradableProduct.TradableProductBuilder> tp = this.getTradableProduct(ts);
        return new FlatFileMappingProcessor.PathValue(tp.getModelPath().addElement("tradeLot", Integer.valueOf(0)).addElement("priceQuantity", Integer.valueOf(1)), (Object)((TradableProduct.TradableProductBuilder)tp.getValue()).getOrCreateTradeLot(0).getOrCreatePriceQuantity(1));
    }

    private void buildTradeStateMapping(String xmlPath, FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder> consumer) {
        IndexCapturePath path = IndexCapturePath.parse((String)("FIS_TRADE.Activity[0]." + xmlPath));
        this.addMapping(path, this.nonNullConsumer(consumer));
    }

    private void buildAllocationMapping(String xmlPath, FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder> consumer) {
        IndexCapturePath path = IndexCapturePath.parse((String)("FIS_TRADE.Activity[allocationNumPlus1]." + xmlPath));
        this.addMapping(path, this.allocaNumberMapConsumer((FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder>)this.nonNullConsumer(consumer)));
    }

    private FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder> allocaNumberMapConsumer(FlatFileMappingProcessor.MappingConsumer<WorkflowStep.WorkflowStepBuilder> consumer) {
        return (i, v, w) -> {
            Integer allocationNumPlus1 = (Integer)i.get("allocationNumPlus1");
            if (allocationNumPlus1 != null && allocationNumPlus1 > 0) {
                Integer allocationNum = allocationNumPlus1 - 1;
                i.put("allocationNum", allocationNum);
                return consumer.accept(i, v, w);
            }
            return Collections.emptyList();
        };
    }
}

