/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.Reset;
import cdm.event.common.TradeState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.records.Date;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolveResetDefault.class)
public abstract class ResolveReset
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Reset evaluate(TradeState tradeState, Date date) {
        Reset reset;
        Reset.ResetBuilder resetBuilder = this.doEvaluate(tradeState, date);
        if (resetBuilder == null) {
            reset = null;
        } else {
            reset = resetBuilder.build();
            this.objectValidator.validate(Reset.class, (RosettaModelObject)reset);
        }
        return reset;
    }

    protected abstract Reset.ResetBuilder doEvaluate(TradeState var1, Date var2);

    public static class ResolveResetDefault
    extends ResolveReset {
        @Override
        protected Reset.ResetBuilder doEvaluate(TradeState tradeState, Date date) {
            Reset.ResetBuilder reset = Reset.builder();
            return this.assignOutput(reset, tradeState, date);
        }

        protected Reset.ResetBuilder assignOutput(Reset.ResetBuilder reset, TradeState tradeState, Date date) {
            return Optional.ofNullable(reset).map(o -> o.prune()).orElse(null);
        }
    }
}

