/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.Trade;
import cdm.event.common.functions.EquityNotionalAmount;
import cdm.event.common.functions.RateOfReturn;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.FieldWithMetaObservable;
import cdm.product.asset.functions.ResolvePerformancePeriodStartPrice;
import cdm.product.template.PerformancePayout;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=EquityPerformanceDefault.class)
public abstract class EquityPerformance
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected EquityNotionalAmount equityNotionalAmount;
    @Inject
    protected RateOfReturn rateOfReturn0;
    @Inject
    protected ResolvePerformancePeriodStartPrice resolvePerformancePeriodStartPrice;

    public BigDecimal evaluate(Trade trade, Price observation, Date date) {
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).map("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getPriceReturnTerms", returnTerms -> returnTerms.getPriceReturnTerms())), "");
        BigDecimal equityPerformance = this.doEvaluate(trade, observation, date);
        return equityPerformance;
    }

    protected abstract BigDecimal doEvaluate(Trade var1, Price var2, Date var3);

    protected abstract MapperS<? extends PerformancePayout> performancePayout(Trade var1, Price var2, Date var3);

    protected abstract MapperS<? extends PriceSchedule> periodStartPrice(Trade var1, Price var2, Date var3);

    protected abstract MapperS<? extends Price> periodEndPrice(Trade var1, Price var2, Date var3);

    protected abstract MapperS<BigDecimal> numberOfSecurities(Trade var1, Price var2, Date var3);

    protected abstract MapperS<BigDecimal> rateOfReturn1(Trade var1, Price var2, Date var3);

    protected abstract MapperS<BigDecimal> notionalAmount(Trade var1, Price var2, Date var3);

    public static class EquityPerformanceDefault
    extends EquityPerformance {
        @Override
        protected BigDecimal doEvaluate(Trade trade, Price observation, Date date) {
            BigDecimal equityPerformance = null;
            return this.assignOutput(equityPerformance, trade, observation, date);
        }

        protected BigDecimal assignOutput(BigDecimal equityPerformance, Trade trade, Price observation, Date date) {
            equityPerformance = (BigDecimal)MapperMaths.multiply(this.rateOfReturn1(trade, observation, date), this.notionalAmount(trade, observation, date)).get();
            return equityPerformance;
        }

        @Override
        protected MapperS<? extends PerformancePayout> performancePayout(Trade trade, Price observation, Date date) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).map("getPerformancePayout", payout -> payout.getPerformancePayout()).get()));
        }

        @Override
        protected MapperS<? extends PriceSchedule> periodStartPrice(Trade trade, Price observation, Date date) {
            FieldWithMetaObservable fieldWithMetaObservable = (FieldWithMetaObservable)MapperS.of((Object)trade).mapC("getTradeLot", _trade -> _trade.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).map("getObservable", priceQuantity -> priceQuantity.getObservable()).get();
            return MapperS.of((Object)this.resolvePerformancePeriodStartPrice.evaluate((PerformancePayout)this.performancePayout(trade, observation, date).get(), MapperS.of((Object)((TradeLot)MapperS.of((Object)trade).mapC("getTradeLot", _trade -> _trade.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti(), fieldWithMetaObservable == null ? null : fieldWithMetaObservable.getValue(), date));
        }

        @Override
        protected MapperS<? extends Price> periodEndPrice(Trade trade, Price observation, Date date) {
            return MapperS.of((Object)observation);
        }

        @Override
        protected MapperS<BigDecimal> numberOfSecurities(Trade trade, Price observation, Date date) {
            return MapperMaths.divide((Mapper)this.performancePayout(trade, observation, date).map("getPriceQuantity", _performancePayout -> _performancePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)this.periodStartPrice(trade, observation, date).map("getValue", priceSchedule -> priceSchedule.getValue()));
        }

        @Override
        protected MapperS<BigDecimal> rateOfReturn1(Trade trade, Price observation, Date date) {
            return MapperS.of((Object)this.rateOfReturn0.evaluate((PriceSchedule)this.periodStartPrice(trade, observation, date).get(), (PriceSchedule)this.periodEndPrice(trade, observation, date).get()));
        }

        @Override
        protected MapperS<BigDecimal> notionalAmount(Trade trade, Price observation, Date date) {
            return MapperS.of((Object)this.equityNotionalAmount.evaluate((BigDecimal)this.numberOfSecurities(trade, observation, date).get(), (Price)this.periodEndPrice(trade, observation, date).get()));
        }
    }
}

