/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.meta.ResetMeta;
import cdm.observable.asset.Price;
import cdm.observable.event.Observation;
import cdm.observable.event.metafields.ReferenceWithMetaObservation;
import cdm.product.template.AveragingCalculation;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Reset", builder=ResetBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="Reset", model="cdm", builder=ResetBuilderImpl.class, version="7.0.0-dev.50")
public interface Reset
extends RosettaModelObject,
GlobalKey {
    public static final ResetMeta metaData = new ResetMeta();

    public Price getResetValue();

    public Date getResetDate();

    public Date getRateRecordDate();

    public List<? extends ReferenceWithMetaObservation> getObservations();

    public AveragingCalculation getAveragingMethodology();

    public MetaFields getMeta();

    public Reset build();

    public ResetBuilder toBuilder();

    public static ResetBuilder builder() {
        return new ResetBuilderImpl();
    }

    default public RosettaMetaData<? extends Reset> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Reset> getType() {
        return Reset.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("resetValue"), processor, Price.class, this.getResetValue(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("resetDate"), Date.class, (Object)this.getResetDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rateRecordDate"), Date.class, (Object)this.getRateRecordDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observations"), processor, ReferenceWithMetaObservation.class, this.getObservations(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averagingMethodology"), processor, AveragingCalculation.class, this.getAveragingMethodology(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class ResetBuilderImpl
    implements ResetBuilder {
        protected Price.PriceBuilder resetValue;
        protected Date resetDate;
        protected Date rateRecordDate;
        protected List<ReferenceWithMetaObservation.ReferenceWithMetaObservationBuilder> observations = new ArrayList<ReferenceWithMetaObservation.ReferenceWithMetaObservationBuilder>();
        protected AveragingCalculation.AveragingCalculationBuilder averagingMethodology;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="resetValue", isRequired=true)
        @RuneAttribute(value="resetValue", isRequired=true)
        public Price.PriceBuilder getResetValue() {
            return this.resetValue;
        }

        @Override
        public Price.PriceBuilder getOrCreateResetValue() {
            Price.PriceBuilder result = this.resetValue != null ? this.resetValue : (this.resetValue = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="resetDate", isRequired=true)
        @RuneAttribute(value="resetDate", isRequired=true)
        public Date getResetDate() {
            return this.resetDate;
        }

        @Override
        @RosettaAttribute(value="rateRecordDate")
        @RuneAttribute(value="rateRecordDate")
        public Date getRateRecordDate() {
            return this.rateRecordDate;
        }

        @Override
        @RosettaAttribute(value="observations", isRequired=true)
        @RuneAttribute(value="observations", isRequired=true)
        public List<? extends ReferenceWithMetaObservation.ReferenceWithMetaObservationBuilder> getObservations() {
            return this.observations;
        }

        @Override
        public ReferenceWithMetaObservation.ReferenceWithMetaObservationBuilder getOrCreateObservations(int index) {
            if (this.observations == null) {
                this.observations = new ArrayList<ReferenceWithMetaObservation.ReferenceWithMetaObservationBuilder>();
            }
            return (ReferenceWithMetaObservation.ReferenceWithMetaObservationBuilder)this.getIndex(this.observations, index, () -> {
                ReferenceWithMetaObservation.ReferenceWithMetaObservationBuilder newObservations = ReferenceWithMetaObservation.builder();
                return newObservations;
            });
        }

        @Override
        @RosettaAttribute(value="averagingMethodology")
        @RuneAttribute(value="averagingMethodology")
        public AveragingCalculation.AveragingCalculationBuilder getAveragingMethodology() {
            return this.averagingMethodology;
        }

        @Override
        public AveragingCalculation.AveragingCalculationBuilder getOrCreateAveragingMethodology() {
            AveragingCalculation.AveragingCalculationBuilder result = this.averagingMethodology != null ? this.averagingMethodology : (this.averagingMethodology = AveragingCalculation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="resetValue", isRequired=true)
        @RuneAttribute(value="resetValue", isRequired=true)
        public ResetBuilder setResetValue(Price _resetValue) {
            this.resetValue = _resetValue == null ? null : _resetValue.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="resetDate", isRequired=true)
        @RuneAttribute(value="resetDate", isRequired=true)
        public ResetBuilder setResetDate(Date _resetDate) {
            this.resetDate = _resetDate == null ? null : _resetDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="rateRecordDate")
        @RuneAttribute(value="rateRecordDate")
        public ResetBuilder setRateRecordDate(Date _rateRecordDate) {
            this.rateRecordDate = _rateRecordDate == null ? null : _rateRecordDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="observations", isRequired=true)
        @RuneAttribute(value="observations", isRequired=true)
        public ResetBuilder addObservations(ReferenceWithMetaObservation _observations) {
            if (_observations != null) {
                this.observations.add(_observations.toBuilder());
            }
            return this;
        }

        @Override
        public ResetBuilder addObservations(ReferenceWithMetaObservation _observations, int idx) {
            this.getIndex(this.observations, idx, () -> _observations.toBuilder());
            return this;
        }

        @Override
        public ResetBuilder addObservationsValue(Observation _observations) {
            this.getOrCreateObservations(-1).setValue(_observations.toBuilder());
            return this;
        }

        @Override
        public ResetBuilder addObservationsValue(Observation _observations, int idx) {
            this.getOrCreateObservations(idx).setValue(_observations.toBuilder());
            return this;
        }

        @Override
        public ResetBuilder addObservations(List<? extends ReferenceWithMetaObservation> observationss) {
            if (observationss != null) {
                for (ReferenceWithMetaObservation referenceWithMetaObservation : observationss) {
                    this.observations.add(referenceWithMetaObservation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="observations")
        public ResetBuilder setObservations(List<? extends ReferenceWithMetaObservation> observationss) {
            this.observations = observationss == null ? new ArrayList<ReferenceWithMetaObservation.ReferenceWithMetaObservationBuilder>() : (List)observationss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ResetBuilder addObservationsValue(List<? extends Observation> observationss) {
            if (observationss != null) {
                for (Observation observation : observationss) {
                    this.addObservationsValue(observation);
                }
            }
            return this;
        }

        @Override
        public ResetBuilder setObservationsValue(List<? extends Observation> observationss) {
            this.observations.clear();
            if (observationss != null) {
                observationss.forEach(this::addObservationsValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingMethodology")
        @RuneAttribute(value="averagingMethodology")
        public ResetBuilder setAveragingMethodology(AveragingCalculation _averagingMethodology) {
            this.averagingMethodology = _averagingMethodology == null ? null : _averagingMethodology.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public ResetBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public Reset build() {
            return new ResetImpl(this);
        }

        @Override
        public ResetBuilder toBuilder() {
            return this;
        }

        @Override
        public ResetBuilder prune() {
            if (this.resetValue != null && !this.resetValue.prune().hasData()) {
                this.resetValue = null;
            }
            this.observations = this.observations.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.averagingMethodology != null && !this.averagingMethodology.prune().hasData()) {
                this.averagingMethodology = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getResetValue() != null && this.getResetValue().hasData()) {
                return true;
            }
            if (this.getResetDate() != null) {
                return true;
            }
            if (this.getRateRecordDate() != null) {
                return true;
            }
            if (this.getObservations() != null && this.getObservations().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getAveragingMethodology() != null && this.getAveragingMethodology().hasData();
        }

        public ResetBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ResetBuilder o = (ResetBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getResetValue(), (RosettaModelObjectBuilder)o.getResetValue(), this::setResetValue);
            merger.mergeRosetta(this.getObservations(), o.getObservations(), this::getOrCreateObservations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAveragingMethodology(), (RosettaModelObjectBuilder)o.getAveragingMethodology(), this::setAveragingMethodology);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getResetDate(), (Object)o.getResetDate(), this::setResetDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRateRecordDate(), (Object)o.getRateRecordDate(), this::setRateRecordDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Reset _that = this.getType().cast(o);
            if (!Objects.equals(this.resetValue, _that.getResetValue())) {
                return false;
            }
            if (!Objects.equals(this.resetDate, _that.getResetDate())) {
                return false;
            }
            if (!Objects.equals(this.rateRecordDate, _that.getRateRecordDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.observations, _that.getObservations())) {
                return false;
            }
            if (!Objects.equals(this.averagingMethodology, _that.getAveragingMethodology())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.resetValue != null ? this.resetValue.hashCode() : 0);
            _result = 31 * _result + (this.resetDate != null ? this.resetDate.hashCode() : 0);
            _result = 31 * _result + (this.rateRecordDate != null ? this.rateRecordDate.hashCode() : 0);
            _result = 31 * _result + (this.observations != null ? this.observations.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethodology != null ? this.averagingMethodology.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ResetBuilder {resetValue=" + this.resetValue + ", resetDate=" + this.resetDate + ", rateRecordDate=" + this.rateRecordDate + ", observations=" + this.observations + ", averagingMethodology=" + this.averagingMethodology + ", meta=" + this.meta + '}';
        }
    }

    public static interface ResetBuilder
    extends Reset,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public Price.PriceBuilder getOrCreateResetValue();

        @Override
        public Price.PriceBuilder getResetValue();

        public ReferenceWithMetaObservation.ReferenceWithMetaObservationBuilder getOrCreateObservations(int var1);

        public List<? extends ReferenceWithMetaObservation.ReferenceWithMetaObservationBuilder> getObservations();

        public AveragingCalculation.AveragingCalculationBuilder getOrCreateAveragingMethodology();

        @Override
        public AveragingCalculation.AveragingCalculationBuilder getAveragingMethodology();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public ResetBuilder setResetValue(Price var1);

        public ResetBuilder setResetDate(Date var1);

        public ResetBuilder setRateRecordDate(Date var1);

        public ResetBuilder addObservations(ReferenceWithMetaObservation var1);

        public ResetBuilder addObservations(ReferenceWithMetaObservation var1, int var2);

        public ResetBuilder addObservationsValue(Observation var1);

        public ResetBuilder addObservationsValue(Observation var1, int var2);

        public ResetBuilder addObservations(List<? extends ReferenceWithMetaObservation> var1);

        public ResetBuilder setObservations(List<? extends ReferenceWithMetaObservation> var1);

        public ResetBuilder addObservationsValue(List<? extends Observation> var1);

        public ResetBuilder setObservationsValue(List<? extends Observation> var1);

        public ResetBuilder setAveragingMethodology(AveragingCalculation var1);

        public ResetBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("resetValue"), processor, Price.PriceBuilder.class, this.getResetValue(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("resetDate"), Date.class, (Object)this.getResetDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rateRecordDate"), Date.class, (Object)this.getRateRecordDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observations"), processor, ReferenceWithMetaObservation.ReferenceWithMetaObservationBuilder.class, this.getObservations(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averagingMethodology"), processor, AveragingCalculation.AveragingCalculationBuilder.class, this.getAveragingMethodology(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public ResetBuilder prune();
    }

    public static class ResetImpl
    implements Reset {
        private final Price resetValue;
        private final Date resetDate;
        private final Date rateRecordDate;
        private final List<? extends ReferenceWithMetaObservation> observations;
        private final AveragingCalculation averagingMethodology;
        private final MetaFields meta;

        protected ResetImpl(ResetBuilder builder) {
            this.resetValue = Optional.ofNullable(builder.getResetValue()).map(f -> f.build()).orElse(null);
            this.resetDate = builder.getResetDate();
            this.rateRecordDate = builder.getRateRecordDate();
            this.observations = Optional.ofNullable(builder.getObservations()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.averagingMethodology = Optional.ofNullable(builder.getAveragingMethodology()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="resetValue", isRequired=true)
        @RuneAttribute(value="resetValue", isRequired=true)
        public Price getResetValue() {
            return this.resetValue;
        }

        @Override
        @RosettaAttribute(value="resetDate", isRequired=true)
        @RuneAttribute(value="resetDate", isRequired=true)
        public Date getResetDate() {
            return this.resetDate;
        }

        @Override
        @RosettaAttribute(value="rateRecordDate")
        @RuneAttribute(value="rateRecordDate")
        public Date getRateRecordDate() {
            return this.rateRecordDate;
        }

        @Override
        @RosettaAttribute(value="observations", isRequired=true)
        @RuneAttribute(value="observations", isRequired=true)
        public List<? extends ReferenceWithMetaObservation> getObservations() {
            return this.observations;
        }

        @Override
        @RosettaAttribute(value="averagingMethodology")
        @RuneAttribute(value="averagingMethodology")
        public AveragingCalculation getAveragingMethodology() {
            return this.averagingMethodology;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Reset build() {
            return this;
        }

        @Override
        public ResetBuilder toBuilder() {
            ResetBuilder builder = Reset.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ResetBuilder builder) {
            Optional.ofNullable(this.getResetValue()).ifPresent(builder::setResetValue);
            Optional.ofNullable(this.getResetDate()).ifPresent(builder::setResetDate);
            Optional.ofNullable(this.getRateRecordDate()).ifPresent(builder::setRateRecordDate);
            Optional.ofNullable(this.getObservations()).ifPresent(builder::setObservations);
            Optional.ofNullable(this.getAveragingMethodology()).ifPresent(builder::setAveragingMethodology);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Reset _that = this.getType().cast(o);
            if (!Objects.equals(this.resetValue, _that.getResetValue())) {
                return false;
            }
            if (!Objects.equals(this.resetDate, _that.getResetDate())) {
                return false;
            }
            if (!Objects.equals(this.rateRecordDate, _that.getRateRecordDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.observations, _that.getObservations())) {
                return false;
            }
            if (!Objects.equals(this.averagingMethodology, _that.getAveragingMethodology())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.resetValue != null ? this.resetValue.hashCode() : 0);
            _result = 31 * _result + (this.resetDate != null ? this.resetDate.hashCode() : 0);
            _result = 31 * _result + (this.rateRecordDate != null ? this.rateRecordDate.hashCode() : 0);
            _result = 31 * _result + (this.observations != null ? this.observations.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethodology != null ? this.averagingMethodology.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Reset {resetValue=" + this.resetValue + ", resetDate=" + this.resetDate + ", rateRecordDate=" + this.rateRecordDate + ", observations=" + this.observations + ", averagingMethodology=" + this.averagingMethodology + ", meta=" + this.meta + '}';
        }
    }
}

