# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SettlementPayout']

from cdm.product.common.settlement.PayoutBase import PayoutBase

class SettlementPayout(PayoutBase):
    """
    Represents a forward settling payout. The underlier attribute captures the underlying payout, which is settled according to the settlementTerms attribute (which is part of PayoutBase). Both FX Spot and FX Forward should use this component.
    """
    underlier: cdm.product.template.Underlier.Underlier = Field(..., description="The underlying financial product that will be physically or cash settled, which can be of any type, eg an asset such as cash or a security, or the cash settlement of an index rate.")
    """
    The underlying financial product that will be physically or cash settled, which can be of any type, eg an asset such as cash or a security, or the cash settlement of an index rate.
    """
    deliveryTerm: Optional[str] = Field(None, description="Also called contract month or delivery month. However, it's not always a month. It is usually expressed using a code, e.g. Z23 would be the Dec 2023 contract, (Z = December). For crude oil, the corresponding contract might be called CLZ23.")
    """
    Also called contract month or delivery month. However, it's not always a month. It is usually expressed using a code, e.g. Z23 would be the Dec 2023 contract, (Z = December). For crude oil, the corresponding contract might be called CLZ23.
    """
    delivery: Optional[cdm.product.asset.AssetDeliveryInformation.AssetDeliveryInformation] = Field(None, description="Contains the information relative to the delivery of the asset.")
    """
    Contains the information relative to the delivery of the asset.
    """
    schedule: Optional[cdm.product.template.CalculationSchedule.CalculationSchedule] = Field(None, description="Allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.")
    """
    Allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.
    """
    
    @rosetta_condition
    def condition_0_Underlier(self):
        """
        The underlier for a settlement payout cannot be a NonTransferableProduct.
        """
        item = self
        return (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "Product"), "NonTransferableProduct")))
    
    @rosetta_condition
    def condition_1_Basket(self):
        """
        If the underlier is a basket, it must contain only transferable assets.
        """
        item = self
        def _then_fn0():
            return all_elements(list(map(lambda item: rosetta_attr_exists(rosetta_resolve_attr(item, "Asset")), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "Observable"), "Basket"), "basketConstituent"))), "=", True)
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "Observable"), "Basket")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_Index(self):
        """
        If the underlier is an Index, then it can only be cash settled.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "settlementTerms"), "cashSettlementTerms"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "Observable"), "Index")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_3_SettlementTerms(self):
        """
        Settlement Terms should be defined except for cash.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "settlementTerms"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "Observable"), "Asset"), "Cash")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_4_DeliveryCapacity(self):
        """
        Checks that only one of the representations of delivery capacity is present simultaneously.
        """
        item = self
        def _then_fn3():
            return (((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "deliveryCapacity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity"))))
        
        def _else_fn3():
            return True
        
        def _then_fn2():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity"))))
        
        def _else_fn2():
            return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity")), _then_fn3, _else_fn3)
        
        def _then_fn1():
            return (((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "deliveryCapacity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity"))))
        
        def _else_fn1():
            return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")), _then_fn2, _else_fn2)
        
        def _then_fn0():
            return (((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity"))))
        
        def _else_fn0():
            return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity")), _then_fn1, _else_fn1)
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "deliveryCapacity")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_5_PriceTimeIntervalQuantity(self):
        """
        Checks that only one of the representations of price time interval quantity is present simultaneously.
        """
        item = self
        def _then_fn2():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "priceTimeIntervalQuantity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "priceTimeIntervalQuantity"))))
        
        def _else_fn2():
            return True
        
        def _then_fn1():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "priceTimeIntervalQuantity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "priceTimeIntervalQuantity"))))
        
        def _else_fn1():
            return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "priceTimeIntervalQuantity")), _then_fn2, _else_fn2)
        
        def _then_fn0():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "priceTimeIntervalQuantity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "priceTimeIntervalQuantity"))))
        
        def _else_fn0():
            return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "priceTimeIntervalQuantity")), _then_fn1, _else_fn1)
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "priceTimeIntervalQuantity")), _then_fn0, _else_fn0)

import cdm 
import cdm.product.template.Underlier
import cdm.product.asset.AssetDeliveryInformation
import cdm.product.template.CalculationSchedule
