# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SchedulePeriod']


class SchedulePeriod(BaseDataClass):
    """
    A class that defines the period of a schedule. The period contains a set of start and end dates, quantities, fixing, and pricing data.
    """
    calculationPeriod: cdm.base.datetime.DateRange.DateRange = Field(..., description="Period for which the payment is generated.")
    """
    Period for which the payment is generated.
    """
    paymentDate: datetime.date = Field(..., description="Adjusted payment date.")
    """
    Adjusted payment date.
    """
    fixingPeriod: cdm.base.datetime.DateRange.DateRange = Field(..., description="Period over which the underlying price is observed.")
    """
    Period over which the underlying price is observed.
    """
    deliveryPeriod: Optional[cdm.product.asset.CalculationScheduleDeliveryPeriods.CalculationScheduleDeliveryPeriods] = Field(None, description="Period and time profile over which the delivery takes place.")
    """
    Period and time profile over which the delivery takes place.
    """

import cdm 
import cdm.base.datetime.DateRange
import cdm.product.asset.CalculationScheduleDeliveryPeriods
